/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class ThreadsTablePanel
extends JPanel
implements ActionListener,
DataManagerListener {
    private ThreadsDataManager tdmanager;
    private ThreadsDetailsCallback detailsCallback;
    private JExtendedTable resTable;
    private ExtendedTableModel resTableModel;
    private JExtendedTablePanel resTablePanel;
    private JComboBox threadsSelectionCombo;
    private JToolBar buttonsToolBar;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showThreadsDetails;
    private JPopupMenu popupMenu;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private ArrayList<Data> filteredDataToDataIndex = new ArrayList();
    private int sortingColumn = 1;
    protected boolean sortOrder = false;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    private int minNamesColumnWidth;
    private boolean internalChange = false;
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsTablePanel_ThreadsColumnName");
    private static final String RUNNING_COLUMN_NAME = messages.getString("ThreadsTablePanel_RunningColumnName");
    private static final String SLEEPING_COLUMN_NAME = messages.getString("ThreadsTablePanel_SleepingColumnName");
    private static final String WAIT_COLUMN_NAME = messages.getString("ThreadsTablePanel_WaitColumnName");
    private static final String MONITOR_COLUMN_NAME = messages.getString("ThreadsTablePanel_MonitorColumnName");
    private static final String TOTAL_COLUMN_NAME = messages.getString("ThreadsTablePanel_TotalColumnName");
    private static final String THREADS_COLUMN_DESCR = messages.getString("ThreadsTablePanel_ThreadsColumnDescr");
    private static final String RUNNING_COLUMN_DESCR = messages.getString("ThreadsTablePanel_RunningColumnDescr");
    private static final String SLEEPING_COLUMN_DESCR = messages.getString("ThreadsTablePanel_SleepingColumnDescr");
    private static final String WAIT_COLUMN_DESCR = messages.getString("ThreadsTablePanel_WaitColumnDescr");
    private static final String MONITOR_COLUMN_DESCR = messages.getString("ThreadsTablePanel_MonitorColumnDescr");
    private static final String TOTAL_COLUMN_DESCR = messages.getString("ThreadsTablePanel_TotalColumnDescr");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String THREAD_DETAILS_ITEM = messages.getString("ThreadsPanel_ThreadDetailsItem");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");

    public ThreadsTablePanel(ThreadsDataManager manager, ThreadsDetailsCallback detailsCallback, boolean supportsSleepingState) {
        this.tdmanager = manager;
        this.detailsCallback = detailsCallback;
        this.initColumnsData();
        this.initComponents();
        this.tdmanager.addDataListener((DataManagerListener)this);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsTablePanel.this.isShowing()) {
                    ThreadsTablePanel.this.dataChanged();
                }
            }
        });
    }

    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsTablePanel.this.refreshUI();
            }
        });
    }

    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsTablePanel.this.refreshUI();
            }
        });
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.resTable.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void sortData() {
        Collections.sort(this.filteredDataToDataIndex, new Comparator(){

            public int compare(Object o1, Object o2) {
                Data data1 = (Data)o1;
                Data data2 = (Data)o2;
                switch (ThreadsTablePanel.this.sortingColumn) {
                    case 0: {
                        return ThreadsTablePanel.this.sortOrder ? data1.threadName.compareTo(data2.threadName) : data2.threadName.compareTo(data1.threadName);
                    }
                    case 1: {
                        return ThreadsTablePanel.this.sortOrder ? data1.runningTime.compareTo(data2.runningTime) : data2.runningTime.compareTo(data1.runningTime);
                    }
                    case 2: {
                        return ThreadsTablePanel.this.sortOrder ? data1.sleepingTime.compareTo(data2.sleepingTime) : data2.sleepingTime.compareTo(data1.sleepingTime);
                    }
                    case 3: {
                        return ThreadsTablePanel.this.sortOrder ? data1.waitTime.compareTo(data2.waitTime) : data2.waitTime.compareTo(data1.waitTime);
                    }
                    case 4: {
                        return ThreadsTablePanel.this.sortOrder ? data1.monitorTime.compareTo(data2.monitorTime) : data2.monitorTime.compareTo(data1.monitorTime);
                    }
                    case 5: {
                        return ThreadsTablePanel.this.sortOrder ? data1.totalTime.compareTo(data2.totalTime) : data2.totalTime.compareTo(data1.totalTime);
                    }
                }
                return 0;
            }
        });
    }

    private void updateFilteredData() {
        if (this.threadsSelectionCombo.getSelectedItem() == VIEW_THREADS_SELECTION) {
            return;
        }
        this.filteredDataToDataIndex.clear();
        for (int i = 0; i < this.tdmanager.getThreadsCount(); ++i) {
            byte state;
            ThreadData threadData;
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                threadData = this.tdmanager.getThreadData(i);
                if (threadData.size() <= 0 || (state = threadData.getLastState()) == 0) continue;
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
            threadData = this.tdmanager.getThreadData(i);
            if (threadData.size() > 0) {
                state = threadData.getLastState();
                if (state != 0) continue;
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            this.filteredDataToDataIndex.add(this.createData(i));
        }
        this.sortData();
    }

    private Data createData(int threadIndex) {
        ThreadData threadData = this.tdmanager.getThreadData(threadIndex);
        boolean dataAvailable = threadData.size() > 0;
        long runningTime = dataAvailable ? 0L : -1L;
        long sleepingTime = dataAvailable ? 0L : -1L;
        long waitTime = dataAvailable ? 0L : -1L;
        long monitorTime = dataAvailable ? 0L : -1L;
        block6: for (int i = 0; i < threadData.size(); ++i) {
            byte state = threadData.getStateAt(i);
            long stateDuration = this.getThreadStateDuration(threadData, i);
            switch (state) {
                case 1: {
                    runningTime += stateDuration;
                    continue block6;
                }
                case 2: {
                    sleepingTime += stateDuration;
                    continue block6;
                }
                case 4: {
                    waitTime += stateDuration;
                    continue block6;
                }
                case 3: {
                    monitorTime += stateDuration;
                }
            }
        }
        return new Data(threadIndex, this.tdmanager.getThreadName(threadIndex), runningTime, sleepingTime, waitTime, monitorTime, runningTime + sleepingTime + waitTime + monitorTime);
    }

    private long getThreadStateDuration(ThreadData threadData, int index) {
        long startTime = threadData.getTimeStampAt(index);
        long endTime = index < threadData.size() - 1 ? threadData.getTimeStampAt(index + 1) : this.tdmanager.getEndTime();
        return endTime - startTime;
    }

    private String getPercentValue(float value, float basevalue) {
        int basis = (int)(value / basevalue * 1000.0f);
        int percent = basis / 10;
        int permille = basis % 10;
        return "" + percent + "." + permille;
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ThreadsTablePanel.this.resTable != null) {
                    ThreadsTablePanel.this.resTable.requestFocus();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        if (e.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object selectedItem = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(selectedItem);
                this.internalChange = false;
            }
            this.resTable.clearSelection();
            this.dataChanged();
        } else if (e.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.resTable.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.resTable.clearSelection();
        } else if (e.getSource() == this.showThreadsDetails) {
            this.performDefaultAction();
        }
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        JButton actionButton = this.buttonsToolBar.add(saveViewAction);
        this.buttonsToolBar.remove(actionButton);
        this.buttonsToolBar.add((Component)actionButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    public boolean fitsVisibleArea() {
        return !this.resTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public boolean hasView() {
        return !this.filteredDataToDataIndex.isEmpty();
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.resTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    private JExtendedTable initTable() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            @Override
            public String getColumnName(int col) {
                return ThreadsTablePanel.this.columnNames[col];
            }

            @Override
            public int getRowCount() {
                return ThreadsTablePanel.this.filteredDataToDataIndex.size();
            }

            @Override
            public int getColumnCount() {
                return ThreadsTablePanel.this.columnNames.length;
            }

            public Class getColumnClass(int col) {
                return ThreadsTablePanel.this.columnTypes[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                Data data = (Data)ThreadsTablePanel.this.filteredDataToDataIndex.get(row);
                if (data.runningTime == -1L) {
                    return col == 0 ? data.threadName : "- (-%)";
                }
                switch (col) {
                    case 0: {
                        return data.threadName;
                    }
                    case 1: {
                        return data.runningTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.runningTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.runningTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 2: {
                        return data.sleepingTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.sleepingTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.sleepingTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 3: {
                        return data.waitTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.waitTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.waitTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 4: {
                        return data.monitorTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.monitorTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.monitorTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 5: {
                        return data.totalTime == 0L ? "0.0" : TimeLineUtils.getMillisValue2(data.totalTime);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int col) {
                return ThreadsTablePanel.this.columnToolTips[col];
            }

            @Override
            public void sortByColumn(int column, boolean order) {
                ThreadsTablePanel.this.sortingColumn = column;
                ThreadsTablePanel.this.sortOrder = order;
                int selectedRow = ThreadsTablePanel.this.resTable.getSelectedRow();
                String selectedRowContents = null;
                if (selectedRow != -1) {
                    selectedRowContents = (String)ThreadsTablePanel.this.resTable.getValueAt(selectedRow, 0);
                }
                ThreadsTablePanel.this.sortData();
                ThreadsTablePanel.this.refreshUI();
                if (selectedRowContents != null) {
                    ThreadsTablePanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                }
            }

            @Override
            public boolean getInitialSorting(int column) {
                switch (column) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.resTable = new JExtendedTable(this.resTableModel){

            @Override
            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < ThreadsTablePanel.this.resTableModel.getColumnCount(); ++i) {
                    int index = ThreadsTablePanel.this.resTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, ThreadsTablePanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTableModel.setTable(this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(2);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.resTable.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsTablePanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        return this.resTable;
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        LabelTableCellRenderer labelTableCellRenderer1 = new LabelTableCellRenderer(10);
        LabelTableCellRenderer labelTableCellRenderer2 = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{THREADS_COLUMN_NAME, RUNNING_COLUMN_NAME, SLEEPING_COLUMN_NAME, WAIT_COLUMN_NAME, MONITOR_COLUMN_NAME, TOTAL_COLUMN_NAME};
        this.columnToolTips = new String[]{THREADS_COLUMN_DESCR, RUNNING_COLUMN_DESCR, SLEEPING_COLUMN_DESCR, WAIT_COLUMN_DESCR, MONITOR_COLUMN_DESCR, TOTAL_COLUMN_DESCR};
        this.columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{labelTableCellRenderer1, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelTableCellRenderer2};
        this.columnWidths = new int[]{maxWidth, maxWidth, maxWidth, maxWidth, maxWidth, maxWidth};
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        if (this.detailsCallback != null) {
            Font boldfont = popup.getFont().deriveFont(1);
            this.showThreadsDetails = new JMenuItem(THREAD_DETAILS_ITEM);
            this.showThreadsDetails.setFont(boldfont);
            popup.add(this.showThreadsDetails);
            popup.add(new JSeparator());
        }
        popup.add(this.showOnlySelectedThreads);
        return popup;
    }

    private void performDefaultAction() {
        int[] array = this.resTable.getSelectedRows();
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.filteredDataToDataIndex.get((int)array[i]).threadIndex;
        }
        this.detailsCallback.showDetails(array);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.resTable = this.initTable();
        this.resTablePanel = new JExtendedTablePanel(this.resTable);
        this.resTablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), this.resTablePanel.getBorder()));
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(250, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel showLabel = new JLabel(SHOW_LABEL_TEXT);
        showLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        showLabel.setLabelFor(this.threadsSelectionCombo);
        int mnemCharIndex = 0;
        showLabel.setDisplayedMnemonic(showLabel.getText().charAt(mnemCharIndex));
        showLabel.setDisplayedMnemonicIndex(mnemCharIndex);
        this.buttonsToolBar = new JToolBar(0){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                return super.add(comp);
            }
        };
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.buttonsToolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), this.buttonsToolBar.getBorder()));
        this.buttonsToolBar.add(showLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.resTablePanel, "Center");
        this.threadsSelectionCombo.addActionListener(this);
        this.popupMenu = this.initPopupMenu();
        this.showOnlySelectedThreads.addActionListener(this);
        if (this.detailsCallback != null) {
            this.showThreadsDetails.addActionListener(this);
        }
        this.resTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsTablePanel.this.revalidate();
            }
        });
        this.resTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ThreadsTablePanel.this.resTable.getSelectedRow()) != -1) {
                    Rectangle cellRect = ThreadsTablePanel.this.resTable.getCellRect(selectedRow, 0, false);
                    ThreadsTablePanel.this.popupMenu.show(e.getComponent(), cellRect.x + ((ThreadsTablePanel)ThreadsTablePanel.this).resTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.resTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int line;
                if ((e.getModifiers() & 4) != 0 && (line = ThreadsTablePanel.this.resTable.rowAtPoint(e.getPoint())) != -1 && !ThreadsTablePanel.this.resTable.isRowSelected(line)) {
                    if (e.isControlDown()) {
                        ThreadsTablePanel.this.resTable.addRowSelectionInterval(line, line);
                    } else {
                        ThreadsTablePanel.this.resTable.setRowSelectionInterval(line, line);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickedLine = ThreadsTablePanel.this.resTable.rowAtPoint(e.getPoint());
                if (clickedLine != -1) {
                    if ((e.getModifiers() & 4) != 0) {
                        ThreadsTablePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        ThreadsTablePanel.this.performDefaultAction();
                    }
                }
            }
        });
    }

    private static class Data {
        Integer threadIndex;
        String threadName;
        Long runningTime;
        Long sleepingTime;
        Long waitTime;
        Long monitorTime;
        Long totalTime;

        public Data(Integer threadIndex, String threadName, Long runningTime, Long sleepingTime, Long waitTime, Long monitorTime, Long totalTime) {
            this.threadIndex = threadIndex;
            this.threadName = threadName;
            this.runningTime = runningTime;
            this.sleepingTime = sleepingTime;
            this.waitTime = waitTime;
            this.monitorTime = monitorTime;
            this.totalTime = totalTime;
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showDetails(int[] var1);
    }
}

