/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;

public class MethodNameTreeCellRenderer
extends EnhancedTreeCellRenderer {
    private ImageIcon allThreadsIcon = new ImageIcon(MethodNameTreeCellRenderer.class.getResource("/org/netbeans/lib/profiler/ui/resources/allThreads.png"));
    private ImageIcon threadIcon = new ImageIcon(MethodNameTreeCellRenderer.class.getResource("/org/netbeans/lib/profiler/ui/resources/thread.png"));

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        MethodNameTreeCellRenderer renderer = new MethodNameTreeCellRenderer();
        renderer.setLeafIcon(this.getLeafIcon(value));
        renderer.setClosedIcon(this.getClosedIcon(value));
        renderer.setOpenIcon(this.getOpenIcon(value));
        Color backgroundColor = UIUtils.getProfilerResultsBackground();
        if ((row & 1) == 0) {
            renderer.setBackgroundNonSelectionColor(UIUtils.getDarker(backgroundColor));
        } else {
            renderer.setBackgroundNonSelectionColor(backgroundColor);
        }
        return renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    protected Icon getClosedIcon(Object value) {
        PrestimeCPUCCTNode cct;
        if (value instanceof PrestimeCPUCCTNode && (cct = (PrestimeCPUCCTNode)value).isThreadNode()) {
            if (cct.getThreadId() == -1) {
                return this.allThreadsIcon;
            }
            return this.threadIcon;
        }
        return super.getClosedIcon(value);
    }

    @Override
    protected String getLabel1Text(Object node, String value) {
        int bracketIndex = value.indexOf(40);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return value;
        }
        if (bracketIndex != -1) {
            value = value.substring(0, bracketIndex);
            dotIndex = value.lastIndexOf(46);
        }
        return value.substring(0, dotIndex + 1);
    }

    @Override
    protected String getLabel2Text(Object node, String value) {
        int bracketIndex = value.indexOf(40);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return "";
        }
        if (bracketIndex != -1) {
            value = value.substring(0, bracketIndex);
            dotIndex = value.lastIndexOf(46);
        }
        return value.substring(dotIndex + 1);
    }

    @Override
    protected String getLabel3Text(Object node, String value) {
        int bracketIndex = value.indexOf(40);
        if (bracketIndex != -1) {
            return " " + value.substring(bracketIndex);
        }
        return "";
    }

    @Override
    protected Icon getLeafIcon(Object value) {
        PrestimeCPUCCTNode cct;
        if (value instanceof PrestimeCPUCCTNode && (cct = (PrestimeCPUCCTNode)value).isThreadNode()) {
            if (cct.getThreadId() == -1) {
                return this.allThreadsIcon;
            }
            return this.threadIcon;
        }
        return super.getLeafIcon(value);
    }

    @Override
    protected Icon getOpenIcon(Object value) {
        PrestimeCPUCCTNode cct;
        if (value instanceof PrestimeCPUCCTNode && (cct = (PrestimeCPUCCTNode)value).isThreadNode()) {
            if (cct.getThreadId() == -1) {
                return this.allThreadsIcon;
            }
            return this.threadIcon;
        }
        return super.getOpenIcon(value);
    }
}

