/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.TableCellRendererPersistent;

public class JExtendedTable
extends JTable
implements CellTipAware,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    protected int lastColumn = -1;
    protected int lastRow = -1;
    private String internalFindString;
    private String userFindString;
    private int userFindColumn;

    public JExtendedTable(TableModel model) {
        super(model);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.cellTip = this.createCellTip();
        this.cellTip.setBorder(BorderFactory.createLineBorder(this.getGridColor()));
        this.cellTip.setLayout(new BorderLayout());
        this.initListeners();
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    public int getFindColumn() {
        return this.userFindColumn;
    }

    public boolean isFindColumnValid() {
        return this.userFindColumn >= 0 && this.userFindColumn < this.getColumnCount();
    }

    public void setFindParameters(String findString, int findColumn) {
        this.userFindString = findString;
        this.userFindColumn = findColumn;
        this.internalFindString = this.getInternalFindString(this.userFindString);
    }

    public String getFindString() {
        return this.userFindString;
    }

    public boolean isFindStringDefined() {
        return this.userFindString != null && this.userFindString.trim().length() > 0;
    }

    @Override
    public void setGridColor(Color gridColor) {
        super.setGridColor(gridColor);
        if (gridColor == null || this.cellTip == null) {
            return;
        }
        this.cellTip.setBorder(BorderFactory.createLineBorder(gridColor));
    }

    public boolean canFindBePerformed() {
        return this.getRowCount() > 0 && this.isFindColumnValid() && this.isFindStringDefined();
    }

    public void ensureRowVisible(int row) {
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    public boolean findFirst() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        if (this.matchesFindCriterion(0)) {
            return this.selectFoundNode(0);
        }
        return this.doFindNext(0);
    }

    public boolean findNext() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        return this.doFindNext(this.getSearchRoot());
    }

    public boolean findPrevious() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        return this.doFindPrevious(this.getSearchRoot());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.contains(e.getPoint()) && this.cellTip.isShowing()) {
            return;
        }
        CellTipManager.sharedInstance().setEnabled(false);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int column = this.columnAtPoint(event.getPoint());
        if (row == this.lastRow && column == this.lastColumn) {
            return;
        }
        this.lastRow = row;
        this.lastColumn = column;
        if (row < 0 || column < 0) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(row, column);
        if (!(tableCellRenderer instanceof TableCellRendererPersistent)) {
            return;
        }
        Component cellRenderer = ((TableCellRendererPersistent)tableCellRenderer).getTableCellRendererComponentPersistent(this, this.getValueAt(row, column), false, false, row, column);
        Rectangle cellRect = this.getCellRect(row, column, false);
        if (cellRenderer == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        int horizontalAlignment = ((EnhancedTableCellRenderer)cellRenderer).getHorizontalAlignment();
        this.rendererRect = horizontalAlignment == 11 || horizontalAlignment == 4 ? new Rectangle(cellRect.x + cellRect.width - cellRenderer.getPreferredSize().width, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height) : new Rectangle(cellRect.x, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height);
        if (this.rendererRect.x >= cellRect.x && this.rendererRect.x + this.rendererRect.width <= cellRect.x + cellRect.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(cellRenderer, "Center");
        this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(row) + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseMoved(e);
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    public void selectRowByContents(String rowString, int columnIndex, boolean setVisible) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, columnIndex).toString().equals(rowString)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (setVisible) {
                this.ensureRowVisible(i);
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public void selectRowByInstance(Object instance, int columnIndex, boolean setVisible) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) != instance) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (setVisible) {
                this.ensureRowVisible(i);
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public void selectRowsByInstances(Object[] instances, int columnIndex, boolean setVisible) {
        int i;
        LinkedList<Object> instancesList = new LinkedList<Object>();
        for (i = 0; i < instances.length; ++i) {
            instancesList.add(instances[i]);
        }
        this.getSelectionModel().clearSelection();
        for (i = 0; i < this.getRowCount(); ++i) {
            if (!instancesList.contains(this.getValueAt(i, columnIndex))) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        if (setVisible && this.getSelectedRow() != -1) {
            this.ensureRowVisible(this.getSelectedRow());
        }
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    private boolean isAnyRowSelected() {
        return this.getSelectedRow() != -1;
    }

    private String getInternalFindString(String findString) {
        if (findString == null) {
            return null;
        }
        return findString.toLowerCase();
    }

    private int getSearchRoot() {
        if (!this.isAnyRowSelected()) {
            return 0;
        }
        return this.getSelectedRow();
    }

    private boolean doFindNext(int lastFoundRow) {
        for (int row = lastFoundRow + 1; row < this.getRowCount(); ++row) {
            if (!this.matchesFindCriterion(row)) continue;
            return this.selectFoundNode(row);
        }
        return false;
    }

    private boolean doFindPrevious(int lastFoundRow) {
        for (int row = lastFoundRow - 1; row >= 0; --row) {
            if (!this.matchesFindCriterion(row)) continue;
            return this.selectFoundNode(row);
        }
        return false;
    }

    private void initListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JExtendedTable.this.getSelectedRows().length > 0) {
                    JExtendedTable.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (JExtendedTable.this.getSelectedRows().length > 0) {
                    JExtendedTable.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int rowCount = JExtendedTable.this.getRowCount();
                switch (e.getKeyCode()) {
                    case 36: {
                        if (rowCount <= 0) break;
                        JExtendedTable.this.setRowSelectionInterval(0, 0);
                        break;
                    }
                    case 35: {
                        if (rowCount <= 0) break;
                        JExtendedTable.this.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                    }
                }
            }
        });
    }

    private boolean matchesFindCriterion(int row) {
        return this.getValueAt(row, this.userFindColumn).toString().toLowerCase().indexOf(this.internalFindString) != -1;
    }

    private boolean selectFoundNode(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        this.requestFocusInWindow();
        Rectangle rect = this.getCellRect(row, this.userFindColumn, true);
        if (rect != null) {
            this.scrollRectToVisible(rect);
            return true;
        }
        return false;
    }
}

