/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.modules.cnd.antlr.collections.AST;

public class Utils {
    private static boolean useSystemExit = true;
    private static boolean useDirectClassLoading = false;
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_AST = 3;

    private Utils() {
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (!useDirectClassLoading && contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static Object createInstanceOf(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Utils.loadClass(name).newInstance();
    }

    public static void error(String message) {
        if (useSystemExit) {
            System.exit(1);
        }
        throw new RuntimeException("ANTLR Panic: " + message);
    }

    public static void error(String message, Throwable t) {
        if (useSystemExit) {
            System.exit(1);
        }
        throw new RuntimeException("ANTLR Panic", t);
    }

    public static void writeAST(ObjectOutputStream out, AST ast) throws IOException {
        out.writeObject(ast);
        if (ast != null) {
            Utils.writeTree(out, ast);
        }
    }

    public static AST readAST(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AST ast = (AST)in.readObject();
        if (ast != null) {
            Utils.readTree(in, ast);
        }
        return ast;
    }

    private static void writeTree(ObjectOutputStream out, AST root) throws IOException {
        assert (root != null) : "there must be something to write";
        AST node = root;
        do {
            AST child;
            if ((child = node.getFirstChild()) != null) {
                out.writeInt(1);
                Utils.writeAST(out, child);
            }
            if ((node = node.getNextSibling()) == null) continue;
            out.writeInt(2);
            out.writeObject(node);
        } while (node != null);
        out.writeInt(3);
    }

    private static void readTree(ObjectInputStream in, AST root) throws IOException, ClassNotFoundException {
        assert (root != null) : "there must be something to read";
        AST node = root;
        do {
            int kind = in.readInt();
            switch (kind) {
                case 3: {
                    return;
                }
                case 1: {
                    node.setFirstChild(Utils.readAST(in));
                    break;
                }
                case 2: {
                    AST sibling = (AST)in.readObject();
                    node.setNextSibling(sibling);
                    node = sibling;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (node != null);
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("ANTLR_DO_NOT_EXIT", "false"))) {
            useSystemExit = false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("ANTLR_USE_DIRECT_CLASS_LOADING", "false"))) {
            useDirectClassLoading = true;
        }
    }
}

