/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.revert;

import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryFileView;
import org.netbeans.modules.localhistory.utils.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevertFileChanges
implements PropertyChangeListener {
    private LocalHistoryFileView view = new LocalHistoryFileView();
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private Node[] selectedNodes;

    RevertFileChanges() {
        this.view.getPanel().setPreferredSize(new Dimension(550, 250));
        this.okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"CTL_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"CTL_Revert"));
        JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"CTL_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"CTL_Cancel"));
        this.dialogDescriptor = new DialogDescriptor((Object)this.view.getPanel(), NbBundle.getMessage(this.getClass(), (String)"LBL_RevertToDialog"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, cancelButton});
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        this.view.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    void show(File root) {
        StoreEntry[] entries;
        long ts = LocalHistorySettings.getInstance().getLastSelectedEntry(root);
        this.view.refresh(new File[]{root}, ts);
        if (this.show() && (entries = this.getSelectedEntries()) != null && entries.length > 0) {
            this.revert(entries[0]);
            LocalHistorySettings.getInstance().setLastSelectedEntry(root, entries[0].getTimestamp());
        }
    }

    protected boolean show() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription("LBL_RevertToDialog");
        dialog.setVisible(true);
        return this.dialogDescriptor.getValue() == this.okButton;
    }

    private void revert(final StoreEntry entry) {
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Utils.revert(entry);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes = (Node[])evt.getNewValue();
            if (nodes != null && nodes.length > 0) {
                this.selectedNodes = nodes;
            }
            this.okButton.setEnabled(this.isEnabled(nodes));
        }
    }

    private boolean isEnabled(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return false;
        }
        for (Node node : nodes) {
            StoreEntry se = (StoreEntry)node.getLookup().lookup(StoreEntry.class);
            if (se != null) continue;
            return false;
        }
        return true;
    }

    private StoreEntry[] getSelectedEntries() {
        Node[] nodes = this.selectedNodes;
        if (nodes != null && nodes.length > 0) {
            ArrayList<Object> entries = new ArrayList<Object>();
            for (Node node : nodes) {
                entries.add(node.getLookup().lookup(StoreEntry.class));
            }
            return entries.toArray(new StoreEntry[entries.size()]);
        }
        return new StoreEntry[0];
    }
}

