/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.manager.UndefinedComponentManagerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;

public class DefaultComponentManagerManager
implements ComponentManagerManager {
    private Map activeComponentManagers = Collections.synchronizedMap(new HashMap());
    private Map componentManagers = null;
    private String defaultComponentManagerId = "singleton";
    private LifecycleHandlerManager lifecycleHandlerManager;
    private Map componentManagersByComponent = Collections.synchronizedMap(new HashMap());

    public void addComponentManager(ComponentManager componentManager) {
        if (this.componentManagers == null) {
            this.componentManagers = Collections.synchronizedMap(new HashMap());
        }
        this.componentManagers.put(componentManager.getId(), componentManager);
    }

    public void setLifecycleHandlerManager(LifecycleHandlerManager lifecycleHandlerManager) {
        this.lifecycleHandlerManager = lifecycleHandlerManager;
    }

    private ComponentManager copyComponentManager(String id) throws UndefinedComponentManagerException {
        ComponentManager componentManager = (ComponentManager)this.componentManagers.get(id);
        if (componentManager == null) {
            throw new UndefinedComponentManagerException("Specified component manager cannot be found: " + id);
        }
        return componentManager.copy();
    }

    public ComponentManager createComponentManager(ComponentDescriptor descriptor, MutablePlexusContainer container, String role) throws UndefinedComponentManagerException, UndefinedLifecycleHandlerException {
        return this.createComponentManager(descriptor, container, role, "default");
    }

    public ComponentManager createComponentManager(ComponentDescriptor descriptor, MutablePlexusContainer container, String role, String roleHint) throws UndefinedComponentManagerException, UndefinedLifecycleHandlerException {
        String componentManagerId = descriptor.getInstantiationStrategy();
        if (componentManagerId == null) {
            componentManagerId = this.defaultComponentManagerId;
        }
        ComponentManager componentManager = this.copyComponentManager(componentManagerId);
        componentManager.setup(container, this.findLifecycleHandler(descriptor), descriptor);
        componentManager.initialize();
        if (StringUtils.equals(role, descriptor.getRole()) && StringUtils.equals(roleHint, descriptor.getRoleHint())) {
            this.activeComponentManagers.put(String.valueOf(descriptor.getRealmId()) + "/" + descriptor.getRole() + "/" + descriptor.getRoleHint(), componentManager);
        } else {
            this.activeComponentManagers.put(String.valueOf(descriptor.getRealmId()) + "/" + role + "/" + roleHint, componentManager);
        }
        return componentManager;
    }

    public ComponentManager findComponentManagerByComponentInstance(Object component) {
        return (ComponentManager)this.componentManagersByComponent.get(component);
    }

    public ComponentManager findComponentManagerByComponentKey(String role, String roleHint, ClassRealm lookupRealm) {
        while (lookupRealm != null) {
            ComponentManager mgr = (ComponentManager)this.activeComponentManagers.get(String.valueOf(lookupRealm.getId()) + "/" + role + "/" + roleHint);
            if (mgr != null) {
                return mgr;
            }
            lookupRealm = lookupRealm.getParentRealm();
        }
        return null;
    }

    private LifecycleHandler findLifecycleHandler(ComponentDescriptor descriptor) throws UndefinedLifecycleHandlerException {
        String lifecycleHandlerId = descriptor.getLifecycleHandler();
        return this.lifecycleHandlerManager.getLifecycleHandler(lifecycleHandlerId);
    }

    public Map getComponentManagers() {
        return this.activeComponentManagers;
    }

    public void associateComponentWithComponentManager(Object component, ComponentManager componentManager) {
        this.componentManagersByComponent.put(component, componentManager);
    }

    public void unassociateComponentWithComponentManager(Object component) {
        this.componentManagersByComponent.remove(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dissociateComponentRealm(ClassRealm componentRealm) throws ComponentLifecycleException {
        Map map = this.activeComponentManagers;
        synchronized (map) {
            Iterator it = this.activeComponentManagers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                ComponentManager componentManager = (ComponentManager)entry.getValue();
                if (key.startsWith(componentRealm.getId())) {
                    componentManager.dispose();
                    it.remove();
                    continue;
                }
                componentManager.dissociateComponentRealm(componentRealm);
            }
        }
    }
}

