/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.embedder.AbstractMavenEmbedderLogger;

public final class MavenEmbedderFileLogger
extends AbstractMavenEmbedderLogger {
    private PrintWriter log;

    public MavenEmbedderFileLogger(File logFile) {
        try {
            this.log = new PrintWriter(new FileWriter(logFile));
        }
        catch (IOException e) {
            throw new RuntimeException("The embedder was unable to write to the specified log file: " + logFile, e);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.print("[DEBUG] ");
            this.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.print("[INFO] ");
            this.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.print("[WARNING] ");
            this.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.print("[ERROR] ");
            this.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.print("[ERROR] ");
            this.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    protected void print(String message) {
        this.log.print(message);
    }

    protected void println(String message) {
        this.log.println(message);
    }

    public void close() {
        this.log.flush();
        this.log.close();
    }
}

