/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.wizard.DetectPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class CDCWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final String CDC_PLATFORM_PROP = "cdcplatfrom";
    DataFolder installFolder;
    DetectPanel.WizardPanel detectPanel;
    Collection<ChangeListener> listeners;
    CDCPlatform platform;
    WizardDescriptor wizard;
    int currentIndex;
    CDCPlatformDetector detector;

    public CDCWizardIterator(FileObject installFolder, CDCPlatformDetector detector) {
        this.detector = detector;
        this.installFolder = DataFolder.findFolder((FileObject)installFolder);
        this.listeners = new ArrayList<ChangeListener>();
    }

    FileObject getInstallFolder() {
        return this.installFolder.getPrimaryFile();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public WizardDescriptor.Panel current() {
        switch (this.currentIndex) {
            case 0: {
                return this.detectPanel;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizard = wiz;
        this.detectPanel = new DetectPanel.WizardPanel(this, this.detector);
        this.currentIndex = 0;
    }

    public Set instantiate() throws IOException {
        this.detectPanel.storeSettings(this.wizard);
        CDCPlatform newPlatform = this.getPlatform();
        String systemName = this.platform.getAntName();
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        if (platformsFolder.getFileObject(systemName, "xml") != null) {
            String msg = NbBundle.getMessage(CDCWizardIterator.class, (String)"ERROR_InvalidName");
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
        }
        DataObject dobj = PlatformConvertor.create(newPlatform, DataFolder.findFolder((FileObject)platformsFolder), systemName);
        JavaPlatform platform = (JavaPlatform)dobj.getNodeDelegate().getLookup().lookup(JavaPlatform.class);
        return Collections.singleton(platform);
    }

    public String name() {
        return NbBundle.getMessage(CDCWizardIterator.class, (String)"TITLE_PlatformName");
    }

    public void nextPanel() {
        ++this.currentIndex;
    }

    public void previousPanel() {
        --this.currentIndex;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizard = null;
        this.detectPanel = null;
    }

    public CDCPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(CDCPlatform platform) {
        this.platform = platform;
    }
}

