/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.jdbc.EmbedXAConnection;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class EmbeddedXADataSource
extends EmbeddedDataSource
implements XADataSource {
    private static final long serialVersionUID = -5715798975598379738L;
    private transient ResourceAdapter ra;

    public final XAConnection getXAConnection() throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(null, null, false);
        }
        return this.createXAConnection(this.ra, this.getUser(), this.getPassword(), false);
    }

    public final XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(string, string2, true);
        }
        return this.createXAConnection(this.ra, string, string2, true);
    }

    void update() {
        this.ra = null;
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResourceAdapter(String string, String string2, boolean bl) throws SQLException {
        EmbeddedXADataSource embeddedXADataSource = this;
        synchronized (embeddedXADataSource) {
            if (this.ra == null || !this.ra.isActive()) {
                this.ra = null;
                String string3 = this.getDatabaseName();
                if (string3 != null) {
                    Database database = null;
                    if (Monitor.getMonitor() != null) {
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", string3);
                    }
                    if (database == null) {
                        if (bl) {
                            this.getConnection(string, string2).close();
                        } else {
                            this.getConnection().close();
                        }
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", string3);
                    }
                    if (database != null) {
                        this.ra = (ResourceAdapter)database.getResourceAdapter();
                    }
                }
                if (this.ra == null) {
                    throw new SQLException(MessageService.getTextMessage("I024"), "08006", 45000);
                }
                this.findDriver();
                if (this.driver == null) {
                    throw new SQLException(MessageService.getTextMessage("I025"), "08006", 45000);
                }
            }
        }
    }

    protected XAConnection createXAConnection(ResourceAdapter resourceAdapter, String string, String string2, boolean bl) throws SQLException {
        return new EmbedXAConnection(this, resourceAdapter, string, string2, bl);
    }
}

