/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;

public final class DTDCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    public static final String DTRACE_KERNEL = "dtrace_kernel";
    public static final String DTRACE_USER = "dtrace_user";
    public static final String DTRACE_PROC = "dtrace_proc";
    public static final String DSCRIPT_TOOL_PROPERTY = "dtrace.script";
    static final String DTDC_CONFIGURATION_ID = "DtraceDataCollectorConfigurationId";
    private static DTDCConfiguration CPU_SAMPLING;
    private URL scriptUrl;
    private String args;
    private List<DataTableMetadata> datatableMetadata;
    private DtraceParser parser;
    private List<String> requiredPrivileges;
    private boolean stackSupportEnabled = false;
    private int indicatorFiringFactor;
    private boolean standalone;
    private String prefix;

    public DTDCConfiguration(URL scriptUrl, List<DataTableMetadata> dataTableMetadata) {
        this.scriptUrl = scriptUrl;
        this.datatableMetadata = dataTableMetadata;
        this.args = null;
        this.parser = null;
        this.requiredPrivileges = null;
        this.indicatorFiringFactor = 1;
    }

    public void setScriptArgs(String args) {
        this.args = args;
    }

    public void setDtraceParser(DtraceParser parser) {
        this.parser = parser;
    }

    DTDCConfiguration setParser(DtraceParser parser) {
        this.parser = parser;
        return this;
    }

    public void setIndicatorFiringFactor(int indicatorFiringFactor) {
        this.indicatorFiringFactor = indicatorFiringFactor;
    }

    public void setRequiredDTracePrivileges(List<String> requiredPrivileges) {
        this.requiredPrivileges = requiredPrivileges;
    }

    public void setStackSupportEnabled(boolean stackSupportEnabled) {
        this.stackSupportEnabled = stackSupportEnabled;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void setOutputPrefix(String prefix) {
        this.prefix = prefix;
    }

    int getIndicatorFiringFactor() {
        return this.indicatorFiringFactor;
    }

    String getArgs() {
        return this.args;
    }

    List<DataTableMetadata> getDatatableMetadata() {
        return this.datatableMetadata;
    }

    DtraceParser getParser() {
        return this.parser;
    }

    List<String> getRequiredPrivileges() {
        return this.requiredPrivileges;
    }

    URL getScriptUrl() {
        return this.scriptUrl;
    }

    boolean isStackSupportEnabled() {
        return this.stackSupportEnabled;
    }

    boolean isStandalone() {
        return this.standalone;
    }

    String getOutputPrefix() {
        return this.prefix;
    }

    public String getID() {
        return DTDC_CONFIGURATION_ID;
    }

    public static synchronized DTDCConfiguration createCpuSamplingConfiguration() {
        if (CPU_SAMPLING == null) {
            CPU_SAMPLING = new DTDCConfiguration(CpuSamplingSupport.CPU_SAMPLING_SCRIPT_URL, Arrays.asList(CpuSamplingSupport.CPU_SAMPLE_TABLE));
            CPU_SAMPLING.setStackSupportEnabled(true);
            CPU_SAMPLING.setOutputPrefix("cpu:");
        }
        return CPU_SAMPLING;
    }

    static {
        DTDCConfigurationAccessor.setDefault(new DTDCConfigurationAccessorImpl());
    }

    private static final class DTDCConfigurationAccessorImpl
    extends DTDCConfigurationAccessor {
        private DTDCConfigurationAccessorImpl() {
        }

        @Override
        public String getArgs(DTDCConfiguration conf) {
            return conf.getArgs();
        }

        @Override
        public List<DataTableMetadata> getDatatableMetadata(DTDCConfiguration conf) {
            return conf.getDatatableMetadata();
        }

        @Override
        public DtraceParser getParser(DTDCConfiguration conf) {
            return conf.getParser();
        }

        @Override
        public List<String> getRequiredPrivileges(DTDCConfiguration conf) {
            return conf.getRequiredPrivileges();
        }

        @Override
        public URL getScriptUrl(DTDCConfiguration conf) {
            return conf.getScriptUrl();
        }

        @Override
        public String getID() {
            return DTDCConfiguration.DTDC_CONFIGURATION_ID;
        }

        @Override
        public boolean isStackSupportEnabled(DTDCConfiguration conf) {
            return conf.isStackSupportEnabled();
        }

        @Override
        public int getIndicatorFiringFactor(DTDCConfiguration conf) {
            return conf.getIndicatorFiringFactor();
        }

        @Override
        public boolean isStandalone(DTDCConfiguration conf) {
            return conf.isStandalone();
        }

        @Override
        public String getOutputPrefix(DTDCConfiguration conf) {
            return conf.getOutputPrefix();
        }
    }
}

