/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee.nodes;

import java.lang.reflect.Method;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.modules.j2ee.actions.CustomizerAction;
import org.netbeans.jellytools.modules.j2ee.actions.RefreshAction;
import org.netbeans.jellytools.modules.j2ee.actions.RemoveInstanceAction;
import org.netbeans.jellytools.modules.j2ee.actions.RestartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartDebugAction;
import org.netbeans.jellytools.modules.j2ee.actions.StopAction;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class J2eeServerNode
extends org.netbeans.jellytools.nodes.Node {
    static final CustomizerAction customizerAction = new CustomizerAction();
    static final StartDebugAction startDebugAction = new StartDebugAction();
    static final RefreshAction refreshAction = new RefreshAction();
    static final RemoveInstanceAction removeInstanceAction = new RemoveInstanceAction();
    static final RestartAction restartAction = new RestartAction();
    static final StartAction startAction = new StartAction();
    static final StopAction stopAction = new StopAction();
    private static final String SERVERS = Bundle.getString((String)"org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", (String)"SERVER_REGISTRY_NODE");
    public static final int STATE_WAITING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_DEBUGGING = 4;
    public static final int STATE_SUSPENDED = 5;
    public static final int STATE_PROFILING = 6;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;

    public J2eeServerNode(String serverName) {
        super(new RuntimeTabOperator().getRootNode(), SERVERS + "|" + serverName);
    }

    public static J2eeServerNode invoke(String serverName) {
        RuntimeTabOperator.invoke();
        return new J2eeServerNode(serverName);
    }

    public void verifyPopup() {
        this.verifyPopup(new Action[]{customizerAction, startDebugAction, refreshAction, removeInstanceAction, restartAction, startAction, stopAction});
    }

    public void properties() {
        this.waitNotWaiting();
        customizerAction.perform(this);
    }

    public void debug() {
        this.waitNotWaiting();
        startDebugAction.perform(this);
        this.waitDebugging();
    }

    public void refresh() {
        this.waitNotWaiting();
        refreshAction.perform(this);
        this.waitNotWaiting();
    }

    public void remove() {
        this.waitNotWaiting();
        removeInstanceAction.perform(this);
    }

    public void restart() {
        this.waitNotWaiting();
        restartAction.perform(this);
    }

    public void start() {
        this.waitNotWaiting();
        startAction.perform(this);
        this.waitRunning();
    }

    public void stop() {
        this.waitNotWaiting();
        stopAction.perform(this);
        this.waitStopped();
    }

    public void waitFinished() {
        this.waitNotWaiting();
    }

    static Class<? extends Node.Cookie> classServerInstance() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> general = Class.forName("org.netbeans.modules.j2ee.deployment.impl.ServerInstance", false, loader);
            return general.asSubclass(Node.Cookie.class);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Node.Cookie.class;
        }
    }

    private void waitDebugging() {
        this.waitServerState(4);
    }

    private void waitRunning() {
        this.waitServerState(3);
    }

    private void waitStopped() {
        this.waitServerState(2);
    }

    public int getServerState() {
        Node ideNode = (Node)this.getOpenideNode();
        return J2eeServerNode.getServerState(ideNode);
    }

    private static int getServerState(Node n) {
        try {
            Node.Cookie server = n.getCookie(J2eeServerNode.classServerInstance());
            Method m = J2eeServerNode.classServerInstance().getMethod("getServerState", new Class[0]);
            return (Integer)m.invoke((Object)server, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 2;
        }
    }

    private void waitServerState(int state) {
        final Node ideNode = (Node)this.getOpenideNode();
        final int targetState = state;
        J2eeServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object obj) {
                if (J2eeServerNode.getServerState(ideNode) == targetState) {
                    return "Server state: " + this.getStateName() + " reached.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait for server state: " + this.getStateName();
            }

            private String getStateName() {
                switch (targetState) {
                    case 4: {
                        return "DEBUGGING";
                    }
                    case 3: {
                        return "RUNNING";
                    }
                    case 2: {
                        return "STOPPED";
                    }
                    case 5: {
                        return "SUSPENDED";
                    }
                    case 1: {
                        return "WAITING";
                    }
                }
                return "UNKNOWN STATE";
            }
        });
    }

    private void waitNotWaiting() {
        final Node ideNode = (Node)this.getOpenideNode();
        J2eeServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object obj) {
                if (J2eeServerNode.getServerState(ideNode) != 1) {
                    return "Server leaves WAITING state.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait till server leaves state WAITING.";
            }
        });
    }

    private static Object waitFor(Waitable action) {
        Waiter waiter = new Waiter(action);
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", 120000L);
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException ex) {
            throw new JemmyException(action.getDescription() + " has been " + "interrupted.", (Throwable)ex);
        }
    }
}

