/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class A51OutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble;
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    private int relocPc;
    private int relocFieldPc;
    private int romBase = 0;
    private int e2Base = 33024;

    public A51OutputFormatter(BufferedReader bufferedReader) throws IOException {
        super(bufferedReader);
        String string;
        try {
            string = this.getMapEntry("ROMBASE");
            if (string != null) {
                this.romBase = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        try {
            string = this.getMapEntry("E2BASE");
            if (string != null) {
                this.e2Base = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.1", null);
        }
        this.preamble = new StringBuffer();
        this.preamble.append("$SAVE" + Msg.eol);
        this.preamble.append("$NOLIST" + Msg.eol);
        this.preamble.append("$INCLUDE (opcode.inc)" + Msg.eol);
        this.preamble.append("$INCLUDE (mask.inc)" + Msg.eol);
        this.preamble.append("$RESTORE" + Msg.eol + Msg.eol);
        this.preamble.append("BYTECODE     SEGMENT CODE  AT " + Integer.toHexString(this.romBase) + "H" + Msg.eol);
        this.preamble.append("STATICFIELDS SEGMENT XDATA AT " + Integer.toHexString(this.e2Base) + "H" + Msg.eol);
        this.preamble.append("STATICINIT   SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXCEPTIONTBL SEGMENT CODE" + Msg.eol);
        this.preamble.append("PACKAGETBL   SEGMENT CODE" + Msg.eol);
        this.preamble.append("APPLETTBL    SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXPORTCOMP   SEGMENT CODE" + Msg.eol);
        this.rom = new StringBuffer();
        this.rom.append("RSEG BYTECODE" + Msg.eol);
        this.rom.append("PUBLIC ROM_MASK" + Msg.eol);
        this.rom.append("ROM_MASK:" + Msg.eol);
        this.staticFields = new StringBuffer();
        this.staticFields.append("RSEG STATICFIELDS" + Msg.eol);
        this.staticFields.append("PUBLIC STATIC_FIELDS" + Msg.eol);
        this.staticFields.append("STATIC_FIELDS:" + Msg.eol);
        this.staticInit = new StringBuffer();
        this.staticInit.append("RSEG STATICINIT" + Msg.eol);
        this.staticInit.append("PUBLIC STATIC_INIT" + Msg.eol);
        this.staticInit.append("STATIC_INIT:" + Msg.eol);
        this.applets = new StringBuffer();
        this.applets.append("RSEG APPLETTBL" + Msg.eol);
        this.applets.append("PUBLIC APPLET_TABLE" + Msg.eol);
        this.applets.append("APPLET_TABLE:" + Msg.eol);
        this.packages = new StringBuffer();
        this.packages.append("RSEG PACKAGETBL" + Msg.eol);
        this.packages.append("PUBLIC PACKAGE_TABLE" + Msg.eol);
        this.packages.append("PACKAGE_TABLE:" + Msg.eol);
        this.exceptionTable = new StringBuffer();
        this.exceptionTable.append("RSEG EXCEPTIONTBL" + Msg.eol);
        this.exceptionTable.append("PUBLIC EXCEPTION_TABLE" + Msg.eol);
        this.exceptionTable.append("EXCEPTION_TABLE:" + Msg.eol);
        this.exportComponent = new StringBuffer();
        this.exportComponent.append("RSEG EXPORTCOMP" + Msg.eol);
        this.exportComponent.append("PUBLIC EXPORT_COMPONENT" + Msg.eol);
        this.exportComponent.append("EXPORT_COMPONENT:" + Msg.eol);
        this.defineList = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
    }

    @Override
    public void format(RomMask romMask) {
        this.pass1(romMask);
        this.pass2(romMask);
    }

    protected void pass1(RomMask romMask) {
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = enumeration.nextElement();
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Member member;
                JCClass jCClass = enumeration2.nextElement();
                jCClass.relocate(this.relocPc);
                this.relocPc += jCClass.size();
                if (Modifier.isInterface(jCClass.getAttributes())) continue;
                Enumeration<Member> enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    member = enumeration3.nextElement();
                    if (!Modifier.isStatic(member.getAttributes())) continue;
                    FieldDescriptor fieldDescriptor = ((Field)member).getDescriptor();
                    if (Modifier.isFinal(member.getAttributes()) && fieldDescriptor.isPrimitive()) continue;
                    member.relocate(this.relocFieldPc);
                    this.relocFieldPc += ((Field)member).size();
                    StaticFieldInitializer staticFieldInitializer = ((Field)member).getFieldInitializer();
                    if (staticFieldInitializer != null && staticFieldInitializer.isPrimitive()) {
                        int n = staticFieldInitializer.getPrimitiveData();
                        switch (((Field)member).size()) {
                            case 1: {
                                this.staticInit.append("DB " + this.byteHexString(n));
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW " + this.shortHexString(n));
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW " + this.shortHexString(n >> 16) + ", ");
                                this.staticInit.append(this.shortHexString(n));
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    } else {
                        switch (((Field)member).size()) {
                            case 1: {
                                this.staticInit.append("DB 00h");
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW 0000h");
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW 0000h, 0000h");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    }
                    this.staticInit.append("\t; " + member.getName() + Msg.eol);
                }
                enumeration3 = jCClass.methodElements();
                while (enumeration3.hasMoreElements()) {
                    member = (JCMethod)enumeration3.nextElement();
                    if (Modifier.isNative(member.getAttributes())) {
                        member.relocate(0);
                        continue;
                    }
                    member.relocate(this.relocPc);
                    this.relocPc += ((JCMethod)member).size();
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    protected void pass2(RomMask romMask) {
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            int n2;
            JCPackage jCPackage = enumeration.nextElement();
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            PackageIdentifier packageIdentifier = jCPackage.getIdentifier();
            this.packageDirectory.addPackage(packageIdentifier);
            byte[] byArray = packageIdentifier.getAid().toByteArray();
            this.packages.append("DB " + byArray.length + ", ");
            for (int n2 : byArray) {
                this.packages.append(this.byteHexString(n2) + ", ");
            }
            this.packages.append(packageIdentifier.getMajorVersion() + ", " + packageIdentifier.getMinorVersion() + ", " + this.exportComponentLength + Msg.eol);
            Object object = jCPackage.appletElements();
            while (object.hasMoreElements()) {
                AppletDeclarator appletDeclarator = (AppletDeclarator)object.nextElement();
                byte[] byArray2 = appletDeclarator.getAid().toByteArray();
                n2 = appletDeclarator.resolve().getRelocAddr();
                this.applets.append("DB " + this.packageDirectory.indexOf(packageIdentifier) + ", " + byArray2.length + ", ");
                for (byte by : byArray2) {
                    this.applets.append(this.byteHexString(by) + ", ");
                }
                this.applets.append(", " + this.shortHexString(n2 + this.romBase) + Msg.eol);
            }
            object = jCPackage.classElements();
            while (object.hasMoreElements()) {
                Object object2;
                Object object32;
                Object object4;
                JCClass jCClass = (JCClass)object.nextElement();
                exportComponent.add(jCClass);
                this.rom.append(Msg.eol + "; class@" + this.shortHexString(jCClass.getRelocAddr()) + ": " + Modifier.toString(jCClass.getAttributes()) + " " + jCClass.getName() + Msg.eol);
                String string = this.getMapEntry(jCClass.getName());
                if (string != null) {
                    this.defineList.append("#define " + string + " " + (jCClass.getRelocAddr() + this.romBase) + "\t/* " + jCClass.getName() + " */" + Msg.eol);
                }
                int n3 = n2 = jCClass.isShareable() ? 64 : 0;
                if (Modifier.isInterface(jCClass.getAttributes())) {
                    int n4 = jCClass.superInterfaceVector.size();
                    this.rom.append("DB " + this.byteHexString((n2 |= 0x80) | n4 & 0xF) + ", ");
                    object4 = jCClass.superInterfaceVector.iterator();
                    while (object4.hasNext()) {
                        SuperInterface superInterface = object4.next();
                        int n5 = superInterface.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + this.shortHexString(n5 + this.romBase) + "), ");
                        this.rom.append("LOW(" + this.shortHexString(n5 + this.romBase) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append("DB " + this.byteHexString(n2 | jCClass.interfaceVector.size() & 0xF) + ", ");
                Enumeration<JCMethod> enumeration2 = jCClass.getSuperClass();
                if (enumeration2 == null) {
                    this.rom.append(this.byteHexString(255) + ", ");
                    this.rom.append(this.byteHexString(255) + ", ");
                } else {
                    this.rom.append("HIGH(" + this.shortHexString(((Member)((Object)enumeration2)).getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(((Member)((Object)enumeration2)).getRelocAddr() + this.romBase) + "), ");
                }
                int n6 = 0;
                for (object4 = jCClass; object4 != null; object4 = ((JCClass)object4).getSuperClass()) {
                    n6 += ((JCClass)object4).getInstanceSize();
                }
                this.rom.append(this.byteHexString(n6) + ", ");
                this.rom.append(this.byteHexString(jCClass.getFirstReferenceToken()) + ", ");
                this.rom.append(this.byteHexString(jCClass.getReferenceCount()) + ", ");
                this.rom.append(this.byteHexString(jCClass.publicMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(jCClass.publicMethodTable.getCount()) + ", ");
                this.rom.append(this.byteHexString(jCClass.packageMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(jCClass.packageMethodTable.getCount()) + ", ");
                this.rom.append(Msg.eol);
                Object object5 = jCClass.publicMethodTable.elements();
                while (object5.hasMoreElements()) {
                    object32 = object5.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(((Member)object32).getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(((Member)object32).getRelocAddr() + this.romBase) + "),\t\t; " + ((Member)object32).getName() + Msg.eol);
                }
                object5 = jCClass.packageMethodTable.elements();
                while (object5.hasMoreElements()) {
                    object32 = object5.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(((Member)object32).getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(((Member)object32).getRelocAddr() + this.romBase) + "),\t\t; " + ((Member)object32).getName() + Msg.eol);
                }
                for (Object object32 : jCClass.interfaceVector) {
                    byte[] byArray3 = ((InterfaceTable)object32).toByteArray();
                    object2 = ((InterfaceTable)object32).resolve().getRelocAddr();
                    this.rom.append("DB HIGH(" + this.shortHexString(object2 + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(object2 + this.romBase) + "), ");
                    for (int i = 2; i < byArray3.length; ++i) {
                        this.rom.append(byArray3[i] + ", ");
                    }
                    this.rom.append(Msg.eol);
                }
                enumeration2 = jCClass.fieldElements();
                while (enumeration2.hasMoreElements()) {
                    object4 = (Field)enumeration2.nextElement();
                    n6 = ((Member)object4).getAttributes();
                    if (!Modifier.isStatic(n6) || Modifier.isFinal(n6) || (string = this.getMapEntry(((Member)object4).getName())) == null) continue;
                    this.defineList.append("#define " + string + " " + (((Member)object4).getRelocAddr() + this.e2Base) + "\t/* " + ((Member)object4).getName() + " */" + Msg.eol);
                }
                enumeration2 = jCClass.methodElements();
                while (enumeration2.hasMoreElements()) {
                    object4 = enumeration2.nextElement();
                    if (Modifier.isNative(((Member)object4).getAttributes())) continue;
                    string = this.getMapEntry(((Member)object4).getName());
                    if (string != null) {
                        this.defineList.append("#define " + string + " " + (((Member)object4).getRelocAddr() + this.romBase) + "\t/* " + ((Member)object4).getName() + " */" + Msg.eol);
                    }
                    this.rom.append(Msg.eol + "; method@" + this.shortHexString(((Member)object4).getRelocAddr()) + ": " + Modifier.toString(((Member)object4).getAttributes()) + " " + ((Member)object4).getName() + Msg.eol);
                    byte[] byArray4 = ((JCMethod)object4).getMethodHeader();
                    this.rom.append("DB ");
                    object5 = byArray4;
                    int n7 = ((Object)object5).length;
                    for (int i = 0; i < n7; ++i) {
                        object2 = object5[i];
                        this.rom.append(this.byteHexString((int)(object2 & 0xFF)) + ", ");
                    }
                    this.rom.append(Msg.eol);
                    if (Modifier.isAbstract(((Member)object4).getAttributes())) continue;
                    object5 = ((JCMethod)object4).statementElements();
                    while (object5.hasMoreElements()) {
                        Statement statement = object5.nextElement();
                        this.format(statement);
                        this.rom.append(", " + Msg.eol);
                    }
                    object5 = ((JCMethod)object4).getExceptionTable();
                    if (object5 == null) continue;
                    Enumeration<ExceptionTableEntry> enumeration3 = ((ExceptionTable)object5).elements();
                    while (enumeration3.hasMoreElements()) {
                        ExceptionTableEntry exceptionTableEntry = enumeration3.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(this.shortHexString(exceptionTableEntry.getStartOffset() + this.romBase) + ", ");
                        object2 = exceptionTableEntry.getActiveLength();
                        if (exceptionTableEntry.isOuterMost()) {
                            object2 |= 0x8000;
                        }
                        this.exceptionTable.append(this.shortHexString((int)object2) + ", ");
                        this.exceptionTable.append(this.shortHexString(exceptionTableEntry.getHandlerOffset() + this.romBase) + ", ");
                        this.exceptionTable.append(this.shortHexString(exceptionTableEntry.getCatchIndex() + this.romBase) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            object = exportComponent.toByteArray();
            this.exportComponent.append("; " + jCPackage.getName() + Msg.eol + "DB ");
            for (int i = 0; i < ((byte[])object).length; ++i) {
                this.exportComponent.append(this.byteHexString(object[i]) + ", ");
                if (i % 8 != 7) continue;
                this.exportComponent.append(Msg.eol);
                if (i >= ((byte[])object).length) continue;
                this.exportComponent.append("DB ");
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += ((byte[])object).length;
        }
    }

    protected void format(Statement statement) {
        if (statement.getInstruction() == null) {
            return;
        }
        this.format(statement.getInstruction());
    }

    protected void format(Instruction instruction) {
        this.rom.append("DB _" + instruction.getMnemonic().toUpperCase());
        Enumeration<Operand> enumeration = instruction.operandElements();
        while (enumeration.hasMoreElements()) {
            Operand operand = enumeration.nextElement();
            this.format(operand);
        }
    }

    protected void format(Operand operand) {
        if (operand.getType() == 8) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(n + this.romBase) + "), LOW(" + this.shortHexString(n + this.romBase) + ")");
                    break;
                }
                case 5: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(n + this.e2Base) + "), LOW(" + this.shortHexString(n + this.e2Base) + ")");
                    break;
                }
                case 3: {
                    JCMethod jCMethod = (JCMethod)info.resolve();
                    MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
                    int n = methodIdentifier.getMethodToken();
                    int n2 = jCMethod.getParams();
                    this.rom.append(", " + this.byteHexString(n2) + ", " + this.byteHexString(n));
                    break;
                }
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n3 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(n3 >> 8) + ", " + this.byteHexString(n3 & 0xFF));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.getType() == 7) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n4 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(n4));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.size() == 1) {
            this.rom.append(", " + operand.getValue());
        } else if (operand.size() == 2) {
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        } else if (operand.size() == 4) {
            this.rom.append(", " + (operand.getValue() >> 24 & 0xFF) + ", " + (operand.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(this.preamble.toString());
        printWriter.println(this.rom.toString());
        printWriter.println(this.exceptionTable.toString());
        printWriter.println("EXTBL_LENGTH EQU $ - EXCEPTION_TABLE" + Msg.eol);
        printWriter.print(this.staticFields.toString());
        printWriter.println("DS " + this.relocFieldPc + Msg.eol);
        printWriter.println(this.staticInit.toString());
        printWriter.println("STATIC_INIT_LENGTH EQU $ - STATIC_INIT" + Msg.eol);
        printWriter.println(this.applets.toString());
        printWriter.println("APPLET_TBL_LENGTH EQU $ - APPLET_TABLE" + Msg.eol);
        printWriter.println("$IF (POST_ISSUANCE_INSTALL = 1)");
        printWriter.print(this.packages.toString());
        printWriter.println("PACKAGE_TBL_LENGTH EQU $ - PACKAGE_TABLE" + Msg.eol);
        printWriter.print(this.exportComponent.toString());
        printWriter.println("EXPORT_COMP_LENGTH EQU $ - EXPORT_COPMPONENT" + Msg.eol);
        printWriter.println("$ENDIF\t;POST_ISSUANCE_INSTALL");
        printWriter.flush();
    }

    private String byteHexString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(n &= 0xFF) + "h");
        if (stringBuffer.length() == 2) {
            stringBuffer.insert(0, '0');
        } else {
            switch (stringBuffer.charAt(0)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    stringBuffer.insert(0, '0');
                }
            }
        }
        return stringBuffer.toString();
    }

    private String shortHexString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(n &= 0xFFFF) + "h");
        switch (stringBuffer.charAt(0)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                stringBuffer.insert(0, '0');
            }
        }
        return stringBuffer.toString();
    }
}

