/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Token;
import java.util.Hashtable;

public class Operand {
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_UNSIGNED_BYTE = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_UNSIGNED_SHORT = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_UNSIGNED_INTEGER = 6;
    public static final int TYPE_BYTE_CONSTANT_POOL_INDEX = 7;
    public static final int TYPE_CONSTANT_POOL_INDEX = 8;
    public static final int TYPE_LOCAL_INDEX = 9;
    public static final int TYPE_BYTE_BRANCH = 10;
    public static final int TYPE_SHORT_BRANCH = 11;
    public static final int TYPE_ARRAY = 12;
    protected int lineNumber;
    protected int column;
    protected int type;
    protected int intValue;
    protected String stringValue;
    private boolean needsFixup;
    protected Info resolvedTo;

    public Operand(int n, int n2, Token token) {
        this.intValue = n;
        this.type = n2;
        if (token != null) {
            this.lineNumber = token.beginLine;
            this.column = token.beginColumn;
        }
    }

    public Operand(String string, int n, Token token) {
        this.stringValue = string.toLowerCase();
        this.type = n;
        if (token != null) {
            this.lineNumber = token.beginLine;
            this.column = token.beginColumn;
        }
        this.needsFixup = true;
    }

    public int getValue() {
        return this.intValue;
    }

    public int getType() {
        return this.type;
    }

    public int getLine() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void resolve(Info info) {
        assert (info != null) : "info != null";
        assert (this.type == 8 || this.type == 7) : "type";
        this.resolvedTo = info;
    }

    public Info resolve() {
        assert (this.resolvedTo != null) : "resolvedTo != null";
        assert (this.type == 8 || this.type == 7) : "type";
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    protected void methodFixup(Hashtable<String, Integer> hashtable, int n) {
        if (!this.needsFixup) {
            return;
        }
        Integer n2 = hashtable.get(this.stringValue);
        if (n2 == null) {
            Object[] objectArray = new Object[]{this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
            Msg.error("operand.0", objectArray);
            return;
        }
        int n3 = n2;
        switch (this.type) {
            case 11: {
                this.intValue = n3 - n;
                if (this.intValue < Short.MIN_VALUE || this.intValue > Short.MAX_VALUE) {
                    this.intValue = 0;
                    Object[] objectArray = new Object[]{"?", this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
                    Msg.error("parser.ShortBranch", objectArray);
                }
                this.needsFixup = false;
                break;
            }
            case 10: {
                this.intValue = n3 - n;
                if (this.intValue < -128 || this.intValue > 127) {
                    this.intValue = 0;
                    Object[] objectArray = new Object[]{"?", this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
                    Msg.error("parser.ByteBranch", objectArray);
                    ++Globals.errors;
                }
                this.needsFixup = false;
                break;
            }
        }
    }

    public int size() {
        int n = 0;
        switch (this.type) {
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n = 1;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                n = 2;
                break;
            }
            case 5: 
            case 6: {
                n = 4;
                break;
            }
            default: {
                assert (false) : "type";
                break;
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.size()) {
            case 1: {
                stringBuffer.append(Msg.toHexString((byte)this.intValue));
                break;
            }
            case 2: {
                stringBuffer.append(Msg.toHexString((short)this.intValue));
                break;
            }
            case 4: {
                stringBuffer.append(Msg.toHexString(this.intValue));
            }
        }
        return stringBuffer.toString();
    }
}

