/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import java.lang.reflect.Modifier;

public class Field
extends Member {
    protected FieldIdentifier fieldIdentifier;
    protected JCClass parentClass;
    protected FieldDescriptor descriptor;
    protected StaticFieldInitializer initializer;

    public Field(JCClass jCClass, int n, FieldDescriptor fieldDescriptor, String string, StaticFieldInitializer staticFieldInitializer, int n2) {
        super(n, string, n2, 0);
        assert (fieldDescriptor != null) : "descriptor != null";
        this.parentClass = jCClass;
        this.descriptor = fieldDescriptor;
        this.initializer = staticFieldInitializer;
    }

    public Field(JCClass jCClass, int n, FieldDescriptor fieldDescriptor, String string, FieldIdentifier fieldIdentifier, StaticFieldInitializer staticFieldInitializer, int n2) {
        this(jCClass, n, fieldDescriptor, string, staticFieldInitializer, n2);
        this.fieldIdentifier = fieldIdentifier;
    }

    public FieldIdentifier getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public StaticFieldInitializer getFieldInitializer() {
        return this.initializer;
    }

    public boolean isExportCompCandidate() {
        return Modifier.isStatic(this.attributes) && (Modifier.isPublic(this.attributes) || Modifier.isProtected(this.attributes));
    }

    public int size() {
        int n = 0;
        if (!this.descriptor.isPrimitive()) {
            n = 2;
        } else {
            String string = this.descriptor.getDescriptorString();
            if (string.equals("B") || string.equals("Z")) {
                n = 1;
            } else if (string.equals("S")) {
                n = 2;
            } else if (string.equals("I")) {
                n = 4;
            } else assert (false) : string;
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(this.attributes));
        stringBuffer.append(" " + this.descriptor + " " + this.name);
        if (this.fieldIdentifier != null) {
            stringBuffer.append(" <" + this.fieldIdentifier + ">");
        }
        return stringBuffer.toString();
    }
}

