/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.Commands;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.Options;
import com.sun.javacard.debugproxy.Packet;
import com.sun.javacard.debugproxy.PacketStream;
import com.sun.javacard.debugproxy.ProxyListener;
import com.sun.javacard.debugproxy.SocketConnection;
import com.sun.javacard.debugproxy.classparser.ClassFile;
import com.sun.javacard.debugproxy.classparser.ClassManager;
import com.sun.javacard.debugproxy.classparser.FieldInfo;
import com.sun.javacard.debugproxy.classparser.MethodInfo;
import com.sun.javacard.debugproxy.classparser.attributes.CodeAttribute;
import com.sun.javacard.debugproxy.classparser.attributes.LocalVariable;
import com.sun.javacard.debugproxy.classparser.attributes.SourceFileAttribute;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class JDBListener
extends ProxyListener {
    SocketConnection jdbConnection;
    ProxyListener cjcreListener;
    ClassManager classManager = null;
    Packet replyPacket;
    Options options;
    boolean ready = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;

    public JDBListener(Options options) {
        this.options = options;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.cjcreListener = proxyListener;
        this.classManager = classManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if (!packet.isReplyPacket() && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.jdbConnection.send(packet);
    }

    @Override
    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            this.cjcreListener.quit();
            try {
                if (this.acceptSocket != null) {
                    this.acceptSocket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        Packet packet = null;
        PacketStream packetStream = null;
        PacketStream packetStream2 = null;
        try {
            System.out.println("Waiting for debugger on port " + this.options.getLocalPort());
            this.serverSocket = new ServerSocket(this.options.getLocalPort());
            this.acceptSocket = this.serverSocket.accept();
            this.jdbConnection = new SocketConnection(this, this.acceptSocket);
            System.out.println("Connection received.");
        }
        catch (IOException iOException) {
            System.out.println("JDBListener: " + iOException.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (SecurityException securityException) {
            System.out.println("JDBListener: " + securityException.getMessage());
            Runtime.getRuntime().exit(1);
        }
        try {
            for (byte by : JDWP_HANDSHAKE) {
                this.jdbConnection.receiveByte();
            }
            for (byte by : JDWP_HANDSHAKE) {
                this.jdbConnection.sendByte(by);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JDBListener jDBListener = this;
        Object object = jDBListener;
        synchronized (jDBListener) {
            this.ready = true;
            this.notify();
            // ** MonitorExit[var5_7] (shouldn't be in output)
            new Thread(this.jdbConnection).start();
            try {
                while (!this.timeToQuit) {
                    object = null;
                    int n = 0;
                    bl = false;
                    packet = this.waitForPacket();
                    if (packet == null) break;
                    if (!packet.isReplyPacket()) {
                        packetStream2 = new PacketStream(this, packet);
                        switch (packet.commandSet) {
                            case 1: {
                                int n2;
                                byte by;
                                switch (packet.command) {
                                    case 1: {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeString("Version 1.0");
                                        packetStream.writeInt(1);
                                        packetStream.writeInt(0);
                                        packetStream.writeString("1.0.3");
                                        packetStream.writeString("KVM");
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 2: {
                                        String string = packetStream2.readString();
                                        Log.LOGN(3, "ClassBySig: class " + string);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        Iterator<ClassFile> iterator = ClassManager.classMap.values().iterator();
                                        while (iterator.hasNext()) {
                                            try {
                                                object = iterator.next();
                                                if (object == null) {
                                                    throw new Exception("Couldn't find classFile object");
                                                }
                                                if (string.compareTo(((ClassFile)object).getClassSignature()) != 0) continue;
                                                Log.LOGN(3, "ClassBySig matched " + ((ClassFile)object).getClassName());
                                                Log.LOGN(6, "Class Signature: " + ((ClassFile)object).getClassSignature());
                                                packetStream.writeInt(1);
                                                packetStream.writeByte(((ClassFile)object).getJDWPTypeTag());
                                                packetStream.writeInt(((ClassFile)object).getClassID());
                                                packetStream.writeInt(((ClassFile)object).getClassStatus());
                                                packetStream.send();
                                                bl = true;
                                                break;
                                            }
                                            catch (Exception exception) {
                                                System.out.println("ClassesBySig command failed with " + exception);
                                                packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                                packetStream.send();
                                                bl = true;
                                            }
                                        }
                                        if (bl) break;
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 3: {
                                        Log.LOGN(3, "All_Classes command");
                                        packetStream = new PacketStream(this.cjcreListener, 1, 3);
                                        PacketStream packetStream3 = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.send();
                                        try {
                                            packetStream.waitForReply();
                                        }
                                        catch (Exception exception) {
                                            packetStream3.writeInt(0);
                                            packetStream3.send();
                                            bl = true;
                                            break;
                                        }
                                        int n3 = packetStream.readInt();
                                        packetStream3.writeInt(n3);
                                        for (int i = 0; i < n3; ++i) {
                                            by = packetStream.readByte();
                                            n = packetStream.readInt();
                                            String string = packetStream.readString();
                                            n2 = packetStream.readInt();
                                            packetStream3.writeByte(by);
                                            packetStream3.writeInt(n);
                                            packetStream3.writeString(string);
                                            packetStream3.writeInt(n2);
                                            if (by != 3) {
                                                string = new String(string.substring(1, string.length() - 1));
                                            }
                                            Log.LOGN(3, "AllClasses:  " + string + ", ID = " + Integer.toHexString(n));
                                            object = ClassManager.classMap.get(new Integer(n));
                                            if (object == null) {
                                                object = this.classManager.findClass(by, string);
                                                if (object != null) {
                                                    ClassManager.classMap.put(new Integer(n), (ClassFile)object);
                                                    ((ClassFile)object).setClassID(n);
                                                    ((ClassFile)object).setClassStatus(n2);
                                                    continue;
                                                }
                                                System.out.println("ALL_CLASSES_CMD: couldn't find classfile object");
                                                packetStream3 = new PacketStream(this, packetStream2.id, 128, 41);
                                                packetStream3.send();
                                                bl = true;
                                                break;
                                            }
                                            ((ClassFile)object).setClassStatus(n2);
                                        }
                                        packetStream3.send();
                                        bl = true;
                                        break;
                                    }
                                    case 5: {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(1);
                                        packetStream.writeInt(-32);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 6: {
                                        packetStream = new PacketStream(this.cjcreListener, 1, 10);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        PacketStream packetStream4 = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream4.send();
                                        bl = true;
                                        this.quit();
                                        break;
                                    }
                                    case 7: {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(8);
                                        packetStream.writeInt(4);
                                        packetStream.writeInt(4);
                                        packetStream.writeInt(4);
                                        packetStream.writeInt(4);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 12: {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeBoolean(false);
                                        packetStream.writeBoolean(false);
                                        packetStream.writeBoolean(true);
                                        packetStream.writeBoolean(false);
                                        packetStream.writeBoolean(false);
                                        packetStream.writeBoolean(false);
                                        packetStream.writeBoolean(false);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 8: {
                                        break;
                                    }
                                    case 9: {
                                        break;
                                    }
                                    case 13: {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeString("");
                                        packetStream.writeInt(0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 14: {
                                        Log.LOGN(3, "Dispose Objects: ");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.send();
                                        bl = true;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                switch (packet.command) {
                                    case 1: {
                                        n = packetStream2.readInt();
                                        Log.LOGN(3, "Signature cmd: class id = " + Integer.toHexString(n));
                                        try {
                                            ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                            object = classFile;
                                            if (classFile == null) {
                                                throw new Exception("Couldn't get ClassFile object for signature cmd");
                                            }
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            if (n == -32) {
                                                packetStream.writeString("Lkvm_threadgroup;");
                                            } else {
                                                packetStream.writeString(((ClassFile)object).getClassSignature());
                                            }
                                            packetStream.send();
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Signature cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                            packetStream.send();
                                            bl = true;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        packetStream2.readInt();
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 3: {
                                        n = packetStream2.readInt();
                                        try {
                                            ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                            object = classFile;
                                            if (classFile == null) {
                                                throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                            }
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeInt(((ClassFile)object).getRawAccessFlags());
                                            packetStream.send();
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Modifiers cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                            packetStream.send();
                                            bl = true;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        n = packetStream2.readInt();
                                        Log.LOGN(3, "field command: cid = " + Integer.toHexString(n));
                                        ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                        object = classFile;
                                        if (classFile == null) {
                                            Log.LOGN(3, "field_cmd: cf == null");
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeInt(0);
                                            packetStream.send();
                                            bl = true;
                                            break;
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        if (this.processFields((ClassFile)object, packetStream, packetStream2.id)) {
                                            packetStream.send();
                                        }
                                        bl = true;
                                        break;
                                    }
                                    case 5: {
                                        n = packetStream2.readInt();
                                        Log.LOGN(3, "methods command: cid = " + Integer.toHexString(n));
                                        ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                        object = classFile;
                                        if (classFile == null || ((ClassFile)object).getJDWPTypeTag() == 3) {
                                            Log.LOGN(3, "methods_cmd: cf == null or cf == arrayclass");
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeInt(0);
                                            packetStream.send();
                                            bl = true;
                                            break;
                                        }
                                        try {
                                            int n4 = ProxyListener.method_index_base;
                                            List<MethodInfo> list = ((ClassFile)object).getAllMethodInfo();
                                            Iterator<MethodInfo> iterator = list.iterator();
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            Log.LOGN(5, "Methods: " + list.size() + " methods");
                                            packetStream.writeInt(list.size());
                                            while (iterator.hasNext()) {
                                                MethodInfo methodInfo = iterator.next();
                                                if (methodInfo == null) {
                                                    throw new Exception("methodinfo null");
                                                }
                                                Log.LOGN(5, "Method: id = " + Integer.toHexString(n4));
                                                packetStream.writeInt(n4++);
                                                Log.LOGN(5, "Method: name = " + methodInfo.getName());
                                                packetStream.writeString(methodInfo.getName());
                                                Log.LOGN(5, "Method: sig = " + methodInfo.getSignatureRaw());
                                                packetStream.writeString(methodInfo.getSignatureRaw());
                                                Log.LOGN(5, "Method: flags = " + methodInfo.getAccessFlags());
                                                packetStream.writeInt(methodInfo.getAccessFlags());
                                            }
                                            packetStream.send();
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Methods cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                            packetStream.send();
                                            bl = true;
                                        }
                                        break;
                                    }
                                    case 7: {
                                        Log.LOGN(3, "Source file cmd");
                                        n = packetStream2.readInt();
                                        try {
                                            ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                            object = classFile;
                                            if (classFile == null) {
                                                throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                            }
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            SourceFileAttribute sourceFileAttribute = ((ClassFile)object).getSourceAttribute();
                                            if (sourceFileAttribute != null) {
                                                String string = sourceFileAttribute.getSourceFileName();
                                                Log.LOGN(3, "Returning from attribute: " + string);
                                                packetStream.writeString(string);
                                            } else {
                                                Log.LOGN(3, "Creating source name: " + ((ClassFile)object).getBaseName() + ".java");
                                                packetStream.writeString(((ClassFile)object).getBaseName() + ".java");
                                            }
                                            packetStream.send();
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Sourcefile cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                            packetStream.send();
                                            bl = true;
                                        }
                                        break;
                                    }
                                    case 10: {
                                        n = packetStream2.readInt();
                                        try {
                                            ClassFile classFile = ClassManager.classMap.get(new Integer(n));
                                            object = classFile;
                                            if (classFile == null) {
                                                throw new Exception("Couldn't get ClassFile object for Interfaces cmd");
                                            }
                                            List<String> list = ((ClassFile)object).getAllInterfaces();
                                            Iterator<String> iterator = list.iterator();
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            Log.LOGN(3, "Interfaces: class " + ((ClassFile)object).getClassName() + " " + list.size() + " interfaces");
                                            packetStream.writeInt(list.size());
                                            while (iterator.hasNext()) {
                                                String string = iterator.next();
                                                Log.LOGN(3, "interfaces: classname: " + string);
                                                if (string == null) {
                                                    throw new Exception("interface name null");
                                                }
                                                object = this.classManager.findClass((byte)76, string);
                                                if (object == null) {
                                                    packetStream.writeInt(0);
                                                    continue;
                                                }
                                                packetStream.writeInt(((ClassFile)object).getClassID());
                                            }
                                            packetStream.send();
                                            bl = true;
                                            break;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Interfaces cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                            packetStream.send();
                                            bl = true;
                                        }
                                    }
                                }
                                break;
                            }
                            case 6: {
                                switch (packet.command) {
                                    case 1: {
                                        this.handleLineTable(packetStream2);
                                        bl = true;
                                        break;
                                    }
                                    case 2: {
                                        this.handleVariableTable(packetStream2);
                                        bl = true;
                                        break;
                                    }
                                    case 3: {
                                        this.handleByteCode(packetStream2);
                                        bl = true;
                                    }
                                }
                                break;
                            }
                            case 11: {
                                switch (packet.command) {
                                    case 5: {
                                        Log.LOGN(3, "Threadreference: threadgroup");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(-32);
                                        packetStream.send();
                                        bl = true;
                                    }
                                }
                                break;
                            }
                            case 12: {
                                switch (packet.command) {
                                    case 1: {
                                        packetStream2.readInt();
                                        Log.LOGN(3, "ThreadGroup: name");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeString("KVM_System");
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 2: {
                                        int n5 = packetStream2.readInt();
                                        Log.LOGN(3, "ThreadGroup: parent");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    case 3: {
                                        int n6 = packetStream2.readInt();
                                        Log.LOGN(3, "ThreadGroup: children");
                                        PacketStream packetStream5 = new PacketStream(this, packetStream2.id, 128, 0);
                                        if (n6 == -32) {
                                            packetStream = new PacketStream(this.cjcreListener, 1, 4);
                                            packetStream.send();
                                            try {
                                                packetStream.waitForReply();
                                            }
                                            catch (Exception exception) {
                                                packetStream5.writeInt(0);
                                                packetStream5.writeInt(0);
                                                packetStream5.send();
                                                bl = true;
                                                break;
                                            }
                                            int n7 = packetStream.readInt();
                                            Log.LOGN(3, "threadgroup: " + n7 + " children");
                                            packetStream5.writeInt(n7);
                                            while (n7-- > 0) {
                                                packetStream5.writeInt(packetStream.readInt());
                                            }
                                        } else {
                                            packetStream5.writeInt(0);
                                        }
                                        packetStream5.writeInt(0);
                                        packetStream5.send();
                                        bl = true;
                                    }
                                }
                                break;
                            }
                            case 16: {
                                int n2;
                                byte by;
                                switch (packet.command) {
                                    case 3: {
                                        Log.LOGN(3, "Stackframe: thisobject");
                                        int n8 = packetStream2.readInt();
                                        int n9 = packetStream2.readInt();
                                        packetStream = new PacketStream(this.cjcreListener, 16, 1);
                                        PacketStream packetStream6 = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(n8);
                                        packetStream.writeInt(n9);
                                        packetStream.writeInt(1);
                                        packetStream.writeInt(0);
                                        packetStream.writeByte((byte)76);
                                        packetStream.send();
                                        try {
                                            packetStream.waitForReply();
                                        }
                                        catch (Exception exception) {
                                            packetStream6.writeByte((byte)76);
                                            packetStream6.writeInt(0);
                                            packetStream6.send();
                                            bl = true;
                                            break;
                                        }
                                        n2 = packetStream.readInt();
                                        by = packetStream.readByte();
                                        int n10 = packetStream.readInt();
                                        Log.LOGN(3, "Stackframe: thisobject tag: " + by + " objectID " + n10);
                                        packetStream6.writeByte(by);
                                        packetStream6.writeInt(n10);
                                        packetStream6.send();
                                        bl = true;
                                    }
                                }
                                break;
                            }
                            case 17: {
                                switch (packet.command) {
                                    case 1: {
                                        int n11 = packetStream2.readInt();
                                        PacketStream packetStream7 = new PacketStream(this, packetStream2.id, 128, 0);
                                        ClassFile classFile = ClassManager.classMap.get(new Integer(n11));
                                        object = classFile;
                                        if (classFile == null) {
                                            packetStream7.writeByte((byte)1);
                                        } else {
                                            packetStream7.writeByte(((ClassFile)object).getJDWPTypeTag());
                                        }
                                        packetStream7.writeInt(n11);
                                        packetStream7.send();
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                    if (bl) continue;
                    Log.LOG(3, "DebuggerListener: ");
                    Commands.print(packet);
                    if (packet.commandSet == 15 && packet.command == 1) {
                        Log.LOG(3, "EventKind == " + packet.data[0] + "\n");
                    }
                    this.cjcreListener.send(packet);
                }
            }
            catch (IOException iOException) {
                PacketStream packetStream8 = new PacketStream(this, packetStream2.id, 128, 41);
                packetStream8.send();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(packet.commandSet + "/" + packet.command + " caused: " + arrayIndexOutOfBoundsException);
                PacketStream packetStream9 = new PacketStream(this, packetStream2.id, 128, 41);
                packetStream9.send();
            }
            return;
        }
    }

    @Override
    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] byArray) {
        return new String("");
    }

    protected String getMethodName(byte[] byArray) {
        return new String("");
    }

    protected boolean processFields(ClassFile classFile, PacketStream packetStream, int n) {
        try {
            List<FieldInfo> list = classFile.getAllFieldInfo();
            Iterator<FieldInfo> iterator = list.iterator();
            long l = (long)classFile.getClassID() << 32;
            Log.LOGN(5, "field class id is " + Integer.toHexString(classFile.getClassID()) + " fieldid is " + Long.toHexString(l));
            packetStream.writeInt(list.size());
            while (iterator.hasNext()) {
                FieldInfo fieldInfo = iterator.next();
                if (fieldInfo == null) {
                    throw new Exception("fieldinfo null");
                }
                Log.LOGN(5, "Field: id = " + Long.toHexString(l));
                packetStream.writeLong(l++);
                Log.LOGN(5, "Field: name = " + fieldInfo.getName());
                packetStream.writeString(fieldInfo.getName());
                Log.LOGN(5, "Field: sig = " + fieldInfo.getType());
                packetStream.writeString(fieldInfo.getType());
                Log.LOGN(5, "Field: flags = " + fieldInfo.getAccessFlags());
                packetStream.writeInt(fieldInfo.getAccessFlags());
            }
        }
        catch (Exception exception) {
            System.out.println("Fields cmd: exception " + exception);
            packetStream = new PacketStream(this, n, 128, 20);
            packetStream.send();
            return false;
        }
        return true;
    }

    public void handleLineTable(PacketStream packetStream) throws IOException {
        int n;
        long l;
        long l2;
        ClassFile classFile = null;
        int[][] nArray = null;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt() - ProxyListener.method_index_base;
        Log.LOGN(4, "linetable: class id= " + Integer.toHexString(n2) + ", method id= " + Integer.toHexString(n3 + ProxyListener.method_index_base));
        classFile = ClassManager.classMap.get(new Integer(n2));
        if (classFile == null) {
            Log.LOGN(3, "Linetable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 0);
        MethodInfo methodInfo = classFile.getMethodInfoByIndex(n3);
        if (methodInfo == null) {
            Log.LOGN(1, "Couldn't find methodinfo for index " + n3 + ProxyListener.method_index_base);
            packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            l2 = -1L;
            l = -1L;
        } else {
            l = 0L;
            l2 = codeAttribute.getCodeLength() - 1;
        }
        nArray = methodInfo.getBreakableLineNumbers();
        if (nArray == null) {
            Log.LOGN(1, "No linenumber table found for class " + classFile.getClassName());
            n = 0;
        } else {
            n = nArray.length;
        }
        packetStream3.writeLong(l);
        packetStream3.writeLong(l2);
        Log.LOGN(5, "Starting code offset = " + l + ", Ending code offset = " + l2);
        Log.LOGN(5, "Code Length = " + n);
        packetStream3.writeInt(n);
        for (int i = 0; i < n; ++i) {
            packetStream3.writeLong(nArray[i][1]);
            packetStream3.writeInt(nArray[i][0]);
            Log.LOGN(5, "  index=" + nArray[i][1] + " l#=" + nArray[i][0]);
        }
        packetStream3.send();
    }

    public void handleVariableTable(PacketStream packetStream) throws IOException {
        List<LocalVariable> list = null;
        MethodInfo methodInfo = null;
        int n = packetStream.readInt();
        Log.LOGN(3, "variable: class id = " + Integer.toHexString(n));
        int n2 = packetStream.readInt() - ProxyListener.method_index_base;
        Log.LOGN(3, "variable: method id = " + Integer.toHexString(n2 + ProxyListener.method_index_base));
        ClassFile classFile = ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Variabletable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        try {
            list = classFile.getVariableTableForMethodIndex(n2);
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassName());
            }
        }
        catch (Exception exception) {
            System.out.println("class " + classFile.getClassName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream3.send();
            return;
        }
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(methodInfo.getArgCount());
        if (list != null) {
            packetStream4.writeInt(list.size());
            for (LocalVariable localVariable : list) {
                packetStream4.writeLong(localVariable.getCodeIndex());
                packetStream4.writeString(localVariable.getName());
                packetStream4.writeString(this.getJNISignature(localVariable.getType()));
                packetStream4.writeInt(localVariable.getLength());
                packetStream4.writeInt(localVariable.getSlot());
            }
        } else {
            packetStream4.writeInt(0);
        }
        packetStream4.send();
    }

    private void handleByteCode(PacketStream packetStream) {
        MethodInfo methodInfo = null;
        Log.LOGN(1, "Method: Bytecodes");
        int n = packetStream.readInt();
        Log.LOGN(3, "class id=" + Integer.toHexString(n));
        int n2 = packetStream.readInt() - ProxyListener.method_index_base;
        Log.LOGN(3, "method id=" + Integer.toHexString(n2 + ProxyListener.method_index_base));
        ClassFile classFile = ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Bytecode cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream2.send();
            return;
        }
        try {
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassName());
            }
        }
        catch (Exception exception) {
            System.out.println(" class" + classFile.getClassName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        byte[] byArray = methodInfo.getCodeAttribute().getByteCodes();
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(byArray.length);
        packetStream4.writeByteArray(byArray);
        packetStream4.send();
    }

    private String getJNISignature(String string) {
        int n;
        int n2 = n = string.length();
        String string2 = new String();
        Log.LOGN(6, "getJNISignature()  type == " + string);
        while ((n = string.lastIndexOf("[]", n)) != -1) {
            string2 = string2 + "[";
            n2 = n--;
        }
        String string3 = string.substring(0, n2);
        string2 = "int".equalsIgnoreCase(string3) ? string2 + "I" : ("boolean".equalsIgnoreCase(string3) ? string2 + "Z" : ("short".equalsIgnoreCase(string3) ? string2 + "S" : ("byte".equalsIgnoreCase(string3) ? string2 + "B" : ("char".equalsIgnoreCase(string3) ? string2 + "C" : ("long".equalsIgnoreCase(string3) ? string2 + "J" : ("float".equalsIgnoreCase(string3) ? string2 + "F" : ("double".equalsIgnoreCase(string3) ? string2 + "D" : string2 + "L" + string3.replace('.', '/') + ";")))))));
        return string2;
    }
}

