/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.Commands;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.Options;
import com.sun.javacard.debugproxy.Packet;
import com.sun.javacard.debugproxy.PacketStream;
import com.sun.javacard.debugproxy.ProxyListener;
import com.sun.javacard.debugproxy.SocketConnection;
import com.sun.javacard.debugproxy.classparser.ClassFile;
import com.sun.javacard.debugproxy.classparser.ClassManager;
import com.sun.javacard.debugproxy.classparser.MethodInfo;
import com.sun.javacard.debugproxy.classparser.attributes.CodeAttribute;
import com.sun.javacard.debugproxy.classparser.attributes.LineNumberTableAttribute;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Map;

public final class CJCREListener
extends ProxyListener {
    SocketConnection cjcreConnection;
    ProxyListener debuggerListener = null;
    ClassManager classManager;
    Options options;
    boolean Ready = false;
    Socket remoteSocket = null;

    public CJCREListener(Options options) {
        this.options = options;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.debuggerListener = proxyListener;
        this.classManager = classManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if (!packet.isReplyPacket() && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.cjcreConnection.send(packet);
    }

    @Override
    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            try {
                if (this.remoteSocket != null) {
                    this.remoteSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.debuggerListener.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ClassFile classFile;
        Object object;
        int n;
        String string;
        int n2;
        byte by;
        try {
            while (this.remoteSocket == null) {
                try {
                    this.remoteSocket = new Socket(this.options.getRemoteHost(), this.options.getRemotePort());
                }
                catch (ConnectException connectException) {
                    System.err.println("cjcre.exe (in -debugger mode) not running.");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            System.out.println("cjcre.exe is Ready.");
            this.cjcreConnection = new SocketConnection(this, this.remoteSocket);
        }
        catch (IOException iOException) {
            System.out.println("CJCREListener: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println("CJCREListener: " + securityException.getMessage());
        }
        Object object2 = this;
        synchronized (object2) {
            this.Ready = true;
            this.notify();
        }
        new Thread(this.cjcreConnection).start();
        PacketStream packetStream = new PacketStream(this, 128, 1);
        packetStream.writeString("CJCRE Reference Debugger Agent");
        packetStream.writeByte((byte)1);
        packetStream.writeByte((byte)2);
        packetStream.send();
        try {
            packetStream.waitForReply();
        }
        catch (Exception exception) {
            System.out.println("Exception during handshake: " + exception + " exiting...");
            Runtime.getRuntime().exit(1);
        }
        object2 = packetStream.readString();
        int n3 = packetStream.readInt();
        Log.LOGN(1, "CJCRE Handshake return string: " + (String)object2);
        Log.LOGN(1, "CJCRE Handshake return options: " + n3);
        if ((n3 & 0x18000) >> 15 == 2) {
            Log.LOGN(1, "Method index base being set to 1");
            ProxyListener.method_index_base = 1;
        }
        packetStream = new PacketStream(this, 1, 3);
        packetStream.send();
        try {
            packetStream.waitForReply();
        }
        catch (Exception exception) {
            System.out.println("Couldn't get list of classes from CJCRE");
        }
        int n4 = packetStream.readInt();
        Log.LOGN(2, n4 + " classes");
        for (int i = 0; i < n4; ++i) {
            by = packetStream.readByte();
            n2 = packetStream.readInt();
            string = packetStream.readString();
            if (by != 3) {
                string = new String(string.substring(1, string.length() - 1));
            }
            n = packetStream.readInt();
            Log.LOGN(3, "allclasses: new class: " + string + " " + Integer.toHexString(n2));
            object = this.checkIfClassWasInDebugInfoFile(string);
            if (object != null) {
                classFile = ClassManager.classMap.get(object);
                ClassManager.classMap.remove(object);
            } else {
                classFile = ClassManager.classMap.get(new Integer(n2));
                if (classFile == null) {
                    classFile = this.classManager.findClass(by, string);
                }
            }
            if (classFile == null) continue;
            classFile.setJDWPTypeTag(by);
            classFile.setClassID(n2);
            classFile.setClassStatus(n);
            ClassManager.classMap.put(new Integer(n2), classFile);
        }
        try {
            while (!this.timeToQuit) {
                boolean bl = false;
                object = this.waitForPacket();
                if (object == null) {
                    return;
                }
                if (!((Packet)object).isReplyPacket()) {
                    switch (((Packet)object).commandSet) {
                        case 64: {
                            switch (((Packet)object).command) {
                                case 100: {
                                    PacketStream packetStream2 = new PacketStream(this, (Packet)object);
                                    byte by2 = packetStream2.readByte();
                                    int n5 = packetStream2.readInt();
                                    byte by3 = packetStream2.readByte();
                                    if (by3 != 8) break;
                                    int n6 = packetStream2.readInt();
                                    int n7 = packetStream2.readInt();
                                    by = packetStream2.readByte();
                                    n2 = packetStream2.readInt();
                                    string = packetStream2.readString();
                                    n = packetStream2.readInt();
                                    if (by != 3) {
                                        string = new String(string.substring(1, string.length() - 1));
                                    }
                                    Log.LOGN(3, "ClassPrepare:  " + string + ", ID = " + Integer.toHexString(n2));
                                    classFile = ClassManager.classMap.get(new Integer(n2));
                                    if (classFile == null) {
                                        classFile = this.classManager.findClass(by, string);
                                        if (classFile != null) {
                                            ClassManager.classMap.put(new Integer(n2), classFile);
                                            classFile.setClassID(n2);
                                            classFile.setClassStatus(n);
                                            break;
                                        }
                                        Log.LOGN(3, "ClassPrepare: null cf!");
                                        break;
                                    }
                                    Log.LOGN(3, "ClassPrepare: got classfile " + classFile.getClassName());
                                    classFile.setClassStatus(n);
                                }
                            }
                            break;
                        }
                        case 128: {
                            switch (((Packet)object).command) {
                                case 3: {
                                    PacketStream packetStream3 = new PacketStream(this, (Packet)object);
                                    this.handleSteppingInfo(packetStream3);
                                    bl = true;
                                }
                            }
                            break;
                        }
                    }
                }
                if (bl) continue;
                Log.LOG(3, "CJCREListener:: ");
                Commands.print((Packet)object);
                if (((Packet)object).commandSet == 64 && ((Packet)object).command == 100) {
                    Log.LOGN(3, "Eventkind = " + ((Packet)object).data[5]);
                }
                this.debuggerListener.send((Packet)object);
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Integer checkIfClassWasInDebugInfoFile(String string) {
        ClassFile classFile = null;
        for (Integer n : ClassManager.classMap.keySet()) {
            classFile = ClassManager.classMap.get(n);
            if (!string.equals(classFile.getClassName())) continue;
            return n;
        }
        return null;
    }

    private void handleSteppingInfo(PacketStream packetStream) {
        int n;
        long l;
        long l2;
        long l3;
        MethodInfo methodInfo;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt();
        int n4 = packetStream.readInt() - ProxyListener.method_index_base;
        long l4 = packetStream.readLong();
        Log.LOGN(3, "handleSteppingInfo: cep = " + Integer.toHexString(n2) + " cid = " + Integer.toHexString(n3) + " mid = " + Integer.toHexString(n4));
        PacketStream packetStream2 = new PacketStream(this, 128, 2);
        packetStream2.writeInt(n2);
        ClassFile classFile = ClassManager.classMap.get(new Integer(n3));
        if (classFile == null || (methodInfo = classFile.getMethodInfoByIndex(n4)) == null) {
            packetStream2.writeLong(0L);
            packetStream2.writeLong(0L);
            packetStream2.send();
            try {
                packetStream2.waitForReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        LineNumberTableAttribute lineNumberTableAttribute = null;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        }
        if (codeAttribute == null || lineNumberTableAttribute == null) {
            l3 = -1L;
            l2 = -1L;
            l = -1L;
            n = -1;
            int n5 = -1;
            int n6 = -1;
        } else {
            n = lineNumberTableAttribute.getCurrentLineCodeIndex(l4);
            int n7 = lineNumberTableAttribute.getNextExecutableLineCodeIndex(l4);
            int n8 = lineNumberTableAttribute.getDupCurrentExecutableLineCodeIndex(l4);
            l = lineNumberTableAttribute.getStartPCFromIndex(n7);
            l2 = lineNumberTableAttribute.getStartPCFromIndex(n8);
            l3 = lineNumberTableAttribute.getOffsetofDupNextLine(n8);
        }
        Log.LOGN(3, "handleSteppingInfo  current offset = " + l4);
        Log.LOGN(3, "handleSteppingInfo  target offset = " + l);
        Log.LOGN(3, "handleSteppingInfo  dup current line offset = " + l2);
        Log.LOGN(3, "handleSteppingInfo  offset after current dup = " + l3);
        if (lineNumberTableAttribute != null) {
            Log.LOGN(3, "handleSteppingInfo current line number = " + lineNumberTableAttribute.getLineNumberFromIndex(n));
        }
        packetStream2.writeLong(l);
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l3);
        packetStream2.send();
        try {
            packetStream2.waitForReply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return new String("CJCREListener: ");
    }
}

