/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.LinkException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClinitConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

public class ClassConverter
extends BaseClassInterfaceConverter {
    private static final int CLINIT_METHOD = 0;
    private static final int EXTERNAL_VIRTUAL_METHOD = 1;
    private static final int INTERNAL_VIRTUAL_METHOD = 2;
    private static final int EXTERNAL_STATIC_METHOD = 3;
    private static final int INTERNAL_STATIC_METHOD = 4;
    private static final int PRIVATE_METHOD = 5;
    private static final int EXTERNAL_PRIMITIVE_INSTANCE_FIELD = 0;
    private static final int EXTERNAL_REFERENCE_INSTANCE_FIELD = 1;
    private static final int INTERNAL_REFERENCE_INSTANCE_FIELD = 2;
    private static final int INTERNAL_PRIMITIVE_INSTANCE_FIELD = 3;
    private static final int EXTERNAL_STATIC_COMPILE_TIME_CONST_FIELD = 4;
    private static final int EXTERNAL_STATIC_NON_COMPILE_TIME_CONST_FIELD = 5;
    private static final int INTERNAL_STATIC_FIELD = 6;

    public ClassConverter(JClassFile jClassFile, PackageConverter packageConverter) {
        super(jClassFile, packageConverter);
    }

    public JcClass convert() throws Exception {
        this.intTypeCheck();
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() & 0xFFFFF7FF);
        String[] stringArray = this.determinePublicSuperClasses();
        this.jc_class.setPublicSuperClasses(stringArray);
        String[] stringArray2 = this.determineAllSuperInterfaces(true);
        this.jc_class.setSuperInterfaces(stringArray2);
        if (this.java_class.isPublic()) {
            this.verifyInterfacesFieldRestriction(stringArray2);
        }
        String[] stringArray3 = this.determinePublicSuperInterfaces();
        this.jc_class.setPublicSuperInterfaces(stringArray3);
        this.detectRemovedPublicSuperinterfaces();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperinterfaces();
        }
        this.detectRemovedPublicSuperclasses();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperclasses();
        }
        boolean bl = this.determineShareableType();
        this.jc_class.setShareableType(bl);
        JField[] jFieldArray = this.sortFields();
        JcField[] jcFieldArray = new JcField[jFieldArray.length];
        for (int i = 0; i < jFieldArray.length; ++i) {
            jcFieldArray[i] = new JcField(jFieldArray[i]);
            if (this.getJcClass().getEfClass() == null) continue;
            jcFieldArray[i].setEfField(this.getJcClass().getEfClass().getField(jFieldArray[i].getFieldName(), jFieldArray[i].getFieldDescriptor()));
        }
        this.jc_class.setFields(jcFieldArray);
        this.detectRemovedAPIFields();
        this.detectAddedAPIFields();
        this.checkFieldFlags();
        this.checkFieldValues();
        this.assignFieldTokenAndComputeFieldData();
        this.orderMethods();
        JcMethodTable jcMethodTable = this.constructVirtualMethodTable(1);
        this.jc_class.setPublicMethodTable(jcMethodTable);
        Object object = this.constructImplementedInterfaceInfos(true);
        this.jc_class.setImplementedInterfaceInfos((JcImplementedInterfaceInfo[])object);
        object = this.constructVirtualMethodTable(2);
        this.jc_class.setPackageMethodTable((JcMethodTable)object);
        MethodDefinition[] methodDefinitionArray = this.java_class.getMethods();
        JcMethod[] jcMethodArray = null;
        Vector<MethodDefinition> vector = this.findMethodsByType(methodDefinitionArray, 0);
        if (vector.size() == 0) {
            jcMethodArray = new JcMethod[methodDefinitionArray.length];
        } else {
            jcMethodArray = new JcMethod[methodDefinitionArray.length - 1];
            ClinitConverter clinitConverter = new ClinitConverter((JMethod)vector.elementAt(0), this.jc_class);
            clinitConverter.convert();
        }
        this.jc_class.setMethods(jcMethodArray);
        int n = 0;
        for (MethodDefinition methodDefinition : methodDefinitionArray) {
            if (methodDefinition.getMethodName().equals("<clinit>")) continue;
            MethodConverter methodConverter = new MethodConverter((JMethod)methodDefinition, this, this.p_converter);
            jcMethodArray[n++] = methodConverter.convert();
        }
        this.detectRemovedAPIMethods();
        this.detectModifiedAPIMethods();
        this.detectAddedAPIMethods();
        this.checkMethodFlags();
        this.assignMethodTokens();
        if (this.jc_class.isRemote()) {
            this.markRemoteMethods(stringArray3);
            Object[] objectArray = this.constructImplementedRemoteInterfaceInfos();
            this.jc_class.setImplementedRemoteInterfaceInfos((JcImplementedInterfaceInfo[])objectArray);
        }
        this.jc_class.setImplementedInterfaceInfos(this.constructImplementedInterfaceInfos(false));
        return this.jc_class;
    }

    private void verifyInterfacesFieldRestriction(String[] stringArray) throws Exception {
        JPackage jPackage = this.p_converter.getJavaPackage();
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.addElement(string);
        }
        Object[] objectArray = jPackage.getClasses();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((ClassDefinition)objectArray[i]).isInterfaceType() || !vector.contains(((ClassDefinition)objectArray[i]).getClassName()) || ((ClassDefinition)objectArray[i]).isPublic() || ((JClassFile)objectArray[i]).getFields().length == 0) continue;
            Object[] objectArray2 = new String[]{((ClassDefinition)objectArray[i]).getClassName().replace('/', '.'), this.java_class.getClassName().replace('/', '.')};
            Notifier.error("binary.63", objectArray2);
            throw new ConversionException();
        }
    }

    private void markRemoteMethods(String[] stringArray) {
        String string = "Processing a remote class " + this.jc_class.getClassName() + "   ";
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            string = string + stringArray[i] + " ";
            EfClass efClass = this.getExportClassIfAvailable(stringArray[i]);
            string = string + " ( ";
            if (efClass != null && efClass.isRemote()) {
                object = efClass.getMethods();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    string = string + " exp:" + ((MethodDefinition)object[j]).getMethodName() + ((MethodDefinition)object[j]).getMethodDescriptor();
                    string = string + ":remote ";
                    JcMethod jcMethod = this.jc_class.getMethod(((MethodDefinition)object[j]).getMethodName(), ((MethodDefinition)object[j]).getMethodDescriptor());
                    if (jcMethod == null) continue;
                    jcMethod.setRemote(true);
                }
            }
            if ((object = this.getJcClass(stringArray[i])) != null) {
                JcMethod[] jcMethodArray = ((JcClass)object).getMethods();
                for (int j = 0; j < jcMethodArray.length; ++j) {
                    string = string + " pkg:" + jcMethodArray[j].getMethodName() + jcMethodArray[j].getMethodDescriptor();
                    if (jcMethodArray[j].isRemote()) {
                        string = string + ":remote ";
                        JcMethod jcMethod = this.jc_class.getMethod(jcMethodArray[j].getMethodName(), jcMethodArray[j].getMethodDescriptor());
                        if (jcMethod == null) continue;
                        jcMethod.setRemote(true);
                        continue;
                    }
                    string = string + ":not_remote ";
                }
            }
            string = string + " ) ";
        }
    }

    private void verifyCompatibleWithExportClass(EfClass efClass) throws Exception {
        EfMethod[] efMethodArray;
        if (efClass.isFinal()) {
            Notifier.error("binary.58");
            throw new ConversionException();
        }
        for (EfMethod efMethod : efMethodArray = efClass.getMethods()) {
            if (!efMethod.isFinal() || this.java_class.getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor()) == null) continue;
            Object[] objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), efMethod.getMethodName(), efMethod.getMethodDescriptor()};
            Notifier.error("binary.59", objectArray);
            throw new ConversionException();
        }
    }

    private String[] determinePublicSuperClasses() throws Exception {
        String string = this.jc_class.getSuperClassName();
        if (string == null) {
            return new String[0];
        }
        String string2 = this.jc_class.getClassName();
        String string3 = Names.getPackageName(string2);
        if (!Names.getPackageName(string).equals(string3)) {
            EfClass efClass = this.getExportClass(string);
            if (efClass == null) {
                Object[] objectArray = new String[]{this.jc_class.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error("linking.2", objectArray);
                throw new ConversionException();
            }
            this.verifyCompatibleWithExportClass(efClass);
            String[] stringArray = efClass.getSuperClassNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.getExportClass(stringArray[i]);
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            return stringArray2;
        }
        JcClass jcClass = this.p_converter.getJcClass(string);
        if (Modifier.isPublic(jcClass.getAccessFlags())) {
            String[] stringArray = jcClass.getPublicSuperClasses();
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            stringArray3[stringArray.length] = string;
            return stringArray3;
        }
        if (!Modifier.isPublic(jcClass.getAccessFlags()) && this.jc_class.isPublic() && (jcClass.hasPublicMethods() || jcClass.hasProtectedMethods())) {
            Object[] objectArray = new String[]{this.jc_class.getClassName().replace('/', '.'), string.replace('/', '.')};
            Notifier.error("subset.54", objectArray);
            throw new ConversionException();
        }
        if (!Modifier.isPublic(jcClass.getAccessFlags()) && this.jc_class.isPublic() && (jcClass.hasPublicFields() || jcClass.hasProtectedFields())) {
            Object[] objectArray = new String[]{this.jc_class.getClassName().replace('/', '.'), string.replace('/', '.')};
            Notifier.error("subset.57", objectArray);
            throw new ConversionException();
        }
        return jcClass.getPublicSuperClasses();
    }

    private String[] determineAllSuperInterfaces(boolean bl) throws Exception {
        Object[] objectArray;
        Object object;
        Vector<String> vector = new Vector<String>(15);
        String string = this.java_class.getSuperClassName();
        String string2 = Names.getPackageName(this.java_class.getClassName());
        if (bl && string != null) {
            if (Names.getPackageName(string).equals(string2)) {
                object = this.p_converter.getJcClass(string);
                if (object == null) {
                    Object[] objectArray2 = new String[]{this.java_class.getClassName().replace('/', '.'), string.replace('/', '.')};
                    Notifier.error("linking.3", objectArray2);
                    throw new ConversionException();
                }
                objectArray = ((JcClass)object).getSuperInterfaces();
                this.addInterfaces(vector, (String[])objectArray);
            } else {
                object = this.getExportClass(string);
                if (object == null) {
                    Object[] objectArray3 = new String[]{this.java_class.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                    Notifier.error("linking.2", objectArray3);
                    throw new ConversionException();
                }
                objectArray = ((EfClass)object).getInterfaceNames();
                this.addInterfaces(vector, (String[])objectArray);
            }
        }
        object = this.java_class.getInterfaceNames();
        for (String string3 : object) {
            String[] stringArray;
            ClassDefinition classDefinition;
            if (Names.getPackageName(string3).equals(string2)) {
                classDefinition = this.p_converter.getJcClass(string3);
                if (classDefinition == null) {
                    Object[] objectArray4 = new String[]{this.java_class.getClassName().replace('/', '.'), string3.replace('/', '.')};
                    Notifier.error("linking.5", objectArray4);
                    throw new ConversionException();
                }
                stringArray = ((JcClass)classDefinition).getSuperInterfaces();
            } else {
                classDefinition = this.getExportClass(string3);
                if (classDefinition == null) {
                    Object[] objectArray5 = new String[]{this.java_class.getClassName().replace('/', '.'), string3.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string3))};
                    Notifier.error("linking.4", objectArray5);
                    throw new ConversionException();
                }
                stringArray = ((EfClass)classDefinition).getInterfaceNames();
            }
            this.addInterfaces(vector, stringArray);
            this.addInterface(vector, string3);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private JcMethodTable constructVirtualMethodTable(int n) throws Exception {
        Object[] objectArray;
        MethodDefinition[] methodDefinitionArray = this.getSuperClassMethodTable(this.java_class.getSuperClassName(), n);
        Vector<MethodDefinition> vector = this.findMethodsByType(this.java_class.getMethods(), n);
        Object[] objectArray2 = new MethodDefinition[vector.size()];
        vector.copyInto(objectArray2);
        if (n == 1) {
            this.sortMethods((MethodDefinition[])objectArray2);
        }
        int n2 = 0;
        if (methodDefinitionArray == null) {
            objectArray = objectArray2;
            n2 = 0;
        } else {
            Vector<MethodDefinition> vector2 = new Vector<MethodDefinition>(Arrays.asList(methodDefinitionArray));
            n2 = vector2.size();
            for (Object object : objectArray2) {
                int n3;
                for (n3 = 0; n3 < methodDefinitionArray.length; ++n3) {
                    if (!((MethodDefinition)object).getMethodSignature().equals(methodDefinitionArray[n3].getMethodSignature()) || !((MethodDefinition)object).getMethodName().equals(methodDefinitionArray[n3].getMethodName())) continue;
                    if (n2 > n3) {
                        n2 = n3;
                    }
                    vector2.set(n3, (MethodDefinition)object);
                    break;
                }
                if (n3 != methodDefinitionArray.length) continue;
                vector2.addElement((MethodDefinition)object);
            }
            objectArray = new MethodDefinition[vector2.size()];
            vector2.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (n == 1) {
                ((MethodDefinition)objectArray[i]).setMethodToken(i);
                continue;
            }
            ((MethodDefinition)objectArray[i]).setMethodToken(i | 0x80);
        }
        JcMethodTable jcMethodTable = new JcMethodTable((MethodDefinition[])objectArray, n2);
        return jcMethodTable;
    }

    private void sortMethods(MethodDefinition[] methodDefinitionArray) throws Exception {
        if (!this.isThisExpProvided()) {
            return;
        }
        if (!this.jc_class.isAPIElement(this.p_converter.getJcPackage())) {
            return;
        }
        String string = this.java_class.getClassName();
        EfClass efClass = this.getExportClass(string);
        if (efClass == null) {
            for (int i = 0; i < methodDefinitionArray.length; ++i) {
                methodDefinitionArray[i].setMethodToken(255);
            }
            return;
        }
        for (MethodDefinition methodDefinition : methodDefinitionArray) {
            EfMethod efMethod = efClass.getMethod(methodDefinition.getMethodName(), methodDefinition.getMethodDescriptor());
            if (efMethod == null) {
                methodDefinition.setMethodToken(255);
                continue;
            }
            methodDefinition.setMethodToken(efMethod.getMethodToken());
        }
        ClassConverter.sortMethodsByTokens(methodDefinitionArray);
    }

    private MethodDefinition[] getSuperClassMethodTable(String string, int n) throws Exception {
        if (string == null) {
            return new MethodDefinition[0];
        }
        String string2 = Names.getPackageName(string);
        JcPackage jcPackage = this.p_converter.getJcPackage();
        if (jcPackage.getPackageName().equals(string2)) {
            JcClass jcClass = this.p_converter.getJcClass(string);
            if (n == 1) {
                return jcClass.getPublicMethodTable().getMethods();
            }
            return jcClass.getPackageMethodTable().getMethods();
        }
        if (n == 1) {
            return this.getMethodsFromExportClass(string, 1);
        }
        return new MethodDefinition[0];
    }

    private MethodDefinition[] getMethodsFromExportClass(String string, int n) throws Exception {
        EfClass efClass = this.getExportClass(string);
        if (efClass == null) {
            return new MethodDefinition[0];
        }
        Vector<MethodDefinition> vector = this.findMethodsByType(efClass.getMethods(), n);
        Object[] objectArray = new EfMethod[vector.size()];
        vector.copyInto(objectArray);
        ClassConverter.sortMethodsByTokens((MethodDefinition[])objectArray);
        return objectArray;
    }

    private Vector<MethodDefinition> findMethodsByType(MethodDefinition[] methodDefinitionArray, int n) {
        Vector<MethodDefinition> vector = new Vector<MethodDefinition>(20);
        block11: for (MethodDefinition methodDefinition : methodDefinitionArray) {
            int n2 = methodDefinition.getAccessFlags();
            if (methodDefinition.getMethodName().equals("<clinit>")) {
                if (n != 0) continue;
                vector.addElement(methodDefinition);
                continue;
            }
            if (methodDefinition.getMethodName().equals("<init>")) {
                switch (n) {
                    case 3: {
                        if (!Modifier.isPublic(n2) && !Modifier.isProtected(n2)) break;
                        vector.addElement(methodDefinition);
                        break;
                    }
                    case 4: {
                        if (Modifier.isPublic(n2) || Modifier.isProtected(n2)) break;
                        vector.addElement(methodDefinition);
                    }
                }
                continue;
            }
            switch (n) {
                case 1: {
                    if (Modifier.isStatic(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2)) continue block11;
                    vector.addElement(methodDefinition);
                    continue block11;
                }
                case 2: {
                    if (Modifier.isStatic(n2) || Modifier.isPublic(n2) || Modifier.isProtected(n2) || Modifier.isPrivate(n2)) continue block11;
                    vector.addElement(methodDefinition);
                    continue block11;
                }
                case 3: {
                    if (!Modifier.isStatic(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2)) continue block11;
                    vector.addElement(methodDefinition);
                    continue block11;
                }
                case 4: {
                    if (!Modifier.isStatic(n2) || Modifier.isPublic(n2) && Modifier.isProtected(n2)) continue block11;
                    vector.addElement(methodDefinition);
                    continue block11;
                }
                case 5: {
                    if (Modifier.isStatic(n2) || !Modifier.isPrivate(n2)) continue block11;
                    vector.addElement(methodDefinition);
                }
            }
        }
        return vector;
    }

    private void assignMethodTokens() throws Exception {
        int n;
        MethodDefinition[] methodDefinitionArray = this.getJcClass().getMethods();
        Vector<MethodDefinition> vector = this.findMethodsByType(methodDefinitionArray, 1);
        Object[] objectArray = new JcMethod[vector.size()];
        vector.copyInto(objectArray);
        MethodDefinition[] methodDefinitionArray2 = this.jc_class.getPublicMethodTable().getMethods();
        for (Object object : objectArray) {
            n = ClassConverter.getToken(methodDefinitionArray2, (MethodDefinition)object);
            ((MethodDefinition)object).setMethodToken(n);
        }
        ClassConverter.sortMethodsByTokens(methodDefinitionArray2);
        ClassConverter.assignNewMethodTokens(methodDefinitionArray2);
        for (Object object : objectArray) {
            n = ClassConverter.getToken(methodDefinitionArray2, (MethodDefinition)object);
            ((MethodDefinition)object).setMethodToken(n);
        }
        vector = this.findMethodsByType(methodDefinitionArray, 2);
        Object[] objectArray2 = new JcMethod[vector.size()];
        vector.copyInto(objectArray2);
        MethodDefinition[] methodDefinitionArray3 = this.jc_class.getPackageMethodTable().getMethods();
        for (Object object : objectArray2) {
            ((MethodDefinition)object).setMethodToken(ClassConverter.getToken(methodDefinitionArray3, (MethodDefinition)object) | 0x80);
        }
        vector = this.findMethodsByType(methodDefinitionArray, 3);
        Object[] objectArray3 = new JcMethod[vector.size()];
        vector.copyInto(objectArray3);
        if (this.isThisExpProvided()) {
            MethodDefinition[] methodDefinitionArray4 = this.getMethodsFromExportClass(this.jc_class.getClassName(), 3);
            for (Object object : objectArray3) {
                ((MethodDefinition)object).setMethodToken(ClassConverter.getToken(methodDefinitionArray4, (MethodDefinition)object));
            }
        } else {
            for (int i = 0; i < objectArray3.length; ++i) {
                ((MethodDefinition)objectArray3[i]).setMethodToken(i);
            }
        }
        ClassConverter.sortMethodsByTokens((MethodDefinition[])objectArray3);
        ClassConverter.assignNewMethodTokens((MethodDefinition[])objectArray3);
    }

    private static int getToken(MethodDefinition[] methodDefinitionArray, MethodDefinition methodDefinition) {
        for (MethodDefinition methodDefinition2 : methodDefinitionArray) {
            if (!methodDefinition2.getMethodName().equals(methodDefinition.getMethodName()) || !methodDefinition2.getMethodSignature().equals(methodDefinition.getMethodSignature())) continue;
            return methodDefinition2.getMethodToken();
        }
        return 255;
    }

    private JField[] sortFields() {
        JField[] jFieldArray = this.java_class.getFields();
        JField[] jFieldArray2 = new JField[jFieldArray.length];
        int n = 0;
        n = this.selectSortFieldsByType(jFieldArray2, n, 0);
        n = this.selectSortFieldsByType(jFieldArray2, n, 1);
        n = this.selectFieldsByType(jFieldArray2, n, 2);
        n = this.selectFieldsByType(jFieldArray2, n, 3);
        n = this.selectSortFieldsByType(jFieldArray2, n, 4);
        n = this.selectSortFieldsByType(jFieldArray2, n, 5);
        n = this.selectFieldsByType(jFieldArray2, n, 6);
        return jFieldArray2;
    }

    private int selectFieldsByType(JField[] jFieldArray, int n, int n2) {
        FieldDefinition[] fieldDefinitionArray = this.java_class.getFields();
        Vector<FieldDefinition> vector = this.findFieldsByType(fieldDefinitionArray, n2);
        Object[] objectArray = new JField[vector.size()];
        vector.copyInto(objectArray);
        System.arraycopy(objectArray, 0, jFieldArray, n, objectArray.length);
        return n += objectArray.length;
    }

    private int selectSortFieldsByType(JField[] jFieldArray, int n, int n2) {
        FieldDefinition[] fieldDefinitionArray = this.java_class.getFields();
        Vector<FieldDefinition> vector = this.findFieldsByType(fieldDefinitionArray, n2);
        Object[] objectArray = new JField[vector.size()];
        vector.copyInto(objectArray);
        String string = this.java_class.getClassName();
        System.arraycopy(objectArray, 0, jFieldArray, n, objectArray.length);
        return n += objectArray.length;
    }

    private Vector<FieldDefinition> findFieldsByType(FieldDefinition[] fieldDefinitionArray, int n) {
        Vector<FieldDefinition> vector = new Vector<FieldDefinition>(20);
        block9: for (FieldDefinition fieldDefinition : fieldDefinitionArray) {
            int n2 = fieldDefinition.getAccessFlags();
            String string = fieldDefinition.getFieldDescriptor();
            switch (n) {
                case 4: {
                    if (!Modifier.isStatic(n2) || !Modifier.isFinal(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2) || DataType.getType(string) == 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 5: {
                    if (Modifier.isStatic(n2) && !Modifier.isFinal(n2) && (Modifier.isPublic(n2) || Modifier.isProtected(n2))) {
                        vector.addElement(fieldDefinition);
                    }
                    if (!Modifier.isStatic(n2) || !Modifier.isFinal(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2) || DataType.getType(string) != 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 6: {
                    if (!Modifier.isStatic(n2) || Modifier.isPublic(n2) || Modifier.isProtected(n2)) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 0: {
                    if (Modifier.isStatic(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2) || DataType.getType(string) == 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 1: {
                    if (Modifier.isStatic(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2) || DataType.getType(string) != 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 2: {
                    if (Modifier.isStatic(n2) || Modifier.isPublic(n2) || Modifier.isProtected(n2) || DataType.getType(string) != 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                case 3: {
                    if (Modifier.isStatic(n2) || Modifier.isPublic(n2) || Modifier.isProtected(n2) || DataType.getType(string) == 10) continue block9;
                    vector.addElement(fieldDefinition);
                    continue block9;
                }
                default: {
                    throw new ConverterInternalError();
                }
            }
        }
        return vector;
    }

    private EfField[] getFieldsFromExportFile(int n) throws Exception {
        EfClass efClass = this.getExportClass(this.java_class.getClassName());
        if (efClass == null) {
            Object[] objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), this.java_class.getClassName().replace('/', '.'), Names.getExportFileName(Names.getPackageName(this.java_class.getClassName()))};
            Notifier.error("linking.6", objectArray);
            throw new LinkException();
        }
        Vector<FieldDefinition> vector = this.findFieldsByType(efClass.getFields(), n);
        Object[] objectArray = new EfField[vector.size()];
        vector.copyInto(objectArray);
        block0: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            for (int j = i + 1; j < objectArray.length; ++j) {
                Object object2 = objectArray[j];
                if (((FieldDefinition)object).getFieldToken() <= ((FieldDefinition)object2).getFieldToken()) continue;
                Object object3 = object;
                objectArray[i] = objectArray[j];
                objectArray[j] = object3;
                --i;
                continue block0;
            }
        }
        return objectArray;
    }

    private void assignFieldTokenAndComputeFieldData() {
        int n;
        this.assignKnownFieldTokens();
        this.presortFieldsByTokens();
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 0;
        JcField[] jcFieldArray = this.getJcClass().getFields();
        for (n = 0; n < jcFieldArray.length && !jcFieldArray[n].isStatic(); ++n) {
            String string = jcFieldArray[n].getFieldDescriptor();
            if (DataType.getType(string) == 10) {
                if (n3 > n5) {
                    n3 = n5;
                }
                ++n4;
            }
            jcFieldArray[n].setFieldToken(n5);
            int n6 = this.getFieldSize(string);
            n2 += n6;
            n5 += n6;
        }
        this.jc_class.setDeclaredInstanceSize(n2);
        this.jc_class.setFirstReferenceToken(n3);
        this.jc_class.setReferenceCount(n4);
        n5 = 0;
        while (n < jcFieldArray.length) {
            int n7 = jcFieldArray[n].getAccessFlags();
            if (Modifier.isPublic(n7) || Modifier.isProtected(n7)) {
                if (Modifier.isFinal(n7)) {
                    if (jcFieldArray[n].getFieldDescriptor().startsWith("[") || jcFieldArray[n].getFieldDescriptor().startsWith("L")) {
                        jcFieldArray[n].setFieldToken(n5);
                        ++n5;
                    }
                } else {
                    jcFieldArray[n].setFieldToken(n5);
                    ++n5;
                }
            }
            ++n;
        }
    }

    private int getFieldSize(String string) {
        if (string.equals("I")) {
            return 2;
        }
        return 1;
    }

    private JcImplementedInterfaceInfo[] constructImplementedInterfaceInfos(boolean bl) throws Exception {
        String[] stringArray = null;
        stringArray = bl ? this.jc_class.getSuperInterfaces() : this.determineAllSuperInterfaces(false);
        JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray = new JcImplementedInterfaceInfo[stringArray.length];
        MethodDefinition[] methodDefinitionArray = this.jc_class.getPublicMethodTable().getMethods();
        String string = Names.getPackageName(this.jc_class.getClassName());
        for (int i = 0; i < stringArray.length; ++i) {
            JcImplementedInterfaceInfo jcImplementedInterfaceInfo;
            MethodDefinition[] methodDefinitionArray2;
            Object[] objectArray;
            ClassDefinition classDefinition;
            String string2 = stringArray[i];
            if (Names.getPackageName(string2).equals(string)) {
                classDefinition = this.p_converter.getJcClass(string2);
                if (classDefinition == null) {
                    objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.')};
                    Notifier.error("linking.5", objectArray);
                    throw new ConversionException();
                }
                methodDefinitionArray2 = ((JcClass)classDefinition).getPublicMethodTable().getMethods();
            } else {
                classDefinition = this.getExportClass(string2);
                if (classDefinition == null) {
                    objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string2))};
                    Notifier.error("linking.4", objectArray);
                    throw new ConversionException();
                }
                if (!classDefinition.isInterfaceType()) {
                    objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.')};
                    Notifier.error("linking.27", objectArray);
                    throw new ConversionException();
                }
                methodDefinitionArray2 = ((EfClass)classDefinition).getMethods();
            }
            classDefinition = new MethodDefinition[methodDefinitionArray2.length];
            for (MethodDefinition methodDefinition : methodDefinitionArray2) {
                int n = methodDefinition.getMethodToken();
                classDefinition[n] = methodDefinition;
            }
            objectArray = new int[((ClassDefinition)classDefinition).length];
            for (int j = 0; j < ((ClassDefinition)classDefinition).length; ++j) {
                MethodDefinition[] methodDefinitionArray3;
                int n;
                ClassDefinition classDefinition2 = classDefinition[j];
                for (n = 0; n < methodDefinitionArray.length; ++n) {
                    methodDefinitionArray3 = methodDefinitionArray[n];
                    if (!((MethodDefinition)((Object)classDefinition2)).getMethodName().equals(methodDefinitionArray3.getMethodName()) || !((MethodDefinition)((Object)classDefinition2)).getMethodDescriptor().equals(methodDefinitionArray3.getMethodDescriptor())) continue;
                    objectArray[j] = n;
                    break;
                }
                if (n != methodDefinitionArray.length) continue;
                if (!this.jc_class.isAbstract()) {
                    Object[] objectArray2 = new Object[]{((MethodDefinition)((Object)classDefinition2)).getMethodName(), ((MethodDefinition)((Object)classDefinition2)).getMethodDescriptor(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.62", objectArray2);
                    throw new ConverterException();
                }
                this.java_class.addMethod(new JMethod((MethodDefinition)((Object)classDefinition2)));
                methodDefinitionArray3 = new MethodDefinition[methodDefinitionArray.length + 1];
                System.arraycopy(methodDefinitionArray, 0, methodDefinitionArray3, 0, methodDefinitionArray.length);
                methodDefinitionArray3[methodDefinitionArray.length] = new JMethod((MethodDefinition)((Object)classDefinition2));
                methodDefinitionArray = methodDefinitionArray3;
                int n2 = this.jc_class.getPublicMethodTable().getMethodTableBase();
                this.jc_class.setPublicMethodTable(new JcMethodTable(methodDefinitionArray, n2));
                objectArray[j] = n;
            }
            jcImplementedInterfaceInfoArray[i] = jcImplementedInterfaceInfo = new JcImplementedInterfaceInfo(string2, (MethodDefinition[])classDefinition, (int[])objectArray);
        }
        return jcImplementedInterfaceInfoArray;
    }

    private boolean isThisExpProvided() {
        int n = this.java_class.getAccessFlags();
        if (Modifier.isPublic(n)) {
            return this.p_converter.isThisExpProvided();
        }
        return false;
    }

    private void orderMethods() {
        int n;
        JMethod jMethod;
        int n2;
        int n3;
        JMethod jMethod2;
        int n4;
        JMethod[] jMethodArray = this.java_class.getMethods();
        block0: for (n4 = 0; n4 < jMethodArray.length; ++n4) {
            jMethod2 = jMethodArray[n4];
            n3 = jMethodArray[n4].getAccessFlags();
            if (!Modifier.isFinal(n3)) continue;
            for (n2 = 0; n2 < jMethodArray.length; ++n2) {
                jMethod = jMethodArray[n2];
                if (Modifier.isFinal(jMethod.getAccessFlags())) continue;
                if (n2 >= n4) continue block0;
                for (n = n4; n > n2; --n) {
                    jMethodArray[n] = jMethodArray[n - 1];
                }
                jMethodArray[n2] = jMethod2;
                continue block0;
            }
        }
        block3: for (n4 = jMethodArray.length - 1; n4 >= 0; --n4) {
            jMethod2 = jMethodArray[n4];
            n3 = jMethodArray[n4].getAccessFlags();
            if (Modifier.isFinal(n3) || !Modifier.isAbstract(n3)) continue;
            for (n2 = jMethodArray.length - 1; n2 >= 0; --n2) {
                jMethod = jMethodArray[n2];
                if (Modifier.isAbstract(jMethod.getAccessFlags())) continue;
                if (n4 >= n2) continue block3;
                for (n = n4; n < n2; ++n) {
                    jMethodArray[n] = jMethodArray[n + 1];
                }
                jMethodArray[n2] = jMethod2;
                ++n4;
                continue block3;
            }
        }
    }

    protected void detectRemovedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethodArray = this.getJcClass().getEfClass().getMethods();
        for (int i = 0; i < efMethodArray.length; ++i) {
            MethodDefinition methodDefinition;
            EfMethod efMethod = efMethodArray[i];
            JcMethod jcMethod = this.getJcClass().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            if (jcMethod != null || (methodDefinition = this.getJcClass().getPublicMethodTable().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor())) != null) continue;
            Object[] objectArray = new Object[]{efMethod.getMethodDescriptor(), efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.22", objectArray);
            throw new ConverterException();
        }
    }

    protected void detectAddedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        JcMethod[] jcMethodArray = this.getJcClass().getMethods();
        for (int i = 0; i < jcMethodArray.length; ++i) {
            Object[] objectArray;
            EfMethod efMethod;
            if (!jcMethodArray[i].isPublic() && !jcMethodArray[i].isProtected() || (efMethod = this.getJcClass().getEfClass().getMethod(jcMethodArray[i].getMethodName(), jcMethodArray[i].getMethodDescriptor())) != null) continue;
            if (!this.getPackageConverter().getConversionProfile().packageUpgrade && jcMethodArray[i].isStatic()) {
                objectArray = new Object[]{jcMethodArray[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.23", objectArray);
                throw new ConverterException();
            }
            objectArray = this.getJcClass().getEfClass();
            if (!(this.getJcClass().isFinal() || jcMethodArray[i].isStatic() || jcMethodArray[i].getMethodName().equals("<init>") || objectArray.isFinal())) {
                Object[] objectArray2 = new Object[]{jcMethodArray[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.24", objectArray2);
                throw new ConverterException();
            }
            if (this.getPackageConverter().getConversionProfile().packageUpgrade || jcMethodArray[i].isStatic() || !this.getJcClass().isFinal()) continue;
            Object[] objectArray3 = new Object[]{jcMethodArray[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.25", objectArray3);
            throw new ConverterException();
        }
    }

    private static void sortMethodsByTokens(MethodDefinition[] methodDefinitionArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < methodDefinitionArray.length - 1; ++i) {
                if (methodDefinitionArray[i].getMethodToken() <= methodDefinitionArray[i + 1].getMethodToken()) continue;
                bl = true;
                MethodDefinition methodDefinition = methodDefinitionArray[i];
                methodDefinitionArray[i] = methodDefinitionArray[i + 1];
                methodDefinitionArray[i + 1] = methodDefinition;
            }
        }
    }

    private static void assignNewMethodTokens(MethodDefinition[] methodDefinitionArray) {
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            methodDefinitionArray[i].setMethodToken(i);
        }
    }

    protected void detectModifiedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethodArray = this.getJcClass().getEfClass().getMethods();
        for (int i = 0; i < efMethodArray.length; ++i) {
            EfMethod efMethod = efMethodArray[i];
            MethodDefinition methodDefinition = this.getJcClass().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            if (methodDefinition == null) {
                methodDefinition = this.getJcClass().getPublicMethodTable().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            }
            if (efMethod.isStatic() && !methodDefinition.isStatic()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.26", objectArray);
                throw new ConverterException();
            }
            if (!efMethod.isStatic() && methodDefinition.isStatic()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.27", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && methodDefinition.isPrivate()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.28", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && methodDefinition.isProtected()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.29", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isProtected() && methodDefinition.isPrivate()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.30", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && methodDefinition.isDefault()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.31", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isProtected() && methodDefinition.isDefault()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.32", objectArray);
                throw new ConverterException();
            }
            if (this.getPackageConverter().getConversionProfile().packageUpgrade) continue;
            if (efMethod.isProtected() && methodDefinition.isPublic()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.33", objectArray);
                throw new ConverterException();
            }
            if (efMethod.isFinal() && !methodDefinition.isFinal()) {
                Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.34", objectArray);
                throw new ConverterException();
            }
            if (!efMethod.isAbstract() || methodDefinition.isAbstract()) continue;
            Object[] objectArray = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.35", objectArray);
            throw new ConverterException();
        }
    }

    protected void detectRemovedPublicSuperclasses() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> vector = new Vector<String>(Arrays.asList(efClass.getSuperClassNames()));
        Vector<String> vector2 = new Vector<String>(Arrays.asList(jcClass.getPublicSuperClasses()));
        if (vector2.containsAll(vector)) {
            return;
        }
        vector.removeAll(vector2);
        if (!vector.isEmpty()) {
            Object[] objectArray = new Object[]{vector.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.36", objectArray);
            throw new ConverterException();
        }
    }

    protected void detectAddedPublicSuperclasses() throws Exception {
        Vector<String> vector;
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> vector2 = new Vector<String>(Arrays.asList(efClass.getSuperClassNames()));
        if (vector2.containsAll(vector = new Vector<String>(Arrays.asList(jcClass.getPublicSuperClasses())))) {
            return;
        }
        vector.removeAll(vector2);
        if (!vector.isEmpty()) {
            Object[] objectArray = new Object[]{vector.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.38", objectArray);
            throw new ConverterException();
        }
    }

    private JcImplementedInterfaceInfo[] constructImplementedRemoteInterfaceInfos() throws Exception {
        String[] stringArray = this.jc_class.getSuperInterfaces();
        JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray = new JcImplementedInterfaceInfo[stringArray.length];
        MethodDefinition[] methodDefinitionArray = this.jc_class.getPublicMethodTable().getMethods();
        String string = Names.getPackageName(this.jc_class.getClassName());
        for (int i = 0; i < stringArray.length; ++i) {
            JcImplementedInterfaceInfo jcImplementedInterfaceInfo;
            MethodDefinition[] methodDefinitionArray2;
            Object[] objectArray;
            ClassDefinition classDefinition;
            String string2 = stringArray[i];
            if ("java/rmi/Remote".equals(string2)) {
                jcImplementedInterfaceInfoArray[i] = null;
                continue;
            }
            if (Names.getPackageName(string2).equals(string)) {
                classDefinition = this.p_converter.getJcClass(string2);
                if (classDefinition == null) {
                    objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.')};
                    Notifier.error("linking.5", objectArray);
                    throw new ConversionException();
                }
                if (!((JcClass)classDefinition).isRemote()) {
                    jcImplementedInterfaceInfoArray[i] = null;
                    continue;
                }
                methodDefinitionArray2 = ((JcClass)classDefinition).getPublicMethodTable().getMethods();
            } else {
                classDefinition = this.getExportClass(string2);
                if (classDefinition == null) {
                    objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string2))};
                    Notifier.error("linking.4", objectArray);
                    throw new ConversionException();
                }
                if (!((EfClass)classDefinition).isRemote()) {
                    jcImplementedInterfaceInfoArray[i] = null;
                    continue;
                }
                methodDefinitionArray2 = ((EfClass)classDefinition).getMethods();
            }
            classDefinition = new MethodDefinition[methodDefinitionArray2.length];
            for (MethodDefinition methodDefinition : methodDefinitionArray2) {
                int n = methodDefinition.getMethodToken();
                classDefinition[n] = methodDefinition;
            }
            objectArray = new int[((ClassDefinition)classDefinition).length];
            for (int j = 0; j < ((ClassDefinition)classDefinition).length; ++j) {
                int n;
                ClassDefinition classDefinition2 = classDefinition[j];
                for (n = 0; n < methodDefinitionArray.length; ++n) {
                    MethodDefinition methodDefinition = methodDefinitionArray[n];
                    if (!((MethodDefinition)((Object)classDefinition2)).getMethodName().equals(methodDefinition.getMethodName()) || !((MethodDefinition)((Object)classDefinition2)).getMethodDescriptor().equals(methodDefinition.getMethodDescriptor())) continue;
                    objectArray[j] = n;
                    break;
                }
                if (n != methodDefinitionArray.length) continue;
                throw new ClassFormatError();
            }
            jcImplementedInterfaceInfoArray[i] = jcImplementedInterfaceInfo = new JcImplementedInterfaceInfo(string2, (MethodDefinition[])classDefinition, (int[])objectArray);
        }
        return jcImplementedInterfaceInfoArray;
    }
}

