/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantValueAttribute;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

abstract class BaseClassInterfaceConverter {
    JClassFile java_class;
    JcClass jc_class;
    PackageConverter p_converter;

    BaseClassInterfaceConverter(JClassFile jClassFile, PackageConverter packageConverter) {
        this.java_class = jClassFile;
        this.p_converter = packageConverter;
        this.jc_class = new JcClass(jClassFile);
        if (packageConverter.getJcPackage().getEfExportFile() != null) {
            this.jc_class.setEfClass(packageConverter.getJcPackage().getEfExportFile().getClass(jClassFile.getClassName()));
        }
    }

    public JcClass getJcClass() {
        return this.jc_class;
    }

    public JClassFile getJavaClass() {
        return this.java_class;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    protected String[] determinePublicSuperInterfaces() throws Exception {
        Object[] objectArray = this.jc_class.getSuperInterfaces();
        Vector<String> vector = new Vector<String>(15);
        String string = Names.getPackageName(this.java_class.getClassName());
        for (String string2 : objectArray) {
            ClassDefinition classDefinition;
            if (Names.getPackageName(string2).equals(string)) {
                classDefinition = this.p_converter.getJcClass(string2);
                if (classDefinition == null) {
                    throw new ConversionException();
                }
                int n = classDefinition.getAccessFlags();
                if (!Modifier.isPublic(n)) continue;
                vector.addElement(string2);
                continue;
            }
            classDefinition = this.getExportClass(string2);
            if (classDefinition == null) {
                throw new ConversionException();
            }
            vector.addElement(string2);
        }
        Object[] objectArray2 = new String[vector.size()];
        vector.copyInto(objectArray2);
        return objectArray2;
    }

    protected boolean determineShareableType() {
        String[] stringArray;
        for (String string : stringArray = this.jc_class.getPublicSuperInterfaces()) {
            if (!string.equals("javacard/framework/Shareable")) continue;
            return true;
        }
        return this.java_class.getClassName().equals("javacard/framework/Shareable");
    }

    protected void addInterfaces(Vector<String> vector, String[] stringArray) {
        for (String string : stringArray) {
            this.addInterface(vector, string);
        }
    }

    protected void addInterface(Vector<String> vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i);
            if (!string2.equals(string)) continue;
            return;
        }
        vector.addElement(string);
    }

    protected void intTypeCheck() throws Exception {
        Object[] objectArray;
        JField[] jFieldArray = this.java_class.getFields();
        Object[] objectArray2 = jFieldArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            JField jField = objectArray2[i];
            Object object = jField.getFieldDescriptor();
            if (!((String)object).equals("I") && !((String)object).equals("[I")) continue;
            if (this.p_converter.isIntSupported()) {
                objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), jField.getFieldName()};
                Notifier.progress("warning.1", objectArray);
                this.p_converter.setIntFlag(true);
                continue;
            }
            objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), jField.getFieldName()};
            Notifier.error("int.1", objectArray);
            throw new ConversionException();
        }
        for (Object object : objectArray2 = this.java_class.getMethods()) {
            objectArray = ((MethodDefinition)object).getMethodDescriptor();
            String[] stringArray = MethodDescriptor.getParamDescriptors((String)objectArray);
            for (String string : stringArray) {
                Object[] objectArray3;
                if (!string.equals("I") && !string.equals("[I")) continue;
                if (this.p_converter.isIntSupported()) {
                    objectArray3 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object).getMethodName()};
                    Notifier.progress("warning.2", objectArray3);
                    this.p_converter.setIntFlag(true);
                    continue;
                }
                objectArray3 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object).getMethodName()};
                Notifier.error("int.2", objectArray3);
                throw new ConversionException();
            }
            String string = MethodDescriptor.getReturnDescriptor((String)objectArray);
            if (!string.equals("I") && !string.equals("[I")) continue;
            if (this.p_converter.isIntSupported()) {
                Object[] objectArray4 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object).getMethodName()};
                Notifier.progress("warning.3", objectArray4);
                this.p_converter.setIntFlag(true);
                continue;
            }
            Object[] objectArray5 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object).getMethodName()};
            Notifier.error("int.3", objectArray5);
            throw new ConversionException();
        }
    }

    protected EfClass getExportClass(String string) throws Exception {
        ExportFileManager exportFileManager = this.p_converter.getExportFileManager();
        EfClass efClass = exportFileManager.getClass(string);
        return efClass;
    }

    protected EfClass getExportClassIfAvailable(String string) {
        ExportFileManager exportFileManager = this.p_converter.getExportFileManager();
        EfClass efClass = exportFileManager.getClassIfAvailable(string);
        return efClass;
    }

    protected JcClass getJcClass(String string) {
        JcClass jcClass = this.p_converter.getJcClass(string);
        return jcClass;
    }

    protected void detectRemovedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfField[] efFieldArray = this.getJcClass().getEfClass().getFields();
        for (int i = 0; i < efFieldArray.length; ++i) {
            EfField efField = efFieldArray[i];
            JcField jcField = this.getJcClass().getField(efField.getFieldName(), efField.getFieldDescriptor());
            if (jcField != null && jcField.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) continue;
            Object[] objectArray = new Object[]{efField.getFieldName()};
            Notifier.error("binary.3", objectArray);
            throw new ConversionException();
        }
    }

    protected void checkFieldFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        for (int i = 0; i < this.getJcClass().getFields().length; ++i) {
            JcField jcField = this.getJcClass().getFields()[i];
            if (jcField.getEfField() == null) continue;
            EfField efField = jcField.getEfField();
            if (efField.isStatic() && !jcField.isStatic()) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.4", objectArray);
                throw new ConversionException();
            }
            if (!efField.isStatic() && jcField.isStatic()) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.5", objectArray);
                throw new ConversionException();
            }
            if (efField.isPublic() && jcField.isProtected()) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.6", objectArray);
                throw new ConversionException();
            }
            if (!efField.isFinal() && jcField.isFinal()) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.7", objectArray);
                throw new ConversionException();
            }
            if (!efField.isFinal() || jcField.isFinal() || !jcField.isStatic()) continue;
            Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.8", objectArray);
            throw new ConversionException();
        }
    }

    protected void checkMethodFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        for (int i = 0; i < this.getJcClass().getMethods().length; ++i) {
            Object[] objectArray;
            JcMethod jcMethod = this.getJcClass().getMethods()[i];
            if (jcMethod.getEfMethod() == null) continue;
            EfMethod efMethod = jcMethod.getEfMethod();
            if (efMethod.isStatic() && !jcMethod.isStatic()) {
                objectArray = new Object[]{jcMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.9", objectArray);
                throw new ConversionException();
            }
            if (!efMethod.isStatic() && jcMethod.isStatic()) {
                objectArray = new Object[]{jcMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.10", objectArray);
                throw new ConversionException();
            }
            if (efMethod.isPublic() && jcMethod.isProtected()) {
                objectArray = new Object[]{jcMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.11", objectArray);
                throw new ConversionException();
            }
            objectArray = this.getJcClass().getEfClass();
            if (!efMethod.isFinal() && jcMethod.isFinal() && !objectArray.isFinal()) {
                Object[] objectArray2 = new Object[]{jcMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.12", objectArray2);
                throw new ConversionException();
            }
            if (efMethod.isAbstract() || !jcMethod.isAbstract()) continue;
            Object[] objectArray3 = new Object[]{jcMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.13", objectArray3);
            throw new ConversionException();
        }
    }

    protected void detectAddedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        boolean bl = this.getJcClass().getEfClass().hasReferenceAPIField();
        for (int i = 0; i < this.getJcClass().getFields().length; ++i) {
            JcField jcField = this.getJcClass().getFields()[i];
            if (!jcField.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) continue;
            if (jcField.getEfField() == null) {
                if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
                    Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.14", objectArray);
                    throw new ConversionException();
                }
                if (!bl || jcField.isReferenceType()) continue;
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.15", objectArray);
                throw new ConversionException();
            }
            if (this.getPackageConverter().getConversionProfile().packageUpgrade) continue;
            if (jcField.getEfField().isProtected() && jcField.isPublic()) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.16", objectArray);
                throw new ConversionException();
            }
            if (!jcField.getEfField().isFinal() || jcField.isFinal()) continue;
            Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.17", objectArray);
            throw new ConversionException();
        }
    }

    protected void assignKnownFieldTokens() {
        JcField[] jcFieldArray = this.getJcClass().getFields();
        for (int i = 0; i < jcFieldArray.length; ++i) {
            if (jcFieldArray[i].getEfField() != null) {
                jcFieldArray[i].setFieldToken(jcFieldArray[i].getEfField().getFieldToken());
                continue;
            }
            jcFieldArray[i].setFieldToken(255);
        }
    }

    protected void presortFieldsByTokens() {
        JcField[] jcFieldArray = this.getJcClass().getFields();
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < jcFieldArray.length - 1; ++i) {
                if (!jcFieldArray[i].isStatic() && jcFieldArray[i + 1].isStatic() || (jcFieldArray[i].getFieldToken() <= jcFieldArray[i + 1].getFieldToken() || jcFieldArray[i].getFieldToken() == 255 || jcFieldArray[i + 1].getFieldToken() == 255) && (jcFieldArray[i].getFieldToken() != 255 || jcFieldArray[i + 1].getFieldToken() == 255)) continue;
                JcField jcField = jcFieldArray[i];
                jcFieldArray[i] = jcFieldArray[i + 1];
                jcFieldArray[i + 1] = jcField;
                bl = true;
            }
        }
    }

    protected void checkFieldValues() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        JcField[] jcFieldArray = this.getJcClass().getFields();
        for (int i = 0; i < jcFieldArray.length; ++i) {
            if (!jcFieldArray[i].isPublic() || !jcFieldArray[i].isStatic() || !jcFieldArray[i].isFinal() || jcFieldArray[i].getEfField() == null) continue;
            JcField jcField = jcFieldArray[i];
            EfAttribute efAttribute = jcFieldArray[i].getEfField().getAttribute();
            int[] nArray = jcFieldArray[i].getValue();
            if (nArray.length == 0 || !(efAttribute instanceof EfConstantValueAttribute)) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.18", objectArray);
                throw new ConversionException();
            }
            if (efAttribute == null) {
                Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.19", objectArray);
                throw new ConversionException();
            }
            if (nArray[0] == ((EfConstantValueAttribute)efAttribute).getValue()) continue;
            Object[] objectArray = new Object[]{jcField.getFieldName(), this.getJcClass().getClassName().replace('/', '.'), "" + ((EfConstantValueAttribute)efAttribute).getValue(), "" + nArray[0]};
            Notifier.error("binary.20", objectArray);
            throw new ConversionException();
        }
    }

    protected void detectRemovedPublicSuperinterfaces() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> vector = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        Vector<String> vector2 = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces()));
        if (vector2.containsAll(vector)) {
            return;
        }
        vector.removeAll(vector2);
        if (!vector.isEmpty()) {
            Object[] objectArray = new Object[]{vector.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.21", objectArray);
            throw new ConversionException();
        }
    }

    protected void detectAddedPublicSuperinterfaces() throws Exception {
        Vector<String> vector;
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> vector2 = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        if (vector2.containsAll(vector = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces())))) {
            return;
        }
        vector.removeAll(vector2);
        if (!vector.isEmpty()) {
            Object[] objectArray = new Object[]{vector.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.37", objectArray);
            throw new ConversionException();
        }
    }
}

