/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassFieldsTable;
import com.sun.javacard.components.caputils.ClassMemberInfo;
import com.sun.javacard.components.caputils.ClassMethodTable;
import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassFile {
    public static final short CL_FLAG_ACC_PUBLIC = 1;
    public static final short CL_FLAG_ACC_FINAL = 16;
    public static final short CL_FLAG_ACC_SUPER = 32;
    public static final short CL_FLAG_ACC_INTERFACE = 512;
    public static final short CL_FLAG_ACC_ABSTRACT = 1024;
    public static final byte[] MAGIC = new byte[]{-54, -2, -70, -66};
    public static final short minorVersion = 0;
    public static final short majorVersion = 50;
    public static final short attributeCount = 0;
    private ClassConstantPool constantPool;
    public short accessFlags;
    private short thisClass;
    private short superClass;
    short interfaceCount;
    short[] interfaces;
    ClassFieldsTable classFields;
    ClassMethodTable classMethods;
    private int cpEntryCount = 0;
    private int interfaceEntryCount = 0;
    private int fieldEntryCount = 0;
    private int methodEntryCount = 0;
    private int attributeEntryCount = 0;
    String className;

    public void setClassName(String string) {
        this.className = string;
    }

    public void setThisClass(short s) {
        this.thisClass = s;
    }

    public void setSuperClass(short s) {
        this.superClass = s;
    }

    public void setAccessFlags(int n) {
        short s = 0;
        if ((n & 1) == 1) {
            s = (short)(s | 1);
        }
        if ((n & 0x10) == 16) {
            s = (short)(s | 0x10);
        }
        if ((n & 0x40) == 64) {
            s = (short)(s | 0x200);
        }
        if ((n & 0x80) == 128) {
            s = (short)(s | 0x400);
        }
        if ((n & 0x40) != 64) {
            s = (short)(s | 0x20);
        }
        this.accessFlags = s;
    }

    public void setConstantPool(ClassConstantPool classConstantPool) {
        this.constantPool = classConstantPool;
    }

    public void setInterfaceCount(short s) {
        this.interfaceCount = s;
        this.interfaces = new short[this.interfaceCount];
    }

    public void setInterfaceEntry(short s) {
        this.interfaces[this.interfaceEntryCount++] = s;
    }

    public void setMethodTable(ClassMethodTable classMethodTable) {
        this.classMethods = classMethodTable;
    }

    public void setFieldTable(ClassFieldsTable classFieldsTable) {
        this.classFields = classFieldsTable;
    }

    public void write(OutputStream outputStream) {
        ClassMemberInfo classMemberInfo;
        Object object;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(MAGIC, 0, MAGIC.length);
        byteArrayOutputStream.write(Util.getShortBytes((short)0), 0, 2);
        byteArrayOutputStream.write(Util.getShortBytes((short)50), 0, 2);
        short s = this.constantPool.getConstantPoolEntryCount();
        s = (short)(s + 1);
        byte[] byArray = Util.getShortBytes(s);
        byteArrayOutputStream.write(byArray, 0, 2);
        for (n = 1; n <= s - 1; ++n) {
            object = this.constantPool.getConstantPoolEntryAt(n);
            ((CPInfo)object).write(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(Util.getShortBytes(this.accessFlags), 0, 2);
        byteArrayOutputStream.write(Util.getShortBytes(this.thisClass), 0, 2);
        byteArrayOutputStream.write(Util.getShortBytes(this.superClass), 0, 2);
        byteArrayOutputStream.write(Util.getShortBytes(this.interfaceCount), 0, 2);
        for (n = 0; n < this.interfaceCount; ++n) {
            byteArrayOutputStream.write(Util.getShortBytes(this.interfaces[n]), 0, 2);
        }
        n = this.classFields.getFieldCount();
        byteArrayOutputStream.write(Util.getShortBytes((short)n), 0, 2);
        object = this.classFields.getClassFields();
        while (object.hasMoreElements()) {
            ClassMemberInfo classMemberInfo2 = (ClassMemberInfo)object.nextElement();
            classMemberInfo2.write(byteArrayOutputStream);
        }
        short s2 = this.classMethods.getMethodCount();
        byteArrayOutputStream.write(Util.getShortBytes(s2), 0, 2);
        object = this.classMethods.getClassMethods();
        while (object.hasMoreElements()) {
            classMemberInfo = (ClassMemberInfo)object.nextElement();
            classMemberInfo.write(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(Util.getShortBytes((short)0), 0, 2);
        classMemberInfo = new ClassReader(byteArrayOutputStream.toByteArray());
        ClassWriter classWriter = new ClassWriter(2);
        classMemberInfo.accept((ClassVisitor)classWriter, 0);
        byte[] byArray2 = classWriter.toByteArray();
        try {
            outputStream.write(byArray2);
            byteArrayOutputStream.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void print() {
        Object object;
        short s;
        Util.printArray("Magic: ", MAGIC, MAGIC.length);
        Util.printArray("Minor Version: ", Util.getShortBytes((short)0), 2);
        Util.printArray("Major Version: ", Util.getShortBytes((short)50), 2);
        short s2 = this.constantPool.getConstantPoolEntryCount();
        byte[] byArray = Util.getShortBytes(s2);
        Util.printArray("Constant Pool Count (" + s2 + "): ", byArray, 2);
        System.out.println("************* CONSTANT POOL ENTRIES *************");
        for (s = 1; s <= s2; ++s) {
            System.out.println("Constant Pool Entry Number: " + Integer.toHexString(s));
            object = this.constantPool.getConstantPoolEntryAt(s);
            ((CPInfo)object).print();
        }
        System.out.println("********* END OF CONSTANT POOL ENTRIES *********");
        Util.printArray("Access flags: ", Util.getShortBytes(this.accessFlags), 2);
        Util.printArray("this_class: ", Util.getShortBytes(this.thisClass), 2);
        Util.printArray("super_class: ", Util.getShortBytes(this.superClass), 2);
        Util.printArray("Interface Count (" + this.interfaceCount + "): ", Util.getShortBytes(this.interfaceCount), 2);
        for (s = 0; s < this.interfaceCount; ++s) {
            Util.printArray("Interface Number " + s + ": ", Util.getShortBytes(this.interfaces[s]), 2);
        }
        System.out.println("********* FIELD INFOs *********");
        s = this.classFields.getFieldCount();
        Util.printArray("Field Count (" + s + "): ", Util.getShortBytes(s), 2);
        object = this.classFields.getClassFields();
        int n = 0;
        while (object.hasMoreElements()) {
            ClassMemberInfo classMemberInfo = (ClassMemberInfo)object.nextElement();
            classMemberInfo.print(n++, "Field");
        }
        System.out.println("********* END FIELD INFOs *********");
        short s3 = this.classMethods.getMethodCount();
        System.out.println("********* METHOD INFOs *********");
        Util.printArray("Method Count (" + s3 + "): ", Util.getShortBytes(s3), 2);
        object = this.classMethods.getClassMethods();
        n = 0;
        while (object.hasMoreElements()) {
            ClassMemberInfo classMemberInfo = (ClassMemberInfo)object.nextElement();
            classMemberInfo.print(n++, "Method");
        }
        System.out.println("********* END METHOD INFOs *********");
        System.out.println("********* Attribute INFO *********");
        Util.printArray("Attribute Count (0): ", Util.getShortBytes((short)0), 2);
        System.out.println("********* END Attribute INFO *********");
    }
}

