/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.groovy.support.debug.Context;
import org.netbeans.modules.groovy.support.debug.GroovyLineBreakpoint;

public class GroovyBreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(string.equals("condition") || string.equals("url") || string.equals("lineNumber") || string.equals("enabled"))) {
            return;
        }
        GroovyLineBreakpoint groovyLineBreakpoint = (GroovyLineBreakpoint)((Object)propertyChangeEvent.getSource());
        this.annotate(groovyLineBreakpoint);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof GroovyLineBreakpoint) {
            ((GroovyLineBreakpoint)breakpoint).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((GroovyLineBreakpoint)breakpoint);
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof GroovyLineBreakpoint) {
            ((GroovyLineBreakpoint)breakpoint).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((GroovyLineBreakpoint)breakpoint);
        }
    }

    public GroovyLineBreakpoint findBreakpoint(String string, int n) {
        for (GroovyLineBreakpoint groovyLineBreakpoint : this.breakpointToAnnotation.keySet()) {
            Object v;
            int n2;
            if (!groovyLineBreakpoint.getURL().equals(string) || (n2 = Context.getLineNumber(v = this.breakpointToAnnotation.get((Object)groovyLineBreakpoint), null)) != n) continue;
            return groovyLineBreakpoint;
        }
        return null;
    }

    private void annotate(GroovyLineBreakpoint groovyLineBreakpoint) {
        Object object = this.breakpointToAnnotation.get((Object)groovyLineBreakpoint);
        if (object != null) {
            Context.removeAnnotation(object);
        }
        if (groovyLineBreakpoint.isHidden()) {
            return;
        }
        object = Context.annotate(groovyLineBreakpoint);
        if (object == null) {
            return;
        }
        this.breakpointToAnnotation.put(groovyLineBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, JPDADebugger.class);
        }
        this.update(groovyLineBreakpoint, object2);
    }

    public void updateGroovyLineBreakpoints() {
        for (GroovyLineBreakpoint groovyLineBreakpoint : this.breakpointToAnnotation.keySet()) {
            this.update(groovyLineBreakpoint, null);
        }
    }

    private void update(GroovyLineBreakpoint groovyLineBreakpoint, Object object) {
        Object v = this.breakpointToAnnotation.get((Object)groovyLineBreakpoint);
        if (v == null) {
            return;
        }
        int n = Context.getLineNumber(v, object);
        this.listen = false;
        groovyLineBreakpoint.setLineNumber(n);
        this.listen = true;
    }

    private void removeAnnotation(GroovyLineBreakpoint groovyLineBreakpoint) {
        Object v = this.breakpointToAnnotation.remove((Object)groovyLineBreakpoint);
        if (v != null) {
            Context.removeAnnotation(v);
        }
    }
}

