/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorBoxViewChildren;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public abstract class EditorBoxView<V extends EditorView>
extends EditorView
implements EditorView.Parent {
    private static final Logger LOG = Logger.getLogger(EditorBoxView.class.getName());
    private double majorAxisSpan;
    private float minorAxisSpan;
    EditorBoxViewChildren<V> children;

    public EditorBoxView(Element elem) {
        super(elem);
    }

    public abstract int getMajorAxis();

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == this.getMajorAxis()) {
            return (float)this.getMajorAxisSpan();
        }
        return this.getMinorAxisSpan();
    }

    public double getMajorAxisSpan() {
        return this.majorAxisSpan;
    }

    protected void setMajorAxisSpan(double majorAxisSpan) {
        this.majorAxisSpan = majorAxisSpan;
    }

    public float getMinorAxisSpan() {
        return this.minorAxisSpan;
    }

    protected void setMinorAxisSpan(float minorAxisSpan) {
        this.minorAxisSpan = minorAxisSpan;
    }

    protected TabExpander getTabExpander() {
        View parent = this.getParent();
        return parent instanceof EditorBoxView ? ((EditorBoxView)parent).getTabExpander() : null;
    }

    @Override
    public final int getViewCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public final View getView(int index) {
        return this.children != null ? (EditorView)this.children.get(index) : null;
    }

    public final V getEditorView(int index) {
        return (V)((EditorView)this.children.get(index));
    }

    final double getViewVisualOffset(int index) {
        this.checkChildrenNotNull();
        return this.children.getViewVisualOffset(this, index);
    }

    final double getViewVisualOffset(V view) {
        this.checkChildrenNotNull();
        return this.children.getViewVisualOffset(((EditorView)view).getRawVisualOffset());
    }

    final double getViewMajorAxisSpan(int index) {
        this.checkChildrenNotNull();
        return this.children.getViewMajorAxisSpan(this, index);
    }

    protected EditorBoxViewChildren<V> createChildren(int capacity) {
        return new EditorBoxViewChildren(capacity);
    }

    protected void releaseChildren(boolean resetSpans) {
        this.children = null;
        if (resetSpans) {
            this.setMajorAxisSpan(0.0);
            this.setMinorAxisSpan(0.0f);
        }
    }

    @Override
    public void replace(int index, int length, View[] views) {
        this.replace(index, length, views, 0, null);
    }

    protected void initChildren(int startIndex, int endIndex) {
        throw new IllegalStateException("Not expected to have child views with null children");
    }

    public ReplaceResult replace(int index, int length, View[] views, int offsetDelta, Shape alloc) {
        if (this.children == null) {
            assert (length == 0) : "Attempt to remove from null children length=" + length;
            this.children = this.createChildren(views.length);
        }
        return this.children.replace(this, new ReplaceResult(), index, length, views, offsetDelta, alloc);
    }

    @Override
    public void preferenceChanged(View childView, boolean width, boolean height) {
        if (childView == null) {
            View parent = this.getParent();
            if (parent != null) {
                parent.preferenceChanged(this, width, height);
            }
        } else {
            this.preferenceChanged(this.getViewIndex(childView), width, height, true);
        }
    }

    public void preferenceChanged(int childViewIndex, boolean width, boolean height, boolean forwardToParent) {
        View parent;
        boolean minorSpanChange;
        boolean majorSpanChange;
        if (!width && !height) {
            return;
        }
        View childView = this.getView(childViewIndex);
        int majorAxis = this.getMajorAxis();
        if (majorAxis == 0) {
            majorSpanChange = width;
            minorSpanChange = height;
        } else {
            majorSpanChange = height;
            minorSpanChange = width;
        }
        if (majorSpanChange) {
            float newSpan;
            double origSpan = this.getViewMajorAxisSpan(childViewIndex);
            if (this.children.handleTabableViews() && childView instanceof TabableView) {
                float visualOffset = (float)this.getViewVisualOffset(childViewIndex);
                newSpan = ((TabableView)((Object)childView)).getTabbedSpan(visualOffset, this.getTabExpander());
            } else {
                newSpan = childView.getPreferredSpan(majorAxis);
            }
            double delta = (double)newSpan - origSpan;
            if (delta != 0.0) {
                this.children.fixOffsetsAndMajorSpan(this, childViewIndex + 1, 0, delta);
            } else {
                majorSpanChange = false;
            }
        }
        if (minorSpanChange) {
            int minorAxis = ViewUtils.getOtherAxis(majorAxis);
            float newSpan = childView.getPreferredSpan(minorAxis);
            if (newSpan > this.minorAxisSpan) {
                this.setMinorAxisSpan(newSpan);
            } else {
                minorSpanChange = false;
            }
        }
        if (forwardToParent && (majorSpanChange || minorSpanChange) && (parent = this.getParent()) != null) {
            if (majorAxis == 0) {
                parent.preferenceChanged(this, majorSpanChange, minorSpanChange);
            } else {
                parent.preferenceChanged(this, minorSpanChange, majorSpanChange);
            }
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape alloc) {
        this.checkChildrenNotNull();
        return this.children.getChildAllocation(this, index, index + 1, alloc);
    }

    public Shape getChildAllocation(int startIndex, int endIndex, Shape alloc) {
        this.checkChildrenNotNull();
        return this.children.getChildAllocation(this, startIndex, endIndex, alloc);
    }

    @Override
    public int getViewIndex(int offset, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            --offset;
        }
        return this.getViewIndex(offset);
    }

    public int getViewIndex(int offset) {
        return this.children != null ? this.children.getViewIndex(offset) : -1;
    }

    public int getViewIndex(View childView) {
        this.checkChildrenNotNull();
        int index = this.children.getViewIndex(childView.getStartOffset());
        assert (this.getEditorView(index) == childView);
        return index;
    }

    public int getViewIndexFirst(int offset) {
        this.checkChildrenNotNull();
        return this.children.getViewIndexFirst(offset);
    }

    @Override
    public int getViewIndexChecked(double x, double y, Shape alloc) {
        this.checkChildrenNotNull();
        return this.children.getViewIndexAtPoint(this, x, y, alloc);
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        this.checkChildrenNotNull();
        return this.children.modelToViewChecked(this, offset, alloc, bias);
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        this.checkChildrenNotNull();
        return this.children.viewToModelChecked(this, x, y, alloc, biasReturn);
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int retValue;
        boolean topOrLeft;
        int viewCount = this.getViewCount();
        if (viewCount == 0) {
            return offset;
        }
        boolean bl = topOrLeft = direction == 1 || direction == 7;
        if (offset == -1) {
            Shape childAlloc;
            int childIndex = topOrLeft ? viewCount - 1 : 0;
            V child = this.getEditorView(childIndex);
            retValue = ((EditorView)child).getNextVisualPositionFromChecked(offset, bias, childAlloc = this.getChildAllocation(childIndex, alloc), direction, biasRet);
            if (retValue == -1 && !topOrLeft && viewCount > 1) {
                child = this.getEditorView(1);
                childAlloc = this.getChildAllocation(1, alloc);
                retValue = ((EditorView)child).getNextVisualPositionFromChecked(-1, biasRet[0], alloc, direction, biasRet);
            }
        } else {
            Shape childAlloc;
            int increment = topOrLeft ? -1 : 1;
            int childIndex = bias == Position.Bias.Backward && offset > 0 ? this.getViewIndex(offset - 1, Position.Bias.Forward) : this.getViewIndex(offset, Position.Bias.Forward);
            V child = this.getEditorView(childIndex);
            retValue = ((EditorView)child).getNextVisualPositionFromChecked(offset, bias, childAlloc = this.getChildAllocation(childIndex, alloc), direction, biasRet);
            if (retValue == -1 && (childIndex += increment) >= 0 && childIndex < viewCount) {
                child = this.getEditorView(childIndex);
                retValue = ((EditorView)child).getNextVisualPositionFromChecked(-1, bias, childAlloc = this.getChildAllocation(childIndex, alloc), direction, biasRet);
                if (retValue == offset && biasRet[0] != bias) {
                    return this.getNextVisualPositionFromChecked(offset, biasRet[0], alloc, direction, biasRet);
                }
            } else if (retValue != -1 && biasRet[0] != bias && (increment == 1 && ((View)child).getEndOffset() == retValue || increment == -1 && ((View)child).getStartOffset() == retValue) && childIndex >= 0 && childIndex < viewCount) {
                child = this.getEditorView(childIndex);
                childAlloc = this.getChildAllocation(childIndex, alloc);
                Position.Bias originalBias = biasRet[0];
                int nextOffset = ((EditorView)child).getNextVisualPositionFromChecked(-1, bias, childAlloc, direction, biasRet);
                if (biasRet[0] == bias) {
                    retValue = nextOffset;
                } else {
                    biasRet[0] = originalBias;
                }
            }
        }
        return retValue;
    }

    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        this.checkChildrenNotNull();
        this.children.paint(this, g, alloc, clipBounds);
    }

    @Override
    public int getViewOffset(int rawOffset) {
        return this.getStartOffset() + this.children.raw2RelOffset(rawOffset);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getFontRenderContext() : null;
    }

    @Override
    public void insertUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    final void fixSpans(int index, int offsetDelta, double visualDelta) {
        this.checkChildrenNotNull();
        this.children.fixOffsetsAndMajorSpan(this, index, offsetDelta, visualDelta);
    }

    private void checkChildrenNotNull() {
        if (this.children == null) {
            throw new IllegalStateException("Null children in " + this.getDumpId());
        }
    }

    @Override
    protected String getDumpName() {
        return "EBV";
    }

    @Override
    public String findIntegrityError() {
        if (this.children != null) {
            if (this.children.size() == 0) {
                return "children.size()==0";
            }
            if (this.children.rawOffsetUpdate()) {
                int viewCount = this.getViewCount();
                double lastVisualOffset = 0.0;
                for (int i = 0; i < viewCount; ++i) {
                    V child = this.getEditorView(i);
                    double childVisualOffset = this.getViewVisualOffset(child);
                    String err = null;
                    if (childVisualOffset < 0.0) {
                        err = "childVisualOffset=" + childVisualOffset + " < 0";
                    } else if (childVisualOffset < lastVisualOffset) {
                        err = "childVisualOffset=" + childVisualOffset + " < lastVisualOffset=" + lastVisualOffset;
                    }
                    if (err != null) {
                        return this.getDumpId() + "[" + i + "]=" + ((EditorView)child).getDumpId() + ": " + err + '\n';
                    }
                    lastVisualOffset = childVisualOffset;
                }
            }
        }
        return null;
    }

    @Override
    protected StringBuilder appendViewInfo(StringBuilder sb, int indent, int importantChildIndex) {
        this.appendViewInfoCore(sb, indent, importantChildIndex);
        if (this.children != null) {
            this.children.appendChildrenInfo(this, sb, indent + 4, importantChildIndex);
        } else {
            sb.append(", children=null");
        }
        return sb;
    }

    protected StringBuilder appendViewInfoCore(StringBuilder sb, int indent, int importantChildIndex) {
        super.appendViewInfo(sb, indent, importantChildIndex);
        sb.append(", WxH:");
        if (this.getMajorAxis() == 0) {
            sb.append(this.getMajorAxisSpan()).append('x').append(this.getMinorAxisSpan());
        } else {
            sb.append(this.getMinorAxisSpan()).append('x').append(this.getMajorAxisSpan());
        }
        return sb;
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }

    public String toStringDetail() {
        return this.appendViewInfo(new StringBuilder(200), 0, -2).toString();
    }

    public static final class ReplaceResult {
        Rectangle repaintBounds;
        boolean widthChanged;
        boolean heightChanged;

        public Rectangle getRepaintBounds() {
            return this.repaintBounds;
        }

        public boolean isPreferenceChanged() {
            return this.widthChanged || this.heightChanged;
        }

        public boolean isWidthChanged() {
            return this.widthChanged;
        }

        public boolean isHeightChanged() {
            return this.heightChanged;
        }
    }
}

