/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;

public class RfsSetupProvider
implements SetupProvider {
    public static final String POSTFIX_64 = "_64";
    private Map<String, String> binarySetupMap;
    private static final String CONTROLLER = "rfs_controller";
    private static final String PRELOAD = "rfs_preload.so";

    public RfsSetupProvider() {
        String[] dirs = new String[]{"SunOS-x86", "SunOS-x86_64", "Linux-x86", "Linux-x86_64", "SunOS-sparc", "SunOS-sparc_64"};
        this.binarySetupMap = new HashMap<String, String>();
        for (String dir : dirs) {
            this.binarySetupMap.put(dir + "/" + PRELOAD, "bin/" + dir + "/" + PRELOAD);
            this.binarySetupMap.put(dir + "/" + CONTROLLER, "bin/" + dir + "/" + CONTROLLER);
        }
    }

    public Map<String, String> getBinaryFiles(ExecutionEnvironment env) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Boolean applicable = RfsSetupProvider.isApplicable(env);
        if (applicable == null) {
            RemoteUtil.LOGGER.log(Level.WARNING, "Can not determine whether RFS is applicable for {0}", env.getDisplayName());
            return result;
        }
        if (!applicable.booleanValue()) {
            RemoteUtil.LOGGER.log(Level.WARNING, "RFS not applicable for {0}", env.getDisplayName());
            return result;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            String osName = RfsSetupProvider.getOsName(env);
            String dir32 = osName + '/';
            String dir64 = RfsSetupProvider.getOsName(env) + POSTFIX_64 + '/';
            for (Map.Entry<String, String> entry : this.binarySetupMap.entrySet()) {
                boolean add = false;
                if (entry.getKey().startsWith(dir32)) {
                    add = true;
                } else if (entry.getKey().startsWith(dir64)) {
                    boolean bl = add = hostInfo.getOS().getBitness() == HostInfo.Bitness._64;
                }
                if (!add) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (InterruptedIOException ex) {
        }
        catch (CancellationException ex) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public static String getPreloadName(ExecutionEnvironment execEnv) {
        return PRELOAD;
    }

    public static String getControllerPath(ExecutionEnvironment execEnv) throws ParseException, CancellationException, IOException {
        String result = RfsSetupProvider.getLibDir(execEnv);
        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
        if (hostInfo.getOS().getBitness() == HostInfo.Bitness._64) {
            result = result + POSTFIX_64;
        }
        result = result + "/rfs_controller";
        return result;
    }

    public static Boolean isApplicable(ExecutionEnvironment env) {
        RemoteServerRecord record;
        if (env == null) {
            throw new NullPointerException();
        }
        HostInfo.OSFamily osFamily = null;
        HostInfo.CpuFamily cpuFamily = null;
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                osFamily = hostInfo.getOSFamily();
                cpuFamily = hostInfo.getCpuFamily();
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "Exception when getting host info:", ex);
            }
            catch (CancellationException ex) {
                // empty catch block
            }
        }
        if ((osFamily == null || cpuFamily == null) && (record = RemoteServerList.getInstance().get(env, false)) != null) {
            osFamily = record.getOsFamily();
            cpuFamily = record.getCpuFamily();
        }
        if (osFamily == null || cpuFamily == null) {
            RemoteUtil.LOGGER.log(Level.WARNING, "RFS: can not determine host OS and CPU for {0}", env.getDisplayName());
            return null;
        }
        switch (osFamily) {
            case LINUX: {
                return cpuFamily == HostInfo.CpuFamily.X86 ? Boolean.TRUE : Boolean.FALSE;
            }
            case SUNOS: {
                return cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    public static String getLdLibraryPath(ExecutionEnvironment execEnv) throws ParseException {
        String libDir = RfsSetupProvider.getLibDir(execEnv);
        return libDir + ':' + libDir + POSTFIX_64;
    }

    private static String getLibDir(ExecutionEnvironment execEnv) throws ParseException {
        String libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)execEnv);
        String osname = RfsSetupProvider.getOsName(execEnv);
        return libDir + '/' + osname;
    }

    private static String getOsName(ExecutionEnvironment execEnv) throws ParseException {
        MacroExpanderFactory.MacroExpander mef = MacroExpanderFactory.getExpander((ExecutionEnvironment)execEnv);
        String osname = mef.expandPredefinedMacros("${osname}-${platform}");
        return osname;
    }
}

