/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.text.ParseException;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.setup.MirrorPathProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;

public class RemoteMirrorPathProvider
implements MirrorPathProvider {
    private static final String POSTFIX = System.getProperty("cnd.remote.sync.root.postfix");

    @Override
    public String getLocalMirror(ExecutionEnvironment executionEnvironment) {
        return CndUtils.getIncludeFilePrefix((String)EnvUtils.toHostID((ExecutionEnvironment)executionEnvironment));
    }

    @Override
    public String getRemoteMirror(ExecutionEnvironment executionEnvironment) {
        String root = System.getProperty("cnd.remote.sync.root." + executionEnvironment.getHost());
        if (root != null) {
            return root;
        }
        root = System.getProperty("cnd.remote.sync.root");
        if (root != null) {
            return root;
        }
        String home = RemoteUtil.getHomeDirectory(executionEnvironment);
        if (home == null) {
            return null;
        }
        ExecutionEnvironment local = ExecutionEnvironmentFactory.getLocal();
        MacroExpanderFactory.MacroExpander expander = MacroExpanderFactory.getExpander((ExecutionEnvironment)local);
        String localHostID = local.getHost();
        try {
            localHostID = expander.expandPredefinedMacros("${hostname}-${osname}-${platform}${_isa}");
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String result = home + "/.netbeans/remote/" + localHostID;
        if (POSTFIX != null) {
            result = result + '-' + POSTFIX;
        }
        return result;
    }
}

