/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.ui.actions.ConnectAction;
import org.netbeans.modules.debugger.ui.actions.GestureSubmitter;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.openide.awt.Actions;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;

public class DebugMainProjectAction
implements Action,
Presenter.Toolbar,
PopupMenuListener {
    private static WeakSet<AttachHistorySupport> ahs = null;
    private Action delegate = MainProjectSensitiveActions.mainProjectCommandAction((String)"debug", (String)NbBundle.getMessage(DebugMainProjectAction.class, (String)"LBL_DebugMainProjectAction_Name"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debugProject.png", (boolean)false));
    private AttachHistorySupport attachHistorySupport;

    public DebugMainProjectAction() {
        this.delegate.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugProject.png");
        this.attachHistorySupport = new AttachHistorySupport();
    }

    @Override
    public Object getValue(String arg0) {
        return this.delegate.getValue(arg0);
    }

    @Override
    public void putValue(String arg0, Object arg1) {
        this.delegate.putValue(arg0, arg1);
    }

    @Override
    public void setEnabled(boolean arg0) {
        this.delegate.setEnabled(arg0);
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.delegate.addPropertyChangeListener(arg0);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.delegate.removePropertyChangeListener(arg0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Project p = OpenProjects.getDefault().getMainProject();
        GestureSubmitter.logDebugProject(p);
        this.delegate.actionPerformed(arg0);
    }

    public Component getToolbarPresenter() {
        JPopupMenu menu = new JPopupMenu();
        JButton button = DropDownButtonFactory.createDropDownButton((Icon)new ImageIcon(new BufferedImage(16, 16, 2)), (JPopupMenu)menu);
        final JMenuItem item = new JMenuItem(Actions.cutAmpersand((String)((String)this.delegate.getValue("menuText"))));
        item.setEnabled(this.delegate.isEnabled());
        this.delegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("enabled".equals(propName)) {
                    item.setEnabled((Boolean)evt.getNewValue());
                } else if ("menuText".equals(propName)) {
                    item.setText(Actions.cutAmpersand((String)((String)evt.getNewValue())));
                }
            }
        });
        menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugMainProjectAction.this.actionPerformed(e);
            }
        });
        try {
            FileObject fo = FileUtil.getConfigFile((String)"Actions/Debug/org-netbeans-modules-debugger-ui-actions-ConnectAction.instance");
            DataObject obj = DataObject.find((FileObject)fo);
            InstanceCookie ic = (InstanceCookie)obj.getLookup().lookup(InstanceCookie.class);
            ConnectAction ca = (ConnectAction)ic.instanceCreate();
            JMenuItem item2 = new JMenuItem(Actions.cutAmpersand((String)((String)ca.getValue("Name"))));
            Actions.connect((AbstractButton)item2, (Action)ca);
            menu.add(item2);
        }
        catch (Exception nsee) {
            Exceptions.printStackTrace((Throwable)nsee);
        }
        menu.addPopupMenuListener(this);
        Actions.connect((AbstractButton)button, (Action)this);
        return button;
    }

    static synchronized void attachHistoryChanged() {
        if (ahs == null) {
            return;
        }
        for (AttachHistorySupport support : ahs) {
            support.computeItems();
        }
    }

    private static synchronized void addAttachHistorySupport(AttachHistorySupport support) {
        if (ahs == null) {
            ahs = new WeakSet();
        }
        ahs.add((Object)support);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JPopupMenu menu = (JPopupMenu)e.getSource();
        this.attachHistorySupport.init(menu);
        menu.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    static class AttachHistorySupport
    implements ActionListener {
        private JPopupMenu menu;
        private JMenuItem[] items = new JMenuItem[0];
        private JSeparator separator = new JPopupMenu.Separator();

        AttachHistorySupport() {
        }

        public void init(JPopupMenu menu) {
            this.menu = menu;
            DebugMainProjectAction.addAttachHistorySupport(this);
            this.computeItems();
        }

        public void computeItems() {
            this.menu.remove(this.separator);
            for (int x = 0; x < this.items.length; ++x) {
                this.menu.remove(this.items[x]);
            }
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Integer[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            if (usedSlots.length > 0) {
                this.menu.add(this.separator);
            }
            this.items = new JMenuItem[usedSlots.length];
            for (int x = 0; x < usedSlots.length; ++x) {
                String dispName = props.getProperties("slot_" + usedSlots[x]).getString("display_name", "<???>");
                this.items[x] = new JMenuItem(dispName);
                this.items[x].addActionListener(this);
                this.menu.add(this.items[x]);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            int index = -1;
            for (int x = 0; x < this.items.length; ++x) {
                if (this.items[x] != item) continue;
                index = x;
                break;
            }
            if (index == -1) {
                return;
            }
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Integer[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            String attachTypeName = props.getProperties("slot_" + usedSlots[index]).getString("attach_type", "???");
            List types = DebuggerManager.getDebuggerManager().lookup(null, AttachType.class);
            AttachType attachType = null;
            for (Object t : types) {
                AttachType att = (AttachType)t;
                if (!attachTypeName.equals(att.getTypeDisplayName())) continue;
                attachType = att;
                break;
            }
            if (attachType != null) {
                JComponent customizer = attachType.getCustomizer();
                Controller controller = attachType.getController();
                if (controller == null && customizer instanceof Controller) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("FIXME: JComponent " + customizer + " must not implement Controller interface!"));
                    controller = (Controller)((Object)customizer);
                }
                Method loadMethod = null;
                try {
                    loadMethod = controller.getClass().getMethod("load", Properties.class);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                if (loadMethod == null) {
                    return;
                }
                try {
                    Boolean result = (Boolean)loadMethod.invoke((Object)controller, props.getProperties("slot_" + usedSlots[index]).getProperties("values"));
                    if (!result.booleanValue()) {
                        return;
                    }
                }
                catch (IllegalAccessException ex) {
                }
                catch (IllegalArgumentException ex) {
                }
                catch (InvocationTargetException ex) {
                    // empty catch block
                }
                boolean passed = controller.ok();
                if (passed) {
                    this.makeFirst(index);
                    GestureSubmitter.logAttach(attachTypeName);
                }
                return;
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DebugMainProjectAction.class, (String)"CTL_Attach_Type_Not_Found"));
        }

        private void makeFirst(int index) {
            if (index == 0) {
                return;
            }
            Properties props = Properties.getDefault().getProperties("debugger").getProperties("last_attaches");
            Object[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
            int temp = usedSlots[index];
            for (int x = index; x > 0; --x) {
                usedSlots[x] = usedSlots[x - 1];
            }
            usedSlots[0] = temp;
            props.setArray("used_slots", usedSlots);
            DebugMainProjectAction.attachHistoryChanged();
        }
    }
}

