/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.hibernate.refactoring.MoveMappingFilePanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class MoveMappingFilesRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private MoveRefactoring refactoring;
    private FileObject[] mappingFileObjects;
    private MovePanel panel;
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    public MoveMappingFilesRefactoringUI(FileObject[] fileObjectArray, FileObject fileObject, PasteType pasteType) {
        this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])fileObjectArray));
        this.disable = fileObject != null;
        this.targetFolder = fileObject;
        this.mappingFileObjects = fileObjectArray;
        this.pasteType = pasteType;
    }

    public String getName() {
        return NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"LBL_Move");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string;
            String string2 = null;
            if (this.targetFolder != null && (string = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                string2 = string.getResourceName(this.targetFolder, '.', false);
            }
            string = NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"DSC_MoveMappingFiles");
            if (this.mappingFileObjects.length == 1) {
                string = NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"DSC_MoveOneMappingFile", (Object)this.mappingFileObjects[0].getName());
            }
            this.panel = new MovePanel(changeListener, string2 != null ? string2 : MoveMappingFilesRefactoringUI.getDOPackageName(this.mappingFileObjects[0].getParent()), string);
        }
        return this.panel;
    }

    private static String getDOPackageName(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return fileObject.getName();
    }

    public boolean hasParameters() {
        return true;
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    private Problem setParameters(boolean bl) {
        if (this.panel == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(uRL.toExternalForm() + URLEncoder.encode(this.panel.getPackageName().replace('.', '/'), "utf-8"))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
        }
        if (bl) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveMappingFilesRefactoringUI.class);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    private final Vector getNodes() {
        Vector<Node> vector = new Vector<Node>(this.mappingFileObjects.length);
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>(Arrays.asList(this.mappingFileObjects));
        while (!linkedList.isEmpty()) {
            FileObject fileObject = linkedList.removeFirst();
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            if (dataObject instanceof DataFolder) {
                for (DataObject dataObject2 : ((DataFolder)dataObject).getChildren()) {
                    linkedList.addLast(dataObject2.getPrimaryFile());
                }
                continue;
            }
            vector.add(dataObject.getNodeDelegate());
        }
        return vector;
    }

    class MovePanel
    extends MoveMappingFilePanel {
        public MovePanel(ChangeListener changeListener, String string, String string2) {
            super(changeListener, string, string2, MoveMappingFilesRefactoringUI.this.targetFolder != null ? MoveMappingFilesRefactoringUI.this.targetFolder : MoveMappingFilesRefactoringUI.this.mappingFileObjects[0]);
            if (MoveMappingFilesRefactoringUI.this.mappingFileObjects.length > 1) {
                this.setCombosEnabled(!MoveMappingFilesRefactoringUI.this.disable);
                JList jList = new JList(MoveMappingFilesRefactoringUI.this.getNodes());
                jList.setCellRenderer(new NodeRenderer());
                jList.setVisibleRowCount(5);
                JScrollPane jScrollPane = new JScrollPane(jList);
                this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
                this.bottomPanel.setLayout(new BorderLayout());
                this.bottomPanel.add((Component)jScrollPane, "Center");
                JLabel jLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(MovePanel.class, (String)"LBL_ListOfMappingFiles"));
                this.bottomPanel.add((Component)jLabel, "North");
            }
        }
    }
}

