/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.xml.tax.beans.editor.NullStringCustomEditor;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class NullStringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    protected static final String DEFAULT_NULL = Util.THIS.getString("TEXT_DEFAULT");
    private boolean editable = true;

    public void setAsText(String text) throws IllegalArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("NullStringEditor::setAsText: text = " + text);
        }
        if (DEFAULT_NULL.equals(text)) {
            this.setValue(null);
        } else if (text.length() == 0) {
            this.setValue(null);
        } else {
            this.setValue(text);
        }
    }

    public String getAsText() {
        Object value = super.getValue();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("NullStringEditor::getAsText: value = " + value);
        }
        if (value == null) {
            return DEFAULT_NULL;
        }
        String text = value.toString();
        if (text.length() == 0) {
            return DEFAULT_NULL;
        }
        return text;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new NullStringCustomEditor(this);
    }

    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        return "\"" + NullStringEditor.toAscii(s) + "\"";
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
        }
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean supportsEditingTaggedValues() {
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private static String toAscii(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 6);
        char[] chars = str.toCharArray();
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }
}

