/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNotationDecl;

public class TreeNotationDeclCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 844910700645886601L;
    private JLabel nameLabel;
    private JLabel publicLabel;
    private JTextField nameField;
    private JTextField publicField;
    private JLabel systemLabel;
    private JTextField systemField;
    private JPanel fillPanel;

    public TreeNotationDeclCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_dtdNotationName"));
        this.publicLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_dtdNotationPublicId"));
        this.systemLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_dtdNotationSystemId"));
        this.initAccessibility();
    }

    protected final TreeNotationDecl getNotationDecl() {
        return (TreeNotationDecl)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("name")) {
            this.updateNameComponent();
        } else if (pche.getPropertyName().equals("publicId")) {
            this.updatePublicIdComponent();
        } else if (pche.getPropertyName().equals("systemId")) {
            this.updateSystemIdComponent();
        }
    }

    protected final void updateNotationDeclName() {
        try {
            this.getNotationDecl().setName(this.nameField.getText());
        }
        catch (TreeException exc) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getNotationDecl().getName());
    }

    protected final void updateNotationDeclPublicId() {
        try {
            this.getNotationDecl().setPublicId(TreeNotationDeclCustomizer.text2null(this.publicField.getText()));
        }
        catch (TreeException exc) {
            this.updatePublicIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updatePublicIdComponent() {
        this.publicField.setText(TreeNotationDeclCustomizer.null2text(this.getNotationDecl().getPublicId()));
    }

    protected final void updateNotationDeclSystemId() {
        try {
            this.getNotationDecl().setSystemId(TreeNotationDeclCustomizer.text2null(this.systemField.getText()));
        }
        catch (TreeException exc) {
            this.updateSystemIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateSystemIdComponent() {
        this.systemField.setText(TreeNotationDeclCustomizer.null2text(this.getNotationDecl().getSystemId()));
    }

    protected final void initComponentValues() {
        this.updateNameComponent();
        this.updatePublicIdComponent();
        this.updateSystemIdComponent();
    }

    protected void updateReadOnlyStatus(boolean editable) {
        this.nameField.setEditable(editable);
        this.systemField.setEditable(editable);
        this.publicField.setEditable(editable);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.publicLabel = new JLabel();
        this.publicField = new JTextField();
        this.systemLabel = new JLabel();
        this.systemField = new JTextField();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(Util.THIS.getString("PROP_dtdNotationName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNotationDeclCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.nameFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.publicLabel.setText(Util.THIS.getString("PROP_dtdNotationPublicId"));
        this.publicLabel.setLabelFor(this.publicField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.publicLabel, gridBagConstraints);
        this.publicField.setColumns(20);
        this.publicField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNotationDeclCustomizer.this.publicFieldActionPerformed(evt);
            }
        });
        this.publicField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.publicFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.publicFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.publicField, gridBagConstraints);
        this.systemLabel.setText(Util.THIS.getString("PROP_dtdNotationSystemId"));
        this.systemLabel.setLabelFor(this.systemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.systemLabel, gridBagConstraints);
        this.systemField.setColumns(20);
        this.systemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNotationDeclCustomizer.this.systemFieldActionPerformed(evt);
            }
        });
        this.systemField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.systemFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeNotationDeclCustomizer.this.systemFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.systemField, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void systemFieldFocusGained(FocusEvent evt) {
        this.systemField.selectAll();
    }

    private void publicFieldFocusGained(FocusEvent evt) {
        this.publicField.selectAll();
    }

    private void nameFieldFocusGained(FocusEvent evt) {
        this.nameField.selectAll();
    }

    private void systemFieldFocusLost(FocusEvent evt) {
        this.updateNotationDeclSystemId();
    }

    private void systemFieldActionPerformed(ActionEvent evt) {
        this.updateNotationDeclSystemId();
    }

    private void publicFieldFocusLost(FocusEvent evt) {
        this.updateNotationDeclPublicId();
    }

    private void publicFieldActionPerformed(ActionEvent evt) {
        this.updateNotationDeclPublicId();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.updateNotationDeclName();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.updateNotationDeclName();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeNotationDeclCustomizer"));
        this.nameField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nameField3"));
        this.nameField.selectAll();
        this.publicField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_publicField2"));
        this.publicField.selectAll();
        this.systemField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_systemField1"));
        this.systemField.selectAll();
    }
}

