/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug;

import freemarker.debug.Debugger;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.MessageDigest;

public class DebuggerClient {
    private DebuggerClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger getDebugger(InetAddress host, int port, String password) throws IOException {
        Debugger debugger;
        Socket s = new Socket(host, port);
        try {
            ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
            ObjectInputStream in = new ObjectInputStream(s.getInputStream());
            int protocolVersion = in.readInt();
            if (protocolVersion > 220) {
                throw new IOException("Incompatible protocol version " + protocolVersion + ". At most 220 was expected.");
            }
            byte[] challenge = (byte[])in.readObject();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(password.getBytes("UTF-8"));
            md.update(challenge);
            out.writeObject(md.digest());
            debugger = (Debugger)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                s.close();
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        s.close();
        return debugger;
    }
}

