/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.security.acl.NotOwnerException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.ObservableAction;
import org.openide.util.NbBundle;

public final class RequestPrivilegesAction
extends ObservableAction<Boolean> {
    private static final ConcurrentHashMap<Key, RequestPrivilegesAction> cache = new ConcurrentHashMap();
    private final SPSCommonImpl support;
    private final Collection<String> requestedPrivileges;

    public static RequestPrivilegesAction getInstance(SPSCommonImpl support, Collection<String> requestedPrivileges) {
        RequestPrivilegesAction oldRef;
        Key key = new Key(support, requestedPrivileges);
        RequestPrivilegesAction result = cache.get(key);
        if (result == null && (oldRef = cache.putIfAbsent(key, result = new RequestPrivilegesAction(support, requestedPrivileges))) != null) {
            result = oldRef;
        }
        return result;
    }

    private RequestPrivilegesAction(SPSCommonImpl support, Collection<String> requestedPrivileges) {
        super(RequestPrivilegesAction.loc("TaskPrivilegesSupport_GrantPrivileges_Action", new String[0]));
        this.support = support;
        this.requestedPrivileges = requestedPrivileges;
    }

    @Override
    public synchronized Boolean performAction() {
        if (this.support.isCanceled()) {
            return Boolean.FALSE;
        }
        try {
            this.support.requestPrivileges(this.requestedPrivileges, true);
        }
        catch (NotOwnerException ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(RequestPrivilegesAction.class, (String)key, (Object[])params);
    }

    private static class Key {
        SolarisPrivilegesSupport support;
        Collection<String> requestedPrivileges;

        public Key(SolarisPrivilegesSupport support, Collection<String> requestedPrivileges) {
            this.support = support;
            this.requestedPrivileges = requestedPrivileges;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                throw new IllegalArgumentException();
            }
            Key k = (Key)obj;
            return k.requestedPrivileges.containsAll(this.requestedPrivileges) && this.requestedPrivileges.containsAll(k.requestedPrivileges) && k.support == this.support;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.support != null ? this.support.hashCode() : 0);
            return hash;
        }
    }
}

