/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.pty;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.PtyOpenUtility;
import org.openide.util.Utilities;

public final class PtyAllocator {
    private static final PtyAllocator instance = new PtyAllocator();

    private PtyAllocator() {
    }

    public static PtyAllocator getInstance() {
        return instance;
    }

    public Pty allocate(ExecutionEnvironment env) throws IOException {
        PtyImplementation result = null;
        OutputStream output = null;
        InputStream input = null;
        InputStream error = null;
        String ptyOpenUtilityPath = PtyOpenUtility.getInstance().getPath(env);
        if (ptyOpenUtilityPath == null) {
            throw new IOException("pty_open cannot be located");
        }
        HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
        if (hostInfo == null) {
            throw new IOException("no hostinfo available for " + env.getDisplayName());
        }
        try {
            if (env.isLocal()) {
                ProcessBuilder pb = new ProcessBuilder(hostInfo.getShell(), "-s");
                if (Utilities.isWindows()) {
                    if (hostInfo.getShell() == null || WindowsSupport.getInstance().getActiveShell().type != Shell.ShellType.CYGWIN) {
                        throw new IOException("terminal support requires Cygwin to be installed");
                    }
                    ptyOpenUtilityPath = WindowsSupport.getInstance().convertToCygwinPath(ptyOpenUtilityPath);
                    String path = MacroMap.forExecEnv(env).get("PATH");
                    pb.environment().put("Path", path);
                }
                Process pty = pb.start();
                output = pty.getOutputStream();
                input = pty.getInputStream();
                error = pty.getErrorStream();
            } else {
                JschSupport.ChannelStreams streams = JschSupport.startCommand(env, "/bin/sh -s", null);
                output = streams.in;
                input = streams.out;
                error = streams.err;
            }
            output.write(("exec \"" + ptyOpenUtilityPath + "\"\n").getBytes());
            output.flush();
            PtyOpenUtility.PtyInfo ptyInfo = PtyOpenUtility.getInstance().readSatelliteOutput(input);
            if (ptyInfo == null) {
                String errorLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(error));
                StringBuilder err_msg = new StringBuilder();
                while ((errorLine = br.readLine()) != null) {
                    err_msg.append(errorLine).append('\n');
                }
                throw new IOException(err_msg.toString());
            }
            result = ptyInfo == null ? null : new PtyImplementation(env, ptyInfo.tty, ptyInfo.pid, input, output);
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
        finally {
            if (result == null) {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
        }
        return result;
    }

    public static final class PtyImplementation
    implements Pty {
        private final String tty;
        private final int pid;
        private final InputStream istream;
        private final OutputStream ostream;
        private final ExecutionEnvironment env;
        private final ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);

        public PtyImplementation(ExecutionEnvironment env, String tty, int pid, InputStream istream, OutputStream ostream) throws IOException {
            this.tty = tty;
            this.pid = pid;
            this.istream = istream;
            this.ostream = ostream;
            this.env = env;
        }

        @Override
        public ExecutionEnvironment getEnv() {
            return this.env;
        }

        @Override
        public final void close() throws IOException {
            this.ostream.close();
            this.istream.close();
        }

        @Override
        public String toString() {
            return this.tty + " (" + this.pid + ")";
        }

        @Override
        public InputStream getInputStream() {
            return this.istream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.ostream;
        }

        @Override
        public InputStream getErrorStream() {
            return this.bis;
        }

        @Override
        public String getSlaveName() {
            return this.tty;
        }
    }
}

