/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.viewmodel.DelegatingCellRenderer;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class DelegatingCellEditor
implements TableCellEditor {
    private String columnID;
    private TableCellEditor defaultEditor;
    private TableCellEditor currentEditor;
    private Reference<TableCellEditor> canceledEditorRef;

    public DelegatingCellEditor(String columnID, TableCellEditor defaultEditor) {
        this.columnID = columnID;
        this.defaultEditor = defaultEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Outline outline = (Outline)table;
        OutlineModel om = (OutlineModel)outline.getModel();
        Node n = DelegatingCellRenderer.getNodeAt(om, row);
        if (n instanceof TreeModelNode) {
            TreeModelNode tmn = (TreeModelNode)n;
            Models.CompoundModel trm = tmn.getModel();
            try {
                TableCellEditor editor;
                if (trm.canEditCell(tmn.getObject(), this.columnID) && (editor = trm.getCellEditor(tmn.getObject(), this.columnID)) != null) {
                    this.currentEditor = editor;
                    return editor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            }
            catch (UnknownTypeException ex) {
                // empty catch block
            }
        }
        this.currentEditor = this.defaultEditor;
        return this.defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        Exceptions.printStackTrace((Throwable)new IllegalStateException("No current editor."));
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (!(anEvent.getSource() instanceof Outline)) {
            return false;
        }
        Outline outline = (Outline)anEvent.getSource();
        if (!(anEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent event = (MouseEvent)anEvent;
        Point p = event.getPoint();
        int row = outline.rowAtPoint(p);
        OutlineModel om = (OutlineModel)outline.getModel();
        Node n = DelegatingCellRenderer.getNodeAt(om, row);
        if (n instanceof TreeModelNode) {
            TreeModelNode tmn = (TreeModelNode)n;
            Models.CompoundModel trm = tmn.getModel();
            try {
                boolean canEdit = trm.canEditCell(tmn.getObject(), this.columnID);
                if (canEdit) {
                    TableCellEditor tce = trm.getCellEditor(tmn.getObject(), this.columnID);
                    canEdit = tce.isCellEditable(event);
                    return canEdit;
                }
            }
            catch (UnknownTypeException ex) {
                // empty catch block
            }
        }
        return this.defaultEditor.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        if (!(anEvent.getSource() instanceof Outline)) {
            return false;
        }
        Outline outline = (Outline)anEvent.getSource();
        if (!(anEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent event = (MouseEvent)anEvent;
        Point p = event.getPoint();
        int row = outline.rowAtPoint(p);
        OutlineModel om = (OutlineModel)outline.getModel();
        Node n = DelegatingCellRenderer.getNodeAt(om, row);
        if (n instanceof TreeModelNode) {
            TreeModelNode tmn = (TreeModelNode)n;
            Models.CompoundModel trm = tmn.getModel();
            try {
                TableCellEditor editor;
                if (trm.canEditCell(tmn.getObject(), this.columnID) && (editor = trm.getCellEditor(tmn.getObject(), this.columnID)) != null) {
                    return editor.shouldSelectCell(anEvent);
                }
            }
            catch (UnknownTypeException ex) {
                // empty catch block
            }
        }
        return this.defaultEditor.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.currentEditor != null) {
            boolean status = this.currentEditor.stopCellEditing();
            this.canceledEditorRef = new WeakReference<TableCellEditor>(this.currentEditor);
            this.currentEditor = null;
            return status;
        }
        Exceptions.printStackTrace((Throwable)new IllegalStateException("No current editor."));
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
            this.canceledEditorRef = new WeakReference<TableCellEditor>(this.currentEditor);
            this.currentEditor = null;
            return;
        }
        Exceptions.printStackTrace((Throwable)new IllegalStateException("No current editor."));
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.currentEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        TableCellEditor editor = this.currentEditor;
        if (editor == null && this.canceledEditorRef != null) {
            editor = this.canceledEditorRef.get();
        }
        if (editor != null) {
            editor.removeCellEditorListener(l);
        }
    }
}

