/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.components.general.ClassCode;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.ResourceEditorPanel;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.FontEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.ImageEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.TickerEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class PropertyEditorResourceLazyInit
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private Map<String, DesignComponent> createdComponents;
    private final TypeID componentTypeID;
    private String noneComponentAsText;
    private String newComponentAsText;
    private ResourceEditorPanel rePanel;
    private JRadioButton radioButton;
    private PropertyEditorResourceElement perElement;
    private DatabindingElement databindingElement;
    private boolean databinding;
    private WeakReference<DesignComponent> component;

    public static final DesignPropertyEditor createFontPropertyEditor() {
        return new PropertyEditorResourceLazyInit(FontCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_UCLABEL"), false){

            @Override
            protected PropertyEditorResourceElement createElement() {
                return new FontEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createTickerPropertyEditor() {
        return new PropertyEditorResourceLazyInit(TickerCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_UCLABEL"), false){

            @Override
            protected PropertyEditorResourceElement createElement() {
                return new TickerEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createImagePropertyEditor() {
        return new PropertyEditorResourceLazyInit(ImageCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), false){

            @Override
            protected PropertyEditorResourceElement createElement() {
                return new ImageEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createImagePropertyEditorWithDatabinding() {
        return new PropertyEditorResourceLazyInit(ImageCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), true){

            @Override
            protected PropertyEditorResourceElement createElement() {
                return new ImageEditorElement();
            }
        };
    }

    public PropertyEditorResourceLazyInit(TypeID type, String newComponentAsText, String noneComponentAsText, String userCodeLabel, boolean databinding) {
        super(userCodeLabel);
        this.databinding = databinding;
        if (newComponentAsText == null || noneComponentAsText == null) {
            throw Debug.illegalArgument((Object[])new Object[]{"Argument can not be null"});
        }
        if (newComponentAsText.equals(noneComponentAsText)) {
            throw Debug.illegalArgument((Object[])new Object[]{"Arguments can not be equal"});
        }
        this.componentTypeID = type;
        this.newComponentAsText = newComponentAsText;
        this.noneComponentAsText = noneComponentAsText;
        this.createdComponents = new HashMap<String, DesignComponent>();
    }

    protected abstract PropertyEditorResourceElement createElement();

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.createdComponents != null) {
            this.createdComponents.clear();
            this.createdComponents = null;
        }
        if (this.rePanel != null) {
            this.rePanel.clean(component);
            this.rePanel = null;
        }
        this.radioButton = null;
        if (this.perElement != null && this.perElement instanceof CleanUp) {
            ((CleanUp)((Object)this.perElement)).clean(component);
            this.perElement = null;
        }
        if (this.databindingElement != null) {
            this.databindingElement.clean(component);
            this.databindingElement = null;
        }
    }

    @Override
    public void setAsText(String text) {
        this.saveValue(text);
    }

    @Override
    public final Component getCustomEditor() {
        if (this.perElement == null) {
            DesignComponent component_ = this.component != null ? (DesignComponent)this.component.get() : null;
            this.perElement = this.createElement();
            this.perElement.setDesignComponent(component_);
            this.perElement.setPropertyEditorMessageAwareness(this);
        }
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton();
            this.rePanel = new ResourceEditorPanel(this.perElement, this.noneComponentAsText, this.radioButton);
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_RB_RESOURCE"));
            this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"ACSN_RB_RESOURCE"));
            this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"ACSD_RB_RESOURCE"));
            this.perElement.addPropertyEditorResourceElementListener(this.rePanel);
            if (this.databinding) {
                ArrayList<PropertyEditorElement> elements = new ArrayList<PropertyEditorElement>(2);
                this.databindingElement = new DatabindingElement(this);
                elements.add(this);
                elements.add(this.databindingElement);
                this.initElements(elements);
            } else {
                this.initElements(Collections.singleton(this));
            }
        }
        Component superCustomEditor = super.getCustomEditor();
        if (this.getValue() instanceof PropertyValue) {
            this.updateState((PropertyValue)this.getValue());
        }
        this.perElement.getCustomEdiotrNotification();
        return superCustomEditor;
    }

    protected Map<String, DesignComponent> getComponentsMap() {
        final TreeMap<String, DesignComponent> componentsMap = new TreeMap<String, DesignComponent>();
        if (this.component == null || this.component.get() == null) {
            return componentsMap;
        }
        final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                Collection components = MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID).getComponents();
                for (DesignComponent comp : components) {
                    if (!comp.getType().equals((Object)PropertyEditorResourceLazyInit.this.componentTypeID)) continue;
                    componentsMap.put(PropertyEditorResourceLazyInit.this.getComponentDisplayName(comp), comp);
                }
            }
        });
        return componentsMap;
    }

    private String getComponentDisplayName(DesignComponent component) {
        if (component == null) {
            return this.noneComponentAsText;
        }
        if (component.getParentComponent() == null && component.getDocument().getRootComponent() != component) {
            return this.noneComponentAsText;
        }
        return MidpValueSupport.getHumanReadableString(component);
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.component == null || this.getPropertyNames() == null) {
            return null;
        }
        String databindingAsText = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (databindingAsText != null) {
            return databindingAsText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return this.getDecodeValue(value);
    }

    private void setValue(PropertyValue value) {
        super.setValue((Object)value);
        if (this.perElement == null) {
            return;
        }
        DesignComponent component_ = (DesignComponent)this.component.get();
        if (!NULL_VALUE.equals(value) && this.perElement.isPostSetValueSupported(component_)) {
            this.perElement.postSetValue(component_, value.getComponent());
        } else if (NULL_VALUE.equals(value)) {
            this.perElement.nullValueSet(component_);
        }
    }

    private void saveValue(String text) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
        Map<String, DesignComponent> componentsMap = this.getComponentsMap();
        if (componentsMap.get(text) != null) {
            this.setValue(PropertyValue.createComponentReference((DesignComponent)componentsMap.get(text)));
        } else if (text.equals(this.noneComponentAsText)) {
            this.setValue(NULL_VALUE);
        } else if (text.equals(this.newComponentAsText)) {
            document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent createdComponent;
                    ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)document, (String)PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                    if (producer == null) {
                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                    }
                    DesignComponent category = MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID);
                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)category, (ComponentProducer)producer, null);
                    DesignComponent designComponent = createdComponent = result != null ? result.getMainComponent() : null;
                    if (createdComponent != null) {
                        PropertyEditorResourceLazyInit.this.initInstanceNameForComponent(createdComponent);
                        PropertyEditorResourceLazyInit.this.setValue(PropertyValue.createComponentReference((DesignComponent)createdComponent));
                    }
                }
            });
        } else {
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> wrappersMap = this.rePanel.getWrappersMap();
            for (String key : wrappersMap.keySet()) {
                if (!key.equals(text)) continue;
                DesignComponent createdComponent = this.createdComponents.get(text);
                this.setValue(PropertyValue.createComponentReference((DesignComponent)createdComponent));
                this.createdComponents.clear();
                break;
            }
        }
    }

    private void initInstanceNameForComponent(DesignComponent component) {
        String nameToBeCreated = ClassCode.getSuggestedMainName(this.componentTypeID);
        PropertyValue instanceName = InstanceNameResolver.createFromSuggested(component, nameToBeCreated);
        component.writeProperty("instanceName", instanceName);
    }

    private String getDecodeValue(final PropertyValue value) {
        if (value == null || value.getKind() == PropertyValue.Kind.NULL) {
            return this.noneComponentAsText;
        }
        if (this.component == null || this.component.get() == null) {
            return this.noneComponentAsText;
        }
        final String[] decodeValue = new String[1];
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent valueComponent = value.getComponent();
                decodeValue[0] = PropertyEditorResourceLazyInit.this.getComponentDisplayName(valueComponent);
            }
        });
        return decodeValue[0] != null ? decodeValue[0] : "n/a";
    }

    @Override
    public void init(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
        if (this.perElement != null) {
            this.perElement.setDesignComponent(component);
        }
        super.init(component);
    }

    public String[] getTags() {
        Set<String> components = this.getComponentsMap().keySet();
        ArrayList<String> tags = new ArrayList<String>(components.size() + 2);
        if (this.isCurrentValueAUserCodeType()) {
            tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            tags.add(this.noneComponentAsText);
            tags.addAll(components);
            tags.add(this.newComponentAsText);
        }
        return tags.toArray(new String[tags.size()]);
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.getRadioButton().isSelected()) {
            this.saveChanges();
            this.saveValue(this.getTextForPropertyValue());
        }
        DesignComponent _component = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(_component);
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(_component);
        }
    }

    public boolean executeInsideWriteTransaction() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return false;
        }
        return super.executeInsideWriteTransaction();
    }

    @Override
    public boolean isExecuteInsideWriteTransactionUsed() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return true;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    @Override
    public String getTextForPropertyValue() {
        return this.rePanel.getTextForPropertyValue();
    }

    private void saveChanges() {
        if (this.rePanel.wasAnyDesignComponentChanged()) {
            Map<String, DesignComponent> componentsMap = this.getComponentsMap();
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> wrappersMap = this.rePanel.getWrappersMap();
            final ArrayList toBeDeleted = new ArrayList();
            for (final String key : wrappersMap.keySet()) {
                final PropertyEditorResourceElement.DesignComponentWrapper wrapper = wrappersMap.get(key);
                if (wrapper.hasChanges()) {
                    final DesignComponent _component = componentsMap.get(key);
                    if (_component != null) {
                        _component.getDocument().getTransactionManager().writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                if (wrapper.getComponent() != null) {
                                    Map<String, PropertyValue> changes = wrapper.getChanges();
                                    for (String propertyName : changes.keySet()) {
                                        PropertyValue propertyValue = changes.get(propertyName);
                                        _component.writeProperty(propertyName, propertyValue);
                                    }
                                } else {
                                    toBeDeleted.add(_component);
                                }
                            }
                        });
                    } else {
                        if (wrapper.isDeleted()) continue;
                        if (this.component != null && this.component.get() != null) {
                            final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
                            document.getTransactionManager().writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    DesignComponent createdComponent;
                                    ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)document, (String)PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                                    if (producer == null) {
                                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                                    }
                                    DesignComponent category = MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID);
                                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)category, (ComponentProducer)producer, null);
                                    DesignComponent designComponent = createdComponent = result != null ? result.getMainComponent() : null;
                                    if (createdComponent != null) {
                                        createdComponent.writeProperty("instanceName", MidpTypes.createStringValue(key));
                                        Map<String, PropertyValue> changes = wrapper.getChanges();
                                        for (String propertyName : changes.keySet()) {
                                            PropertyValue propertyValue = changes.get(propertyName);
                                            createdComponent.writeProperty(propertyName, propertyValue);
                                        }
                                        PropertyEditorResourceLazyInit.this.createdComponents.put(key, createdComponent);
                                    }
                                }
                            });
                        }
                    }
                }
                if (toBeDeleted.isEmpty() || this.component == null || this.component.get() == null) continue;
                final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        DeleteSupport.invokeDirectUserDeletion((DesignDocument)document, (Collection)toBeDeleted, (boolean)false);
                    }
                });
            }
            this.perElement.postSaveValue((DesignComponent)this.component.get());
        }
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.rePanel;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignComponent c = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(c);
        }
        if (this.getPropertyDisplayName() != null && MidpDatabindingSupport.getDatabaindingAsText(c, (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(c);
        } else if (this.rePanel.needsUpdate()) {
            this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
            this.rePanel.update(this.getComponentsMap(), this.getDecodeValue(value));
        }
    }

    public boolean isResetToDefaultAutomatically() {
        if (this.component == null) {
            super.isResetToDefaultAutomatically();
        }
        return this.perElement.isResetToDefaultAutomatically((DesignComponent)this.component.get());
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (this.component != null && this.component.get() != null) {
            this.perElement.preResetToDefaultValue((DesignComponent)this.component.get());
        }
        super.customEditorResetToDefaultButtonPressed();
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }
}

