/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.util.NbBundle;

public class PropertyEditorArrayInteger
extends GroupPropertyEditor
implements ExPropertyEditor {
    private static String ERROR_WARNING = NbBundle.getMessage(PropertyEditorArrayInteger.class, (String)"MSG_ILLEGAL_FORMATING");
    private WeakReference<DesignComponent> component;
    private Object parentTypeID;

    public static DesignPropertyEditor create() {
        return new PropertyEditorArrayInteger();
    }

    public static DesignPropertyEditor create(TypeID parentTypeID) {
        return new PropertyEditorArrayInteger(parentTypeID);
    }

    private PropertyEditorArrayInteger() {
    }

    private PropertyEditorArrayInteger(TypeID parentTypeID) {
        this.parentTypeID = parentTypeID;
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        this.component = null;
        this.parentTypeID = null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public String getAsText() {
        StringBuffer text = new StringBuffer();
        text.append('[');
        GroupValue values = this.getValue();
        Iterator<String> i = Arrays.asList(this.getValue().getPropertyNames()).iterator();
        while (i.hasNext()) {
            PropertyValue value = (PropertyValue)values.getValue(i.next());
            text.append(value.getPrimitiveValue());
            if (!i.hasNext()) continue;
            text.append(',');
        }
        text.append(']');
        return text.toString();
    }

    public void setAsText(String text) {
        String newText = this.decodeValuesFromText(text);
        if (newText == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ERROR_WARNING + ' ' + text)));
        } else {
            GroupValue values = this.getValue();
            Iterator<String> propertyNamesIter = Arrays.asList(values.getPropertyNames()).iterator();
            for (String number : newText.split(",")) {
                values.putValue(propertyNamesIter.next(), (Object)MidpTypes.createIntegerValue(Integer.parseInt(number)));
            }
            this.setValue(values);
        }
    }

    private String decodeValuesFromText(String text) {
        text = text.trim().replaceAll(Pattern.compile("[\\[$\\]]").pattern(), "");
        if (Pattern.compile("[^0123456789,]").matcher(text).find() || text.split(",").length != this.getValue().getPropertyNames().length) {
            return null;
        }
        return text;
    }

    public Boolean canEditAsText() {
        return true;
    }

    public boolean canWrite() {
        if (this.component.get() == null) {
            return super.canWrite();
        }
        final DesignComponent[] isEditable = new DesignComponent[1];
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                isEditable[0] = ((DesignComponent)PropertyEditorArrayInteger.this.component.get()).getParentComponent();
            }
        });
        if (this.parentTypeID != null && isEditable[0] != null && isEditable[0].getType().equals(this.parentTypeID)) {
            return false;
        }
        return super.canWrite();
    }

    public void init(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (!(this.getValue() instanceof GroupValue)) {
            throw new IllegalArgumentException();
        }
        GroupValue currentValue = this.getValue();
        for (String propertyName : currentValue.getPropertyNames()) {
            ((DesignComponent)this.component.get()).writeProperty(propertyName, MidpTypes.createIntegerValue(0));
        }
    }
}

