/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.producers;

import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.java.MidpJavaSupport;
import org.openide.util.NbBundle;

public abstract class CommandProducer
extends ComponentProducer {
    public static final String PRODUCER_ID_BACK_COMMAND = "#BackCommand";
    public static final String PRODUCER_ID_CANCEL_COMMAND = "#CancelCommand";
    public static final String PRODUCER_ID_EXIT_COMMAND = "#ExitCommand";
    public static final String PRODUCER_ID_HELP_COMMAND = "#HelpCommand";
    public static final String PRODUCER_ID_ITEM_COMMAND = "#ItemCommand";
    public static final String PRODUCER_ID_OK_COMMAND = "#OkCommand";
    public static final String PRODUCER_ID_SCREEN_COMMAND = "#ScreenCommand";
    public static final String PRODUCER_ID_STOP_COMMAND = "#StopCommand";
    private String lower;
    private String upper;
    private int type;

    private CommandProducer(String string, String string2, int n) {
        super("#" + string2 + "Command", CommandCD.TYPEID, new PaletteDescriptor("commands", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command", (Object)string2), NbBundle.getMessage(CommandProducer.class, (String)"TTIP_Command", (Object)string2), "org/netbeans/modules/vmd/midp/resources/components/command_16.png", "org/netbeans/modules/vmd/midp/resources/components/command_32.png"));
        this.lower = string;
        this.upper = string2;
        this.type = n;
    }

    public ComponentProducer.Result postInitialize(DesignDocument designDocument, DesignComponent designComponent) {
        designComponent.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(designComponent, this.lower + "Command"));
        designComponent.writeProperty("label", MidpTypes.createStringValue(this.upper));
        designComponent.writeProperty("type", MidpTypes.createIntegerValue(this.type));
        return new ComponentProducer.Result(new DesignComponent[]{designComponent});
    }

    public Boolean checkValidity(DesignDocument designDocument, boolean bl) {
        if (bl) {
            return MidpJavaSupport.getCache(designDocument).checkValidityCached(CommandCD.TYPEID);
        }
        return MidpJavaSupport.checkValidity(designDocument, CommandCD.TYPEID);
    }

    public static final class StopCommand
    extends CommandProducer {
        public StopCommand() {
            super("stop", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Stop"), 6);
        }
    }

    public static final class ScreenCommand
    extends CommandProducer {
        public ScreenCommand() {
            super("screen", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Screen"), 1);
        }
    }

    public static final class OkCommand
    extends CommandProducer {
        public OkCommand() {
            super("ok", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Ok"), 4);
        }
    }

    public static final class ItemCommand
    extends CommandProducer {
        public ItemCommand() {
            super("item", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Item"), 8);
        }
    }

    public static final class HelpCommand
    extends CommandProducer {
        public HelpCommand() {
            super("help", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Help"), 5);
        }
    }

    public static final class ExitCommand
    extends CommandProducer {
        public ExitCommand() {
            super("exit", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Exit"), 7);
        }
    }

    public static final class CancelCommand
    extends CommandProducer {
        public CancelCommand() {
            super("cancel", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Cancel"), 3);
        }
    }

    public static final class BackCommand
    extends CommandProducer {
        public BackCommand() {
            super("back", NbBundle.getMessage(CommandProducer.class, (String)"DISP_Command_Back"), 2);
        }
    }
}

