/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ItemCode {
    static final String PARAM_COMMAND = "itemCommand";
    static final String PARAM_ITEM_COMMAND_LISTENER = "itemCommandListener";
    static final String PARAM_LAYOUT = "layout";
    static final String PARAM_APPEARANCE_MODE = "appearanceMode";
    static final String PARAM_DEFAULT_COMMAND = "defaultCommand";

    public static Parameter createCommandParameter() {
        return new CommandParameter();
    }

    public static Parameter createItemCommandListenerParameter() {
        return new ItemCommandListenerParameter();
    }

    public static Parameter createItemLayoutParameter() {
        return new ItemLayoutParameter();
    }

    public static Parameter createAppearanceModeParameter() {
        return new AppearanceModeParameter();
    }

    public static Parameter createDefaultCommandParameter() {
        return new DefaultCommandParameter();
    }

    private static class DefaultCommandParameter
    implements Parameter {
        private DefaultCommandParameter() {
        }

        public String getParameterName() {
            return ItemCode.PARAM_DEFAULT_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), this.getDefaultCommand(component));
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return this.getDefaultCommand(component).getKind() != PropertyValue.Kind.NULL;
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private PropertyValue getDefaultCommand(DesignComponent component) {
            DesignComponent source = component.readProperty(ItemCode.PARAM_DEFAULT_COMMAND).getComponent();
            return source != null ? source.readProperty("command") : PropertyValue.createNull();
        }
    }

    private static class AppearanceModeParameter
    extends MidpParameter {
        protected AppearanceModeParameter() {
            super(ItemCode.PARAM_APPEARANCE_MODE);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ItemCode.PARAM_APPEARANCE_MODE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value) {
                    case 0: {
                        section.getWriter().write("Item.PLAIN");
                        return;
                    }
                    case 2: {
                        section.getWriter().write("Item.BUTTON");
                        return;
                    }
                    case 1: {
                        section.getWriter().write("Item.HYPERLINK");
                        return;
                    }
                }
                throw Debug.illegalState((Object[])new Object[0]);
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static class ItemLayoutParameter
    extends MidpParameter {
        protected ItemLayoutParameter() {
            super(ItemCode.PARAM_LAYOUT);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ItemCode.PARAM_LAYOUT);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value & 3) {
                    case 0: {
                        section.getWriter().write("ImageItem.LAYOUT_DEFAULT");
                        break;
                    }
                    case 1: {
                        section.getWriter().write("ImageItem.LAYOUT_LEFT");
                        break;
                    }
                    case 2: {
                        section.getWriter().write("ImageItem.LAYOUT_RIGHT");
                        break;
                    }
                    case 3: {
                        section.getWriter().write("ImageItem.LAYOUT_CENTER");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                if ((value & 0x10) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_TOP");
                }
                if ((value & 0x20) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_BOTTOM");
                }
                if ((value & 0x30) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_VCENTER");
                }
                if ((value & 0x100) != 0) {
                    section.getWriter().write(" | ImageItem.LAYOUT_NEWLINE_BEFORE");
                }
                if ((value & 0x200) != 0) {
                    section.getWriter().write(" | ImageItem.LAYOUT_NEWLINE_AFTER");
                }
                if ((value & 0x400) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_SHRINK");
                }
                if ((value & 0x800) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_VSHRINK");
                }
                if ((value & 0x1000) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_EXPAND");
                }
                if ((value & 0x2000) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_VEXPAND");
                }
                if ((value & 0x4000) != 0) {
                    section.getWriter().write(" | Item.LAYOUT_2");
                }
                return;
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static class ItemCommandListenerParameter
    extends MidpParameter {
        private ItemCommandListenerParameter() {
            super(ItemCode.PARAM_ITEM_COMMAND_LISTENER);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), component.readProperty(ItemCode.PARAM_ITEM_COMMAND_LISTENER));
        }

        @Override
        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("commands");
        }
    }

    private static class CommandParameter
    implements Parameter {
        private CommandParameter() {
        }

        public String getParameterName() {
            return ItemCode.PARAM_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("commands");
            List array = propertyValue.getArray();
            DesignComponent commandEventSource = ((PropertyValue)array.get(index)).getComponent();
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), commandEventSource.readProperty("command"));
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("commands");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("commands");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }
}

