/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private String buildClassesDir = "build.classes.dir";
    private static final String buildGeneratedDir = "build.generated.sources.dir";
    private String distJar = "dist.jar";
    private String buildTestClassesDir = "build.test.classes.dir";
    private String[] javacClasspath = new String[]{"javac.classpath"};
    private String[] processorClasspath = new String[]{"javac.processorpath"};
    private String[] javacTestClasspath = new String[]{"javac.test.classpath"};
    private String[] processorTestClasspath = new String[]{"javac.test.processorpath"};
    private String[] runClasspath = new String[]{"run.classpath"};
    private String[] runTestClasspath = new String[]{"run.test.classpath"};
    private String[] endorsedClasspath = new String[]{"endorsed.classpath"};
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[11];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private PropertyChangeListener listener;

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        this.listener = new PropertyChangeListener(){

            @Override
            public synchronized void propertyChange(PropertyChangeEvent evt) {
                ClassPathProviderImpl.this.dirCache.remove(evt.getPropertyName());
            }
        };
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)evaluator));
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, javacTestClasspath, runClasspath, runTestClasspath, new String[]{"endorsed.classpath"});
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, javacClasspath, javacTestClasspath, runClasspath, runTestClasspath, new String[]{"endorsed.classpath"});
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] processorPath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots);
        this.buildClassesDir = buildClassesDir;
        this.distJar = distJar;
        this.buildTestClassesDir = buildTestClassesDir;
        this.javacClasspath = javacClasspath;
        this.processorClasspath = processorPath;
        this.javacTestClasspath = javacTestClasspath;
        this.runClasspath = runClasspath;
        this.runTestClasspath = runTestClasspath;
        this.endorsedClasspath = endorsedClasspath;
    }

    private FileObject getDir(final String propname) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String prop;
                    FileObject fo = (FileObject)ClassPathProviderImpl.this.dirCache.get(propname);
                    if (!(fo != null && fo.isValid() || (prop = ClassPathProviderImpl.this.evaluator.getProperty(propname)) == null)) {
                        fo = ClassPathProviderImpl.this.helper.resolveFileObject(prop);
                        ClassPathProviderImpl.this.dirCache.put(propname, fo);
                    }
                    return fo;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(this.buildClassesDir);
    }

    private FileObject getBuildGeneratedDir() {
        return this.getDir(buildGeneratedDir);
    }

    private FileObject getDistJar() {
        return this.getDir(this.distJar);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(this.buildTestClassesDir);
    }

    private FileObject getAnnotationProcessingSourceOutputDir() {
        return this.getDir("annotation.processing.source.output");
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        dir = this.getBuildGeneratedDir();
        if (dir != null && FileUtil.isParentOf((FileObject)dir, (FileObject)file)) {
            dir = this.getAnnotationProcessingSourceOutputDir();
            if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private synchronized ClassPath getCompileTimeClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[2 + type];
        if (cp == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacClasspath)) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacTestClasspath));
            this.cache[2 + type] = cp;
        }
        return cp;
    }

    private ClassPath getProcessorClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getProcessorClasspath(type);
    }

    private synchronized ClassPath getProcessorClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[9 + type];
        if (cp == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.processorClasspath)) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.processorTestClasspath));
            this.cache[9 + type] = cp;
        }
        return cp;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        return this.getRunTimeClasspath(type);
    }

    private synchronized ClassPath getRunTimeClasspath(int type) {
        int cacheIndex;
        if (type == 0 || type == 2) {
            cacheIndex = 4;
        } else if (type == 1 || type == 3) {
            cacheIndex = 5;
        } else if (type == 4) {
            cacheIndex = 6;
        } else {
            return null;
        }
        ClassPath cp = this.cache[cacheIndex];
        if (cp == null) {
            if (type == 0 || type == 2) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runClasspath));
            } else if (type == 1 || type == 3) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runTestClasspath));
            } else if (type == 4) {
                String[] props = new String[this.runClasspath.length + 1];
                System.arraycopy(this.runClasspath, 0, props, 1, this.runClasspath.length);
                props[0] = this.distJar;
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])props));
            }
            this.cache[cacheIndex] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getEndorsedClasspath() {
        ClassPath cp = this.cache[8];
        if (cp == null) {
            this.cache[8] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.endorsedClasspath));
        }
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private synchronized ClassPath getSourcepath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.testSourceRoots, this.helper, this.evaluator));
                }
            }
        }
        this.cache[type] = cp;
        return cp;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation(this.evaluator, this.getEndorsedClasspath()));
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/processor")) {
            return this.getProcessorClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (type.equals("classpath/endorsed")) {
            return this.getEndorsedClasspath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(final String type) {
        return (ClassPath[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath[]>(){

            public ClassPath[] run() {
                if ("classpath/boot".equals(type)) {
                    return new ClassPath[]{ClassPathProviderImpl.this.getBootClassPath()};
                }
                if ("classpath/compile".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getCompileTimeClasspath(0), ClassPathProviderImpl.this.getCompileTimeClasspath(1)};
                    return l;
                }
                if ("classpath/processor".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getProcessorClasspath(0), ClassPathProviderImpl.this.getProcessorClasspath(1)};
                    return l;
                }
                if ("classpath/source".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getSourcepath(0), ClassPathProviderImpl.this.getSourcepath(1)};
                    return l;
                }
                assert (false);
                return null;
            }
        });
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/processor".equals(type)) {
            return this.getProcessorClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(type)) {
            return this.getRunTimeClasspath(0);
        }
        assert (false) : "Unknown classpath type: " + type;
        return null;
    }

    public String[] getPropertyName(SourceRoots roots, String type) {
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        if (roots.isTest()) {
            if ("classpath/compile".equals(type)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runTestClasspath;
            }
            if ("classpath/processor".equals(type)) {
                return this.processorTestClasspath;
            }
            return null;
        }
        if ("classpath/compile".equals(type)) {
            return this.javacClasspath;
        }
        if ("classpath/execute".equals(type)) {
            return this.runClasspath;
        }
        if ("classpath/processor".equals(type)) {
            return this.processorClasspath;
        }
        return null;
    }

    public String[] getPropertyName(SourceGroup sg, String type) {
        int i;
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        FileObject root = sg.getRootFolder();
        FileObject[] path = this.getPrimarySrcPath();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("classpath/compile".equals(type)) {
                return this.javacClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runClasspath;
            }
            if ("classpath/processor".equals(type)) {
                return this.processorClasspath;
            }
            return null;
        }
        path = this.getTestSrcDir();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("classpath/compile".equals(type)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runTestClasspath;
            }
            return null;
        }
        return null;
    }
}

