/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.TopSecurityManager;

public class StartLog {
    private static final Logger LOG = Logger.getLogger("org.netbeans.log.startup");
    private static final Stack<String> actions = new Stack();
    private static final Stack<Throwable> places = new Stack();
    private static final boolean DEBUG_NESTING = Boolean.getBoolean("org.netbeans.log.startup.debug");
    private static final String logProp = System.getProperty("org.netbeans.log.startup");
    private static final String logFileProp = System.getProperty("org.netbeans.log.startup.logfile");
    static final Handler impl;

    static void register() {
        LOG.setUseParentHandlers(false);
        LOG.addHandler(impl);
        LOG.setLevel(impl.getLevel());
    }

    public static void logStart(String action) {
        if (StartLog.willLog()) {
            LOG.log(Level.FINE, "start", action);
            actions.push(action);
            if (DEBUG_NESTING) {
                places.push(new Throwable("logStart called here:"));
            }
        }
    }

    public static void logProgress(String note) {
        if (StartLog.willLog()) {
            LOG.log(Level.FINE, "progress", note);
        }
    }

    public static void logEnd(String action) {
        if (StartLog.willLog()) {
            Throwable oldplace;
            String old = actions.empty() ? null : actions.pop();
            Throwable throwable = oldplace = DEBUG_NESTING && !places.empty() ? places.pop() : null;
            if (!action.equals(old)) {
                if (oldplace != null) {
                    oldplace.printStackTrace();
                } else {
                    System.err.println("Either ending too soon, or no info about caller of unmatched start log.");
                    System.err.println("Try running with -J-Dorg.netbeans.log.startup.debug=true");
                }
                Error e = new Error("StartLog mismatch: ending '" + action + "' but expecting '" + old + "'; rest of stack: " + actions);
                e.printStackTrace();
                System.err.flush();
                TopSecurityManager.exit((int)1);
            }
            LOG.log(Level.FINE, "end", action);
        }
    }

    public static boolean willLog() {
        return LOG.isLoggable(Level.FINE);
    }

    public static void logMeasuredStartupTime(long end) {
        LOG.log(Level.FINE, "finish", end);
    }

    static {
        if (logProp == null) {
            impl = new StartImpl();
        } else if ("print".equals(logProp)) {
            impl = new PrintImpl();
        } else if ("tests".equals(logProp)) {
            impl = new PerformanceTestsImpl();
        } else {
            throw new Error("Unknown org.netbeans.log.startup value [" + logProp + "], it should be (print or tests) !");
        }
        StartLog.register();
    }

    private static class PerformanceTestsImpl
    extends StartImpl {
        private StringBuffer logs = new StringBuffer();
        private Stack<Long> starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PerformanceTestsImpl() {
        }

        @Override
        synchronized void start(String action, long time) {
            this.starts.push(time);
            this.prog = time;
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " started");
            this.indent += 2;
        }

        @Override
        synchronized void progress(String note, long time) {
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + note + " dT=" + (time - this.prog));
            this.prog = time;
        }

        @Override
        synchronized void end(String action, long time) {
            this.indent -= 2;
            long start = this.starts.pop();
            this.prog = time;
            this.log(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " finished, took " + (time - start) + "ms");
        }

        @Override
        boolean willLog() {
            return true;
        }

        private String getIndentString(int indent) {
            if (this.spaces.length < indent) {
                this.spaces = new char[Math.max(this.spaces.length * 2, indent + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, indent);
        }

        synchronized void log(String log) {
            this.logs.append("\n" + log);
        }

        @Override
        public void publish(LogRecord rec) {
            super.publish(rec);
            if ("finish".equals(rec.getMessage())) {
                long end = (Long)rec.getParameters()[0];
                this.log("IDE starts t = " + Long.toString(this.zero) + "\nIDE is running t=" + Long.toString(end) + "\n");
            }
        }

        @Override
        public synchronized void flush() {
            if (logFileProp != null) {
                try {
                    File logFile = new File(logFileProp);
                    FileWriter writer = new FileWriter(logFile);
                    writer.write(this.logs.toString());
                    writer.close();
                }
                catch (Exception exc) {
                    System.err.println("EXCEPTION rises during startup logging:");
                    exc.printStackTrace(System.err);
                }
            } else {
                throw new IllegalStateException("You are trying to log startup logs to unexisting file. You have to set property org.netbeans.log.startup.logfile.");
            }
        }
    }

    private static class PrintImpl
    extends StartImpl {
        private Stack<Long> starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PrintImpl() {
        }

        @Override
        synchronized void start(String action, long time) {
            this.starts.push(time);
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " started");
            this.indent += 2;
        }

        @Override
        synchronized void progress(String note, long time) {
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + note + " dT=" + (time - this.prog));
            this.prog = time;
        }

        @Override
        synchronized void end(String action, long time) {
            this.indent -= 2;
            long start = this.starts.pop();
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " finished, took " + (time - start) + "ms");
        }

        @Override
        boolean willLog() {
            return true;
        }

        private String getIndentString(int indent) {
            if (this.spaces.length < indent) {
                this.spaces = new char[Math.max(this.spaces.length * 2, indent + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, indent);
        }
    }

    private static class StartImpl
    extends Handler {
        final long zero = System.nanoTime() / 1000000L;

        StartImpl() {
        }

        void start(String action, long time) {
        }

        void progress(String note, long time) {
        }

        void end(String action, long time) {
        }

        boolean willLog() {
            return false;
        }

        @Override
        public Level getLevel() {
            return this.willLog() ? Level.FINEST : Level.OFF;
        }

        @Override
        public void publish(LogRecord rec) {
            Object[] args = rec.getParameters();
            String msg = args.length >= 1 && args[0] instanceof String ? (String)args[0] : "";
            long time = System.nanoTime() / 1000000L;
            if ("start".equals(rec.getMessage())) {
                this.start(msg, time);
                return;
            }
            if ("end".equals(rec.getMessage())) {
                this.end(msg, time);
                return;
            }
            if ("progress".equals(rec.getMessage())) {
                this.progress(msg, time);
                return;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final void close() throws SecurityException {
        }
    }
}

