/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavaCardServer;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JCServerInfoTask
extends Task {
    private String serverId;
    private String serverURLProperty;
    private String cardManagerURLProperty;
    private String targetProperty;
    private String toolsClassPathProperty;
    private String contactedPortProperty;
    private String contactlessPortProperty;
    private String serverNameProperty;

    public void setServerNameProperty(String s) {
        this.serverNameProperty = s;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setServerUrlProperty(String propertyName) {
        this.serverURLProperty = propertyName;
    }

    public void setCardManagerUrlProperty(String propertyName) {
        this.cardManagerURLProperty = propertyName;
    }

    public void setContactedPortProperty(String contactedPortProperty) {
        this.contactedPortProperty = contactedPortProperty;
    }

    public void setContactlessPortProperty(String contactlessPortProperty) {
        this.contactlessPortProperty = contactlessPortProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public void setToolsClassPathProperty(String tc) {
        this.toolsClassPathProperty = tc;
    }

    public void execute() throws BuildException {
        JavaCardServer server = this.getServer();
        if (server.getJcdkHome() == null) {
            throw new BuildException("JC_CONNECTED_HOME is not set/correct");
        }
        if (this.serverURLProperty != null) {
            this.getProject().setProperty(this.serverURLProperty, server.getServerURL());
        }
        if (this.cardManagerURLProperty != null) {
            this.getProject().setProperty(this.cardManagerURLProperty, server.getCardManagerURL());
        }
        if (this.contactedPortProperty != null) {
            this.getProject().setProperty(this.contactedPortProperty, "9025");
        }
        if (this.contactlessPortProperty != null) {
            this.getProject().setProperty(this.contactlessPortProperty, "9026");
        }
        if (this.serverNameProperty != null) {
            this.getProject().setProperty(this.serverNameProperty, server.getDisplayName());
        }
        if (this.targetProperty != null) {
            this.getProject().setProperty(this.targetProperty, server.isRi() ? "RI" : "RC");
        }
        if (this.toolsClassPathProperty != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(new File(server.getJcdkHome(), "lib/tools.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-cli-1.0.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-codec-1.3.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-httpclient-3.0.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-logging-1.1.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/bcel-5.2.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/ant-contrib-1.0b3.jar").getAbsolutePath());
            this.getProject().setProperty(this.toolsClassPathProperty, sb.toString());
        }
    }

    protected JavaCardServer getServer() throws BuildException {
        return JavaCardServer.getServer();
    }
}

