/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfStatementList {
    public long total_length;
    public int version;
    public long prologue_length;
    public int minimum_instruction_length;
    public int default_is_stmt;
    public int line_base;
    public int line_range;
    public int opcode_base;
    public long[] standard_opcode_lengths;
    public List<String> includeDirs = new ArrayList<String>();
    public List<FileEntry> fileEntries = new ArrayList<FileEntry>();
    public Map<String, Set<FileEntry>> name2entry;
    private long offset;

    public DwarfStatementList(long offset) {
        this.offset = offset;
    }

    public List<String> getIncludeDirectories() {
        return this.includeDirs;
    }

    public List<String> getFilePaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (int idx = 1; idx <= this.fileEntries.size(); ++idx) {
            String filepath = this.getFilePath(idx);
            if (filepath == null) continue;
            result.add(filepath);
        }
        return result;
    }

    public List<FileEntry> getFileEntries() {
        return this.fileEntries;
    }

    public void dump(PrintStream out) {
        out.printf("\nPrologue Statement List (offset = %d [0x%08x]):\n\n", this.offset, this.offset);
        out.printf("  %-28s %s\n", "Length:", this.total_length);
        out.printf("  %-28s %s\n", "DWARF Version:", this.version);
        out.printf("  %-28s %s\n", "Prologue Length:", this.prologue_length);
        out.printf("  %-28s %s\n", "Minimum Instruction Length:", this.minimum_instruction_length);
        out.printf("  %-28s %s\n", "Initial value of 'is_stmt':", this.default_is_stmt);
        out.printf("  %-28s %s\n", "Line Base:", this.line_base);
        out.printf("  %-28s %s\n", "Line Range:", this.line_range);
        out.printf("  %-28s %s\n", "Opcode Base:", this.opcode_base);
        out.println("\n Opcodes:");
        for (int i = 0; i < this.standard_opcode_lengths.length; ++i) {
            out.printf("  Opcode %d has %d args\n", i + 1, this.standard_opcode_lengths[i]);
        }
        out.println("\n The Directory Table:\n");
        int idx = 0;
        out.println(" Entry Path");
        for (String includeDir : this.includeDirs) {
            out.printf(" %-6d%s\n", ++idx, includeDir);
        }
        out.println("\n The File Name Table:\n");
        out.println(" Entry Dir   Time  Size  Name");
        idx = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            out.printf(" %-6d%-6d%-6d%-6d%s\n", ++idx, fileEntry.dirIndex, fileEntry.modifiedTime, fileEntry.fileSize, fileEntry.fileName);
        }
    }

    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    public int getDirectoryIndex(String dirname) {
        int idx = 0;
        if (dirname == null) {
            return 0;
        }
        for (String dir : this.includeDirs) {
            ++idx;
            if (!dir.equals(dirname)) continue;
            return idx;
        }
        return 0;
    }

    public int getFileEntryIdx(String fileName) {
        File file = new File(fileName);
        String dirname = file.getParent();
        String fname = file.getName();
        return this.getFileEntryIdx(this.getDirectoryIndex(dirname), fname);
    }

    private int getFileEntryIdx(int dirIdx, String fname) {
        int idx = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            ++idx;
            if (fileEntry.dirIndex != dirIdx || !fileEntry.fileName.equals(fname)) continue;
            return idx;
        }
        return 0;
    }

    public String getFilePath(int idx) {
        String dir;
        FileEntry fileEntry = this.fileEntries.get(idx - 1);
        if (fileEntry == null || fileEntry.fileName.equals("<internal>") || fileEntry.fileName.equals("<built-in>")) {
            return null;
        }
        String result = fileEntry.dirIndex == 0 ? "." + File.separator + fileEntry.fileName : ((dir = this.includeDirs.get(fileEntry.dirIndex - 1)).endsWith("\\") || dir.endsWith("/") ? dir + fileEntry.fileName : dir + File.separator + fileEntry.fileName);
        return result;
    }

    public List<String> getPathsForFile(String fname) {
        Map<String, Set<FileEntry>> map = this.getName2Entry();
        Set<FileEntry> set = map.get(fname);
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String suffix = File.separator + fname;
        StringBuilder buf = new StringBuilder(100);
        for (FileEntry fileEntry : set) {
            if (fileEntry.fileName.equals(fname)) {
                String dir = fileEntry.dirIndex == 0 ? "." : this.includeDirs.get(fileEntry.dirIndex - 1);
                result.add(dir);
                continue;
            }
            if (!fileEntry.fileName.endsWith(suffix)) continue;
            buf.setLength(0);
            buf.append(fileEntry.dirIndex == 0 ? "." : this.includeDirs.get(fileEntry.dirIndex - 1));
            buf.append(File.separator);
            buf.append(fileEntry.fileName.substring(0, fileEntry.fileName.length() - fname.length() - 1));
            result.add(buf.toString());
        }
        return result;
    }

    private Map<String, Set<FileEntry>> getName2Entry() {
        if (this.name2entry == null) {
            HashMap<String, Set<FileEntry>> res = new HashMap<String, Set<FileEntry>>();
            for (FileEntry fileEntry : this.fileEntries) {
                int i = fileEntry.fileName.lastIndexOf(File.separator);
                String key = i >= 0 ? fileEntry.fileName.substring(i + 1) : fileEntry.fileName;
                HashSet<FileEntry> set = (HashSet<FileEntry>)res.get(key);
                if (set == null) {
                    set = new HashSet<FileEntry>();
                    res.put(key, set);
                }
                set.add(fileEntry);
            }
            this.name2entry = res;
        }
        return this.name2entry;
    }
}

