/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class TableNode
extends BaseNode
implements SchemaNameProvider {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/table.gif";
    private static final String FOLDER = "Table";
    private String name = "";
    private final MetadataElementHandle<Table> tableHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static TableNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        TableNode node = new TableNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private TableNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.tableHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Table table = (Table)TableNode.this.tableHandle.resolve(metaData);
                        TableNode.this.name = table.getName();
                        TableNode.this.updateProperties(table);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Table table) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        this.addProperty("Catalog", "CatalogDescription", String.class, false, this.getCatalogName());
        this.addProperty("Schema", "SchemaDescription", String.class, false, this.getSchemaName());
    }

    public MetadataElementHandle<Table> getTableHandle() {
        return this.tableHandle;
    }

    @Override
    public String getCatalogName() {
        return TableNode.getCatalogName(this.connection, this.tableHandle);
    }

    @Override
    public String getSchemaName() {
        return TableNode.getSchemaName(this.connection, this.tableHandle);
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        Specification spec = connector.getDatabaseSpecification();
        try {
            AbstractCommand command = spec.createCommandDropTable(this.getName());
            String schemaName = this.getSchemaName();
            String catalogName = this.getCatalogName();
            if (schemaName == null) {
                schemaName = catalogName;
            }
            command.setObjectOwner(schemaName);
            command.execute();
        }
        catch (DDLException e) {
            Logger.getLogger(TableNode.class.getName()).log(Level.INFO, e + " while deleting table " + this.getName());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{this.getParentNode()});
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector connector = this.connection.getConnector();
        return connector.supportsCommand("DropTableCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TableNode.class, (String)"ND_Table");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TableNode.class);
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable result = ExTransferable.create((Transferable)super.clipboardCopy());
        result.put(new ExTransferable.Single(DatabaseMetaDataTransfer.TABLE_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createTableData(TableNode.this.connection.getDatabaseConnection(), TableNode.this.connection.findJDBCDriver(), TableNode.this.getName());
            }
        });
        return result;
    }

    public static String getSchemaName(DatabaseConnection connection, final MetadataElementHandle<Table> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Table table = (Table)handle.resolve(metaData);
                    if (table != null) {
                        array[0] = table.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(TableNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getCatalogName(DatabaseConnection connection, final MetadataElementHandle<Table> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Table table = (Table)handle.resolve(metaData);
                    if (table != null) {
                        array[0] = table.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(TableNode.class, connection, e, true);
        }
        return array[0];
    }
}

