/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.openide.filesystems.FileObject;

public final class JavaRefactoringUtils {
    private JavaRefactoringUtils() {
    }

    public static Collection<ExecutableElement> getOverriddenMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return RetoucheUtils.getOverridenMethods(executableElement, compilationInfo);
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return RetoucheUtils.getOverridingMethods(executableElement, compilationInfo);
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        return RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RetoucheUtils.isRefactorable(fileObject) && fileObject.canWrite() && fileObject.canRead();
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
        return RetoucheUtils.getSuperTypes(typeElement, compilationInfo);
    }

    public static TreePath findEnclosingClass(CompilationInfo compilationInfo, TreePath treePath, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return RetoucheUtils.findEnclosingClass(compilationInfo, treePath, bl, bl2, bl3, bl4, bl5);
    }

    public static List<TypeMirror> elementsToTypes(List<? extends Element> list) {
        return RetoucheUtils.resolveTypeParamsAsTypes(list);
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... fileObjectArray) {
        return RetoucheUtils.getClasspathInfoFor(fileObjectArray);
    }

    public static List<TreePathHandle> treesToHandles(TreePath treePath, Iterable<? extends Tree> iterable, CompilationInfo compilationInfo) {
        ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>(iterable instanceof Collection ? ((Collection)iterable).size() : 11);
        for (Tree tree : iterable) {
            TreePath treePath2 = TreePath.getPath(treePath, tree);
            TreePathHandle treePathHandle = TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo);
            arrayList.add(treePathHandle);
            assert (treePathHandle.resolve(compilationInfo) != null) : "Newly created TreePathHandle resolves to null";
            assert (treePathHandle.resolve(compilationInfo).getLeaf() != null) : "Newly created TreePathHandle.getLeaf() resolves to null";
        }
        return arrayList;
    }

    public static List<TreePathHandle> treesToHandles(Iterable<? extends Tree> iterable, CompilationInfo compilationInfo) {
        ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>(iterable instanceof Collection ? ((Collection)iterable).size() : 11);
        for (Tree tree : iterable) {
            TreePath treePath = TreePath.getPath(compilationInfo.getCompilationUnit(), tree);
            if (treePath == null) {
                throw new IllegalArgumentException(tree + " does not belong to " + "the same compilation unit passed to this method");
            }
            TreePathHandle treePathHandle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
            arrayList.add(treePathHandle);
            assert (treePathHandle.resolve(compilationInfo) != null) : "Newly created TreePathHandle resolves to null";
            assert (treePathHandle.resolve(compilationInfo).getLeaf() != null) : "Newly created TreePathHandle.getLeaf() resolves to null";
        }
        return arrayList;
    }

    public static <T extends Element> List<T> handlesToElements(Iterable<ElementHandle<T>> iterable, CompilationInfo compilationInfo) {
        ArrayList<Element> arrayList = new ArrayList<Element>(iterable instanceof Collection ? ((Collection)iterable).size() : 0);
        for (ElementHandle<T> elementHandle : iterable) {
            Element element = elementHandle.resolve(compilationInfo);
            assert (element != null) : element + " resolves to null";
            arrayList.add(element);
        }
        return arrayList;
    }

    public static List<TypeMirror> handlesToTypes(Iterable<? extends TypeMirrorHandle> iterable, CompilationInfo compilationInfo) {
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
        for (TypeMirrorHandle typeMirrorHandle : iterable) {
            arrayList.add(typeMirrorHandle.resolve(compilationInfo));
        }
        return arrayList;
    }

    public static List<TypeMirrorHandle> typesToHandles(Iterable<? extends TypeMirror> iterable) {
        ArrayList<TypeMirrorHandle> arrayList = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror : iterable) {
            arrayList.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
        }
        return arrayList;
    }

    public static <T extends Element> List<ElementHandle<T>> elementsToHandles(Iterable<? extends T> iterable) {
        ArrayList<ElementHandle<T>> arrayList = new ArrayList<ElementHandle<T>>(iterable instanceof Collection ? ((Collection)iterable).size() : 11);
        for (Element element : iterable) {
            ElementHandle elementHandle = ElementHandle.create((Element)element);
            assert (elementHandle != null) : "Couldn't create handle for " + element;
            arrayList.add(elementHandle);
        }
        return arrayList;
    }

    public static Collection<TreePathHandle> getInvocationsOf(ElementHandle elementHandle, CompilationController compilationController) throws IOException {
        assert (elementHandle != null);
        assert (compilationController != null);
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        Element element = elementHandle.resolve((CompilationInfo)compilationController);
        TypeElement typeElement = compilationController.getElementUtilities().enclosingTypeElement(element);
        ElementHandle elementHandle2 = ElementHandle.create((Element)typeElement);
        assert (elementHandle2 != null);
        Set set = compilationController.getClasspathInfo().getClassIndex().getElements(elementHandle2, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>();
        for (ElementHandle elementHandle3 : set) {
            arrayList.addAll(JavaRefactoringUtils.getReferencesToMember((ElementHandle<TypeElement>)elementHandle3, compilationController.getClasspathInfo(), elementHandle));
        }
        return arrayList;
    }

    public static Collection<TreePathHandle> getReferencesToMember(ElementHandle<TypeElement> elementHandle, ClasspathInfo classpathInfo, ElementHandle elementHandle2) throws IOException {
        FileObject fileObject = SourceUtils.getFile(elementHandle, (ClasspathInfo)classpathInfo);
        assert (fileObject != null) : "SourceUtils.getFile(" + elementHandle + ") returned null";
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        InvocationScanner invocationScanner = new InvocationScanner(elementHandle2);
        javaSource.runUserActionTask((Task)invocationScanner, true);
        return invocationScanner.usages;
    }

    public static void cacheTreePathInfo(TreePath treePath, CompilationInfo compilationInfo) {
        ElementGripFactory.getDefault().put(compilationInfo.getFileObject(), treePath, compilationInfo);
    }

    private static final class InvocationScanner
    extends TreePathScanner<Tree, ElementHandle>
    implements CancellableTask<CompilationController> {
        private CompilationController cc;
        private final ElementHandle toFind;
        Set<TreePathHandle> usages = new HashSet<TreePathHandle>();
        boolean cancelled;

        InvocationScanner(ElementHandle elementHandle) {
            this.toFind = elementHandle;
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree memberSelectTree, ElementHandle elementHandle) {
            assert (this.cc != null);
            Element element = elementHandle.resolve((CompilationInfo)this.cc);
            this.addIfMatch(this.getCurrentPath(), memberSelectTree, element);
            return (Tree)super.visitMemberSelect(memberSelectTree, elementHandle);
        }

        private void addIfMatch(TreePath treePath, Tree tree, Element element) {
            if (this.cc.getTreeUtilities().isSynthetic(treePath)) {
                return;
            }
            Element element2 = this.cc.getTrees().getElement(treePath);
            if (element2 == null) {
                return;
            }
            if (element.getKind() == ElementKind.METHOD && element2.getKind() == ElementKind.METHOD) {
                if (((Object)element2).equals(element) || this.cc.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, (TypeElement)element.getEnclosingElement())) {
                    this.addUsage(this.getCurrentPath());
                }
            } else if (((Object)element2).equals(element)) {
                this.addUsage(this.getCurrentPath());
            }
        }

        void addUsage(TreePath treePath) {
            this.usages.add(TreePathHandle.create((TreePath)treePath, (CompilationInfo)this.cc));
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CompilationController compilationController) throws Exception {
            if (this.cancelled) {
                return;
            }
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            if (this.cancelled) {
                return;
            }
            this.cc = compilationController;
            try {
                TreePath treePath = new TreePath(compilationController.getCompilationUnit());
                this.scan(treePath, this.toFind);
            }
            finally {
                this.cc = null;
            }
        }
    }
}

