/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.net.URL;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.ui.Icons;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;

public class JavaSymbolDescriptor
extends SymbolDescriptor {
    private final String displayName;
    private final ElementHandle<TypeElement> owner;
    private final ElementHandle<?> me;
    private final ElementKind kind;
    private final Set<Modifier> modifiers;
    private final FileObject root;
    private final Project project;
    private FileObject cachedFo;

    public JavaSymbolDescriptor(String string, ElementKind elementKind, Set<Modifier> set, ElementHandle<TypeElement> elementHandle, ElementHandle<?> elementHandle2, Project project, FileObject fileObject) {
        assert (string != null);
        assert (elementKind != null);
        assert (set != null);
        assert (elementHandle != null);
        assert (elementHandle2 != null);
        this.displayName = string;
        this.kind = elementKind;
        this.modifiers = set;
        this.owner = elementHandle;
        this.me = elementHandle2;
        this.root = fileObject;
        this.project = project;
    }

    public Icon getIcon() {
        return Icons.getElementIcon((ElementKind)this.kind, this.modifiers);
    }

    public String getSymbolName() {
        return this.displayName;
    }

    public String getOwnerName() {
        return this.owner.getQualifiedName();
    }

    public FileObject getFileObject() {
        if (this.cachedFo == null) {
            ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.root}));
            this.cachedFo = SourceUtils.getFile(this.owner, (ClasspathInfo)classpathInfo);
        }
        return this.cachedFo;
    }

    public void open() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
            ElementOpen.open(classpathInfo, this.me);
        }
    }

    public String getProjectName() {
        return this.project == null ? "" : ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public Icon getProjectIcon() {
        return this.project == null ? null : ProjectUtils.getInformation((Project)this.project).getIcon();
    }

    public int getOffset() {
        return -1;
    }
}

