/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class Bookmark {
    public static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    private static Map<Line, AAnnotation> lineToAnnotation = new WeakHashMap<Line, AAnnotation>();
    private BookmarkList bookmarkList;
    private boolean released;
    private Line line;
    private AAnnotation annotation;
    private Map<BookmarkList, LineListener> bookmarkListToLineListener = new WeakHashMap<BookmarkList, LineListener>();

    Bookmark(BookmarkList bookmarkList, int offset) {
        this.bookmarkList = bookmarkList;
        StyledDocument document = (StyledDocument)bookmarkList.getDocument();
        int lineNumber = NbDocument.findLineNumber((StyledDocument)document, (int)offset);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        for (Line _line : lineToAnnotation.keySet()) {
            if (_line.getLineNumber() != lineNumber || !((DataObject)_line.getLookup().lookup(DataObject.class)).equals(dataObject)) continue;
            this.line = _line;
            this.annotation = lineToAnnotation.get(_line);
            return;
        }
        this.annotation = new AAnnotation();
        this.line = NbEditorUtilities.getLine((Document)bookmarkList.getDocument(), (int)offset, (boolean)false);
        lineToAnnotation.put(this.line, this.annotation);
        this.annotation.attach((Annotatable)this.line);
        LineListener lineListener = this.bookmarkListToLineListener.get(bookmarkList);
        if (lineListener == null) {
            lineListener = new LineListener(bookmarkList);
            this.bookmarkListToLineListener.put(bookmarkList, lineListener);
        }
        this.line.addPropertyChangeListener((PropertyChangeListener)lineListener);
    }

    public int getOffset() {
        return NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.bookmarkList.getDocument()), (int)this.line.getLineNumber());
    }

    public int getLineNumber() {
        return this.line.getLineNumber();
    }

    public BookmarkList getList() {
        return this.bookmarkList;
    }

    public boolean isReleased() {
        return this.released;
    }

    void release() {
        assert (!this.released);
        this.released = true;
        this.annotation.detach();
        lineToAnnotation.remove(this.line);
    }

    private static class LineListener
    implements PropertyChangeListener {
        private WeakReference<BookmarkList> bookmarkListReference;

        LineListener(BookmarkList bookmarkList) {
            this.bookmarkListReference = new WeakReference<BookmarkList>(bookmarkList);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BookmarkList bookmarkList = (BookmarkList)this.bookmarkListReference.get();
            if (bookmarkList == null) {
                return;
            }
            ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(bookmarkList.getBookmarks());
            int lineNumber = -1;
            for (Bookmark bookmark : bookmarks) {
                if (bookmark.getLineNumber() == lineNumber) {
                    bookmarkList.removeBookmark(bookmark);
                }
                lineNumber = bookmark.getLineNumber();
            }
        }
    }

    public final class AAnnotation
    extends Annotation {
        public String getAnnotationType() {
            return Bookmark.BOOKMARK_ANNOTATION_TYPE;
        }

        public String getShortDescription() {
            String fmt = NbBundle.getBundle(Bookmark.class).getString("Bookmark_Tooltip");
            int lineIndex = Bookmark.this.getLineNumber();
            return MessageFormat.format(fmt, new Integer(lineIndex + 1));
        }

        public String toString() {
            return this.getShortDescription();
        }
    }
}

