/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.bridge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.UnusedFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public class DiscoveryProjectGenerator {
    private static boolean DEBUG = Boolean.getBoolean("cnd.discovery.trace.project_update");
    private ProjectBridge projectBridge;
    private DiscoveryDescriptor wizard;
    private String baseFolder;
    private String level;

    public DiscoveryProjectGenerator(DiscoveryDescriptor wizard) throws IOException {
        this.wizard = wizard;
        this.baseFolder = wizard.getRootFolder();
        Project project = wizard.getProject();
        this.projectBridge = project != null ? new ProjectBridge(project) : new ProjectBridge(this.baseFolder);
    }

    public void process() {
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        Folder sourceRoot = this.projectBridge.getRoot();
        this.level = this.wizard.getLevel();
        HashSet<Item> used = new HashSet<Item>();
        for (ProjectConfiguration config : projectConfigurations) {
            this.setupCompilerConfiguration(config);
            this.addConfiguration(sourceRoot, config, used);
        }
        this.addAdditional(sourceRoot, this.baseFolder, used);
        if ("file".equals(this.level)) {
            this.upConfiguration(sourceRoot, true);
            this.upConfiguration(sourceRoot, false);
            this.downConfiguration(sourceRoot, true);
            this.downConfiguration(sourceRoot, false);
        }
        this.projectBridge.save();
        this.projectBridge.dispose();
    }

    private void downConfiguration(Folder folder, boolean isCPP) {
        CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(isCPP, folder);
        if (cccc != null) {
            List commonFoldersIncludes = cccc.getIncludeDirectories().getValue();
            List commonFoldersMacros = cccc.getPreprocessorConfiguration().getValue();
            this.projectBridge.setupProject(commonFoldersIncludes, commonFoldersMacros, isCPP);
            this.projectBridge.setupFolder(Collections.<String>emptyList(), true, Collections.<String>emptyList(), true, isCPP, folder);
            this.downConfiguration(folder, isCPP, commonFoldersIncludes, commonFoldersMacros);
        }
    }

    private void downConfiguration(Folder folder, boolean isCPP, List<String> commonFoldersIncludes, List<String> commonFoldersMacros) {
        for (Folder subFolder : folder.getFoldersAsArray()) {
            CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(isCPP, subFolder);
            if (cccc == null) continue;
            ArrayList<String> aCommonFoldersIncludes = new ArrayList<String>(commonFoldersIncludes);
            ArrayList<String> cCommonFoldersMacros = new ArrayList<String>(commonFoldersMacros);
            ArrayList<String> foldersIncludes = new ArrayList<String>();
            ArrayList<String> foldersMacros = new ArrayList<String>();
            for (String s : cccc.getIncludeDirectories().getValue()) {
                if (aCommonFoldersIncludes.contains(s)) continue;
                foldersIncludes.add(s);
                aCommonFoldersIncludes.add(s);
            }
            for (String s : cccc.getPreprocessorConfiguration().getValue()) {
                if (cCommonFoldersMacros.contains(s)) continue;
                foldersMacros.add(s);
                cCommonFoldersMacros.add(s);
            }
            this.projectBridge.setupFolder(foldersIncludes, true, foldersMacros, true, isCPP, subFolder);
            this.downConfiguration(subFolder, isCPP, aCommonFoldersIncludes, cCommonFoldersMacros);
        }
    }

    private Folder getOrCreateFolder(Folder folder, String name, AbstractRoot used) {
        Folder added = folder.findFolderByName(name);
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        } else if (added.isDiskFolder()) {
            String additionalPath = used.getFolder();
            String folderPath = CndPathUtilitities.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)added.getRootPath());
            Folder logicalCandidate = null;
            if (!additionalPath.equals(folderPath)) {
                for (Folder candidate : folder.getFolders()) {
                    if (candidate.isDiskFolder()) {
                        folderPath = CndPathUtilitities.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)candidate.getRootPath());
                        if (!additionalPath.equals(folderPath)) continue;
                        added = candidate;
                        break;
                    }
                    if (logicalCandidate != null || !candidate.getName().equals(name)) continue;
                    logicalCandidate = candidate;
                }
            }
            if (!additionalPath.equals(folderPath)) {
                if (logicalCandidate == null) {
                    added = this.projectBridge.createFolder(folder, name);
                    folder.addFolder(added, true);
                } else {
                    added = logicalCandidate;
                }
            }
        }
        return added;
    }

    private boolean upConfiguration(Folder folder, boolean isCPP) {
        CCCCompilerConfiguration cccc;
        CCCCompilerConfiguration cccc2;
        HashSet commonFoldersIncludes = new HashSet();
        HashSet commonFoldersMacros = new HashSet();
        boolean haveSubFolders = false;
        for (Folder subFolder : folder.getFolders()) {
            CCCCompilerConfiguration cccc3;
            if (!this.upConfiguration(subFolder, isCPP)) continue;
            if (!haveSubFolders) {
                cccc3 = this.projectBridge.getFolderConfiguration(isCPP, subFolder);
                if (cccc3 == null) continue;
                commonFoldersIncludes.addAll(cccc3.getIncludeDirectories().getValue());
                commonFoldersMacros.addAll(cccc3.getPreprocessorConfiguration().getValue());
                haveSubFolders = true;
                continue;
            }
            if (commonFoldersIncludes.size() > 0 && (cccc3 = this.projectBridge.getFolderConfiguration(isCPP, subFolder)) != null) {
                commonFoldersIncludes.retainAll(cccc3.getIncludeDirectories().getValue());
            }
            if (commonFoldersMacros.size() <= 0 || (cccc3 = this.projectBridge.getFolderConfiguration(isCPP, subFolder)) == null) continue;
            commonFoldersMacros.retainAll(cccc3.getPreprocessorConfiguration().getValue());
        }
        HashSet commonFilesIncludes = new HashSet();
        HashSet commonFilesMacros = new HashSet();
        boolean first = true;
        if (haveSubFolders) {
            commonFilesIncludes = new HashSet(commonFoldersIncludes);
            commonFilesMacros = new HashSet(commonFoldersMacros);
            first = false;
        }
        for (Item item : folder.getItemsAsArray()) {
            if (item.isExcluded()) continue;
            cccc2 = this.projectBridge.getItemConfiguration(item);
            if (!isCPP ? !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
            if (first) {
                commonFilesIncludes.addAll(cccc2.getIncludeDirectories().getValue());
                commonFilesMacros.addAll(cccc2.getPreprocessorConfiguration().getValue());
                first = false;
                continue;
            }
            if (commonFilesIncludes.size() > 0) {
                commonFilesIncludes.retainAll(cccc2.getIncludeDirectories().getValue());
            }
            if (commonFilesMacros.size() <= 0) continue;
            commonFilesMacros.retainAll(cccc2.getPreprocessorConfiguration().getValue());
        }
        if (commonFilesIncludes.size() > 0 || commonFilesMacros.size() > 0) {
            for (Item item : folder.getItemsAsArray()) {
                ArrayList list;
                cccc2 = this.projectBridge.getItemConfiguration(item);
                if (!isCPP ? !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
                if (commonFilesIncludes.size() > 0) {
                    list = new ArrayList(cccc2.getIncludeDirectories().getValue());
                    list.removeAll(commonFilesIncludes);
                    cccc2.getIncludeDirectories().setValue(list);
                }
                if (commonFilesMacros.size() <= 0) continue;
                list = new ArrayList(cccc2.getPreprocessorConfiguration().getValue());
                list.removeAll(commonFilesMacros);
                cccc2.getPreprocessorConfiguration().setValue(list);
            }
        }
        if (commonFilesIncludes.size() > 0 && (cccc = this.projectBridge.getFolderConfiguration(isCPP, folder)) != null) {
            cccc.getIncludeDirectories().setValue(new ArrayList(commonFilesIncludes));
        }
        if (commonFilesMacros.size() > 0 && (cccc = this.projectBridge.getFolderConfiguration(isCPP, folder)) != null) {
            cccc.getPreprocessorConfiguration().setValue(new ArrayList(commonFilesMacros));
        }
        return !first;
    }

    public Set<Project> makeProject() {
        if (this.projectBridge.isValid()) {
            this.process();
            return this.projectBridge.getResult();
        }
        return Collections.emptySet();
    }

    private Set<String> getSourceFolders() {
        HashSet<String> used = new HashSet<String>();
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration file : conf.getFiles()) {
                int i;
                String path = file.getFilePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((i = path.lastIndexOf(47)) > 0) {
                    path = path.substring(0, i + 1);
                }
                used.add(path);
            }
        }
        return used;
    }

    private Map<String, Folder> prefferedFolders() {
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        for (Item item : this.projectBridge.getAllSources()) {
            int i;
            String path = item.getAbsPath();
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            if (path.indexOf("/../") >= 0 || path.indexOf("/./") >= 0) {
                path = CndFileUtils.normalizeFile((File)new File(path)).getAbsolutePath();
            }
            if ((i = path.lastIndexOf(47)) < 0) continue;
            String folder = path.substring(0, i);
            folders.put(folder, item.getFolder());
        }
        return folders;
    }

    private void addAdditional(Folder folder, String base, Set<Item> usedItems) {
        Set<String> folders = this.getSourceFolders();
        HashSet<String> used = new HashSet<String>();
        HashSet<String> needAdd = new HashSet<String>();
        HashSet<String> needCheck = new HashSet<String>();
        List<String> list = this.wizard.getIncludedFiles();
        Map<String, Folder> preffered = this.prefferedFolders();
        for (String name : list) {
            used.add(name);
            String path = this.projectBridge.getRelativepath(name);
            Item item = this.projectBridge.getProjectItem(path);
            if (item == null) {
                String folderPath;
                Folder prefferedFolder;
                int i;
                path = name;
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                boolean bl = false;
                if (path.startsWith(base)) {
                    bl = true;
                } else {
                    for (String dir : folders) {
                        if (!path.startsWith(dir)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (i = path.lastIndexOf(47)) >= 0 && (prefferedFolder = preffered.get(folderPath = path.substring(0, i))) != null) {
                    item = this.projectBridge.createItem(name);
                    if (!MIMENames.isCppOrC((String)(item = prefferedFolder.addItem(item)).getMIMEType())) {
                        needCheck.add(path);
                    }
                    bl = false;
                }
                if (!bl) continue;
                needCheck.add(path);
                needAdd.add(name);
                continue;
            }
            if (!usedItems.contains(item)) {
                ProjectBridge.setExclude(item, false);
                this.projectBridge.setHeaderTool(item);
                continue;
            }
            if (MIMENames.isCppOrC((String)item.getMIMEType())) continue;
            needCheck.add(path);
        }
        if (needAdd.size() > 0) {
            AbstractRoot additional = UnusedFactory.createRoot(needAdd);
            this.addAdditionalFolder(folder, additional);
        }
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration fileConfiguration : conf.getFiles()) {
                used.add(fileConfiguration.getFilePath());
            }
        }
        HashSet<String> relatives = new HashSet<String>();
        for (String name : used) {
            relatives.add(this.projectBridge.getRelativepath(name));
        }
        TreeMap<String, Item> sorted = new TreeMap<String, Item>();
        for (Item item : this.projectBridge.getAllSources()) {
            if (usedItems.contains(item)) continue;
            sorted.put(item.getPath(), item);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            Item item;
            String path = (String)entry.getKey();
            item = (Item)entry.getValue();
            String canonicalPath = item.getNormalizedFile().getAbsolutePath();
            if (relatives.contains(path) || used.contains(path) || relatives.contains(canonicalPath) || used.contains(canonicalPath)) continue;
            if (DEBUG) {
                System.out.println("Exclude Item " + path);
            }
            ProjectBridge.setExclude(item, true);
        }
        if (needCheck.size() > 0) {
            this.projectBridge.checkForNewExtensions(needCheck);
        }
    }

    private void addAdditionalFolder(Folder folder, AbstractRoot used) {
        String name = used.getName();
        Folder added = this.getOrCreateFolder(folder, name, used);
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        }
        for (AbstractRoot sub : used.getChildren()) {
            this.addAdditionalFolder(added, sub);
        }
        List<String> files = used.getFiles();
        if (files != null) {
            for (String file : files) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item != null) {
                    if (item.getFolder() != added) {
                        Object old = this.projectBridge.getAuxObject(item);
                        item.getFolder().removeItem(item);
                        item = added.addItem(item);
                        if (old != null) {
                            this.projectBridge.setAuxObject(item, old);
                        }
                    }
                    ProjectBridge.setExclude(item, false);
                    this.projectBridge.setHeaderTool(item);
                    continue;
                }
                item = this.projectBridge.createItem(file);
                item = added.addItem(item);
                ProjectBridge.setExclude(item, false);
                this.projectBridge.setHeaderTool(item);
            }
        }
    }

    private void setupCompilerConfiguration(ProjectConfiguration config) {
        if ("project".equals(this.level)) {
            HashSet<String> set = new HashSet<String>();
            HashMap<String, String> macros = new HashMap<String, String>();
            for (FileConfiguration file : config.getFiles()) {
                this.reConsolidatePaths(set, file);
                macros.putAll(file.getUserMacros());
            }
            ArrayList<String> vector = new ArrayList<String>(set);
            List<String> buf = this.buildMacrosString(macros);
            this.projectBridge.setupProject(vector, buf, config.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        } else {
            List<String> vector = Collections.emptyList();
            List<String> buf = Collections.emptyList();
            this.projectBridge.setupProject(vector, buf, config.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        }
    }

    private List<String> buildMacrosString(Map<String, String> map) {
        ArrayList<String> vector = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                vector.add(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            vector.add(entry.getKey());
        }
        return vector;
    }

    private void setupFile(FileConfiguration config, Item item, boolean isCPP) {
        this.projectBridge.setSourceTool(item, isCPP);
        if ("file".equals(this.level)) {
            HashSet<String> set = new HashSet<String>();
            HashMap<String, String> macros = new HashMap<String, String>();
            this.reConsolidatePaths(set, config);
            macros.putAll(config.getUserMacros());
            ArrayList<String> vector = new ArrayList<String>(set);
            List<String> buf = this.buildMacrosString(macros);
            this.projectBridge.setupFile(config.getCompilePath(), vector, !config.overrideIncludes(), buf, !config.overrideMacros(), item);
        } else {
            List<String> vector = Collections.emptyList();
            List<String> buf = Collections.emptyList();
            this.projectBridge.setupFile(config.getCompilePath(), vector, true, buf, true, item);
        }
    }

    private void reConsolidatePaths(Set<String> set, FileConfiguration file) {
        String compilePath = file.getCompilePath();
        for (String path : file.getUserInludePaths()) {
            if (!(path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':')) {
                path = path.equals(".") ? compilePath : compilePath + File.separator + path;
                File f = new File(path);
                path = CndFileUtils.normalizeFile((File)f).getAbsolutePath();
            }
            set.add(this.projectBridge.getRelativepath(path));
        }
        if (this.isDifferentCompilePath(file.getFilePath(), compilePath)) {
            set.add(this.projectBridge.getRelativepath(compilePath));
        }
    }

    private boolean isDifferentCompilePath(String name, String path) {
        int i;
        if (Utilities.isWindows()) {
            name = name.replace('\\', '/');
        }
        return (i = name.lastIndexOf(47)) > 0 && !(name = name.substring(0, i)).equals(path);
    }

    private void addConfiguration(Folder sourceRoot, ProjectConfiguration conf, Set<Item> used) {
        Folder folder;
        Set<Pair> files;
        Cloneable folders;
        boolean isCPP = conf.getLanguageKind() == ItemProperties.LanguageKind.CPP;
        Map<String, Set<Pair>> configurationStructure = this.analyzeConfigurationStructure(conf.getFiles(), isCPP);
        List<Pair> orphan = this.detectOrphan(configurationStructure, isCPP);
        if (orphan.size() > 0) {
            this.createOrphan(sourceRoot, orphan, isCPP);
        }
        if ("folder".equals(this.level)) {
            folders = new HashMap();
            for (Map.Entry<String, Set<Pair>> entry : configurationStructure.entrySet()) {
                files = entry.getValue();
                for (Pair pair : files) {
                    if (pair.item != null) {
                        folder = pair.item.getFolder();
                        HashSet<FileConfiguration> content = (HashSet<FileConfiguration>)folders.get(folder);
                        if (content == null) {
                            content = new HashSet<FileConfiguration>();
                            folders.put(folder, content);
                        }
                        content.add(pair.fileConfiguration);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.err.println("Cannot find pair by path " + pair.fileConfiguration.getFilePath());
                }
            }
            for (Map.Entry<String, Set<Pair>> entry : folders.entrySet()) {
                Folder folder2 = (Folder)entry.getKey();
                Set<Pair> confs = entry.getValue();
                HashSet<String> inludes = new HashSet<String>();
                HashMap<String, String> macros = new HashMap<String, String>();
                for (FileConfiguration fileConfiguration : confs) {
                    this.reConsolidatePaths(inludes, fileConfiguration);
                    macros.putAll(fileConfiguration.getUserMacros());
                }
                List<String> buf = this.buildMacrosString(macros);
                ArrayList<String> arrayList = new ArrayList<String>(inludes);
                this.projectBridge.setupFolder(arrayList, false, buf, false, conf.getLanguageKind() == ItemProperties.LanguageKind.CPP, folder2);
            }
        } else {
            folders = new HashSet();
            for (Map.Entry<String, Set<Pair>> entry : configurationStructure.entrySet()) {
                files = entry.getValue();
                for (Pair pair : files) {
                    if (pair.item == null) continue;
                    folder = pair.item.getFolder();
                    folders.add(folder);
                }
            }
            Iterator<Map.Entry<String, Set<Pair>>> i$ = folders.iterator();
            while (i$.hasNext()) {
                Folder folder2 = (Folder)i$.next();
                List<String> buf = Collections.emptyList();
                List<String> vector = Collections.emptyList();
                this.projectBridge.setupFolder(vector, true, buf, true, conf.getLanguageKind() == ItemProperties.LanguageKind.CPP, folder2);
            }
        }
        for (Set<Pair> set : configurationStructure.values()) {
            for (Pair pair : set) {
                if (pair.item == null) continue;
                used.add(pair.item);
            }
        }
    }

    private void createOrphan(Folder sourceRoot, List<Pair> orphan, boolean isCPP) {
        HashMap<String, Pair> folders = new HashMap<String, Pair>();
        for (Pair pair : orphan) {
            String path = pair.fileConfiguration.getFilePath();
            folders.put(path, pair);
        }
        AbstractRoot additional = UnusedFactory.createRoot(folders.keySet());
        this.addFolder(sourceRoot, additional, folders, isCPP);
    }

    private void addFolder(Folder folder, AbstractRoot additional, Map<String, Pair> folders, boolean isCPP) {
        String name = additional.getName();
        Folder added = this.getOrCreateFolder(folder, name, additional);
        for (AbstractRoot sub : additional.getChildren()) {
            this.addFolder(added, sub, folders, isCPP);
        }
        for (String file : additional.getFiles()) {
            Pair pair = folders.get(file);
            if (pair != null) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item == null) {
                    item = this.projectBridge.createItem(file);
                    added.addItem(item);
                } else if (DEBUG) {
                    System.err.println("Orphan pair found by path " + file);
                }
                pair.item = item;
                this.setupFile(pair.fileConfiguration, pair.item, isCPP);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Cannot find pair by path " + file);
        }
    }

    private List<Pair> detectOrphan(Map<String, Set<Pair>> configurationStructure, boolean isCPP) {
        Map<String, Folder> preffered = this.prefferedFolders();
        ArrayList<Pair> orphan = new ArrayList<Pair>();
        for (Map.Entry<String, Set<Pair>> entry : configurationStructure.entrySet()) {
            Set<Pair> files = entry.getValue();
            Folder folder = null;
            ArrayList<Pair> list = new ArrayList<Pair>();
            for (Pair pair : files) {
                int i;
                Item item = pair.item;
                if (item != null) {
                    if (folder == null) continue;
                    folder = item.getFolder();
                    continue;
                }
                String prefferedFolder = pair.fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    prefferedFolder = prefferedFolder.replace('\\', '/');
                }
                if ((i = prefferedFolder.lastIndexOf(47)) >= 0) {
                    prefferedFolder = prefferedFolder.substring(0, i);
                    folder = preffered.get(prefferedFolder);
                }
                list.add(pair);
            }
            if (folder != null) {
                for (Pair pair : list) {
                    String relPath = this.projectBridge.getRelativepath(pair.fileConfiguration.getFilePath());
                    Item item = this.projectBridge.getProjectItem(relPath);
                    if (item == null) {
                        item = this.projectBridge.createItem(pair.fileConfiguration.getFilePath());
                        pair.item = item;
                        folder.addItem(item);
                    }
                    this.setupFile(pair.fileConfiguration, item, isCPP);
                }
                continue;
            }
            for (Pair pair : list) {
                orphan.add(pair);
            }
        }
        return orphan;
    }

    private Map<String, Set<Pair>> analyzeConfigurationStructure(List<FileConfiguration> files, boolean isCPP) {
        HashMap<String, Set<Pair>> folders = new HashMap<String, Set<Pair>>();
        for (FileConfiguration file : files) {
            String relPath;
            Item item;
            int i;
            String path = file.getFilePath();
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            if ((i = path.lastIndexOf(47)) < 0) continue;
            String folder = path.substring(0, i);
            HashSet<Pair> set = (HashSet<Pair>)folders.get(folder);
            if (set == null) {
                set = new HashSet<Pair>();
                folders.put(folder, set);
            }
            if ((item = this.projectBridge.getProjectItem(relPath = this.projectBridge.getRelativepath(path))) != null) {
                this.setupFile(file, item, isCPP);
            }
            set.add(new Pair(file, item));
        }
        return folders;
    }

    private static class Pair {
        private FileConfiguration fileConfiguration;
        private Item item;

        private Pair(FileConfiguration fileConfiguration, Item item) {
            this.fileConfiguration = fileConfiguration;
            this.item = item;
        }
    }
}

