/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.util.Lookup;

public abstract class PkgConfigManager {
    private static PkgConfigManager DEFAULT = new Default();

    public abstract PkgConfig getPkgConfig(MakeConfiguration var1);

    protected PkgConfigManager() {
    }

    public static synchronized PkgConfigManager getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends PkgConfigManager {
        private final Lookup.Result<PkgConfigManager> res = Lookup.getDefault().lookupResult(PkgConfigManager.class);
        private static final boolean FIX_SERVICE = true;
        private PkgConfigManager fixedSelector;

        Default() {
        }

        private PkgConfigManager getService() {
            PkgConfigManager service = this.fixedSelector;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    PkgConfigManager selector;
                    service = selector = (PkgConfigManager)i$.next();
                }
                if (service != null) {
                    this.fixedSelector = service;
                }
            }
            return service;
        }

        @Override
        public PkgConfig getPkgConfig(MakeConfiguration conf) {
            PkgConfigManager service = this.getService();
            if (service != null) {
                return service.getPkgConfig(conf);
            }
            return null;
        }
    }

    public static interface ResolvedPath {
        public String getIncludePath();

        public Collection<PackageConfiguration> getPackages();
    }

    public static interface PackageConfiguration {
        public String getName();

        public Collection<String> getIncludePaths();

        public Collection<String> getMacros();
    }

    public static interface PkgConfig {
        public PackageConfiguration getPkgConfig(String var1);

        public Collection<ResolvedPath> getResolvedPath(String var1);
    }
}

