/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.sequece;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SequenceDefaultTableEditor
extends JRadioButton
implements TableCellRenderer,
TableCellEditor,
ActionListener,
ItemListener {
    private JPanel panel = new JPanel();
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public SequenceDefaultTableEditor() {
        this.addActionListener(this);
        this.addItemListener(this);
        this.setHorizontalAlignment(0);
        this.setBackground(Color.WHITE);
        this.panel.setBackground(Color.WHITE);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof Boolean) {
            Boolean bl3 = (Boolean)object;
            this.setSelected(bl3);
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
                this.panel.setForeground(jTable.getSelectionForeground());
                this.panel.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
                this.panel.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                this.panel.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.panel.setBorder(border);
                if (!bl && jTable.isCellEditable(n, n2)) {
                    Color color = UIManager.getColor("Table.focusCellForeground");
                    if (color != null) {
                        super.setForeground(color);
                    }
                    if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(color);
                    }
                }
            } else {
                this.panel.setBorder(noFocusBorder);
            }
            return this.panel;
        }
        throw new IllegalArgumentException("Only Boolean can be rendered!");
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof Boolean) {
            this.setSelected((Boolean)object);
            return this;
        }
        throw new IllegalArgumentException("Only Boolean can be edited.");
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.fireEditingStopped();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }
}

