/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class EarSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean dirty;

    EarSources(Project project, AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            public SourceGroup[] run() {
                if (EarSources.this.dirty) {
                    EarSources.this.delegate.removeChangeListener((ChangeListener)EarSources.this);
                    EarSources.this.delegate = EarSources.this.initSources();
                    EarSources.this.delegate.addChangeListener((ChangeListener)EarSources.this);
                    EarSources.this.dirty = false;
                }
                return EarSources.this.delegate.getSourceGroups(type);
            }
        });
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        String configFilesLabel = NbBundle.getMessage(EarSources.class, (String)"LBL_Node_ConfigBase");
        sourcesHelper.addPrincipalSourceRoot("${meta.inf}", configFilesLabel, null, null);
        sourcesHelper.registerExternalRoots(0);
        return sourcesHelper.createSources();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        EarSources earSources = this;
        synchronized (earSources) {
            this.dirty = true;
        }
        this.changeSupport.fireChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }
}

