/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.io.File;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullOtherAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullOther";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        int repositoryModeMask = 100;
        String title = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
        final JButton pullButton = new JButton();
        final Repository repository = new Repository(repositoryModeMask, title, true);
        repository.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pullButton.setEnabled(repository.isValid());
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)pullButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Pull"));
        pullButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Pull"));
        pullButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Pull"));
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Cancel"));
        boolean dataValid = repository.isValid();
        pullButton.setEnabled(dataValid);
        Object option = repository.show(NbBundle.getMessage(PullOtherAction.class, (String)"CTL_PullDialog_Title"), new HelpCtx(PullOtherAction.class), new Object[]{pullButton, cancelButton}, true, "hg.pull.dialog");
        if (option == pullButton) {
            HgURL pullSource;
            try {
                pullSource = repository.getUrl();
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Could not pull because of invalid URI." + repository.getUrlString());
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Invalid URI: " + repository.getUrlString());
                return;
            }
            PullOtherAction.pull(context, root, pullSource);
        }
    }

    public static void pull(final VCSContext ctx, final File root, final HgURL pullSource) {
        if (root == null || pullSource == null) {
            return;
        }
        final String fromPrjName = NbBundle.getMessage(PullAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        final String toPrjName = HgProjectUtils.getProjectName(root);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                PullAction.performPull(PullAction.PullType.OTHER, ctx, root, pullSource, fromPrjName, toPrjName, this.getLogger());
            }
        };
        support.start(rp, root, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS"));
    }
}

