/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.util;

import java.io.File;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SymfonyUtils {
    public static final String ACTION_METHOD_PREFIX = "execute";
    public static final String ACTION_CLASS_SUFFIX = "actions";
    private static final String FILE_ACTION = "actions.class.php";
    private static final String FILE_ACTION_RELATIVE = "../actions/actions.class.php";
    private static final String DIR_TEMPLATES = "templates";
    private static final String VIEW_FILE_SUFFIX = "Success.php";
    private static final String FILE_VIEW = "../templates/%sSuccess.php";
    private static final String FILE_DEFAULT_VIEW = "index";

    private SymfonyUtils() {
    }

    public static boolean isView(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        return DIR_TEMPLATES.equals(file.getParentFile().getName());
    }

    public static boolean isViewWithAction(FileObject fo) {
        return SymfonyUtils.isView(fo) && SymfonyUtils.getAction(fo) != null;
    }

    public static boolean isAction(FileObject fo) {
        return FILE_ACTION.equals(fo.getNameExt());
    }

    public static FileObject getAction(FileObject fo) {
        File parent = FileUtil.toFile((FileObject)fo).getParentFile();
        File action = PropertyUtils.resolveFile((File)parent, (String)FILE_ACTION_RELATIVE);
        if (action.isFile()) {
            return FileUtil.toFileObject((File)action);
        }
        return null;
    }

    public static String getActionName(FileObject view) {
        return ACTION_METHOD_PREFIX + view.getNameExt().replace(VIEW_FILE_SUFFIX, "").toLowerCase();
    }

    public static FileObject getView(FileObject fo, PhpBaseElement phpElement) {
        String methodName;
        FileObject view = null;
        if (phpElement instanceof PhpClass.Method && (methodName = phpElement.getName()).startsWith(ACTION_METHOD_PREFIX)) {
            String partName = methodName.substring(ACTION_METHOD_PREFIX.length());
            view = SymfonyUtils.getView(fo, partName.substring(0, 1).toLowerCase() + partName.substring(1));
        }
        if (view == null) {
            view = SymfonyUtils.getDefaultView(fo);
        }
        return view;
    }

    private static FileObject getDefaultView(FileObject fo) {
        return SymfonyUtils.getView(fo, FILE_DEFAULT_VIEW);
    }

    private static FileObject getView(FileObject fo, String viewName) {
        File parent = FileUtil.toFile((FileObject)fo).getParentFile();
        File view = PropertyUtils.resolveFile((File)parent, (String)String.format(FILE_VIEW, viewName));
        if (view.isFile()) {
            return FileUtil.toFileObject((File)view);
        }
        return null;
    }
}

