/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.table.HTMLLabelTableCellRenderer;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;

public abstract class ProfilingPoint {
    static final String PROPERTY_NAME = "p_name";
    static final String PROPERTY_ENABLED = "p_enabled";
    static final String PROPERTY_PROJECT = "p_project";
    static final String PROPERTY_RESULTS = "p_results";
    static final String PROPERTY_CUSTOM = "p_custom";
    private final ProfilingPointFactory factory;
    private Project project;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResultsRenderer resultsRenderer;
    private String name;
    private boolean enabled = true;

    ProfilingPoint(String string, Project project, ProfilingPointFactory profilingPointFactory) {
        this.name = string;
        this.project = project;
        this.factory = profilingPointFactory;
    }

    public final ProfilingPointFactory getFactory() {
        return this.factory;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        this.getChangeSupport().firePropertyChange(PROPERTY_ENABLED, !this.enabled, this.enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String string) {
        if (this.name.equals(string) || string == null) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_NAME, string2, this.name);
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean hasResults();

    public abstract void hideResults();

    public abstract void showResults(URL var1);

    public ResultsRenderer getResultsRenderer() {
        if (this.resultsRenderer == null) {
            this.resultsRenderer = new ResultsRenderer();
        }
        return this.resultsRenderer;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void customize() {
        final ValidityAwarePanel validityAwarePanel = this.getCustomizer();
        ProfilingPointsManager.getDefault().customize(validityAwarePanel, new Runnable(){

            @Override
            public void run() {
                ProfilingPoint.this.setValues(validityAwarePanel);
            }
        });
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public boolean supportsProfilingSettings(ProfilingSettings profilingSettings) {
        return (profilingSettings.getProfilingType() == 8 || profilingSettings.getProfilingType() == 16) && this.getFactory().supportsCPU() || (profilingSettings.getProfilingType() == 2 || profilingSettings.getProfilingType() == 4) && this.getFactory().supportsMemory() || profilingSettings.getProfilingType() == 1 && this.getFactory().supportsMonitor();
    }

    public String toString() {
        return this.getName();
    }

    protected abstract String getResultsText();

    protected abstract void updateCustomizer(ValidityAwarePanel var1);

    protected PropertyChangeSupport getChangeSupport() {
        return this.propertyChangeSupport;
    }

    abstract void setValues(ValidityAwarePanel var1);

    abstract void reset();

    ValidityAwarePanel getCustomizer() {
        ValidityAwarePanel validityAwarePanel = this.getFactory().getCustomizer();
        if (validityAwarePanel != null) {
            this.updateCustomizer(validityAwarePanel);
        }
        return validityAwarePanel;
    }

    public class ResultsRenderer
    extends HTMLLabelTableCellRenderer {
        private JTable lastTable;

        public ResultsRenderer() {
            this(11, false);
        }

        public ResultsRenderer(int n, boolean bl) {
            super(n, bl);
        }

        public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new ResultsRenderer(this.getHorizontalAlignment(), true).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public void dispatchMouseEvent(MouseEvent mouseEvent) {
            this.label.dispatchEvent((AWTEvent)SwingUtilities.convertMouseEvent((Component)((Object)this), mouseEvent, (Component)this.label));
        }

        protected void setValue(JTable jTable, Object object, int n, int n2) {
            this.lastTable = jTable;
            this.label.setText(ProfilingPoint.this.getResultsText());
        }

        protected void handleCursor(Cursor cursor) {
            if (this.lastTable != null) {
                this.lastTable.setCursor(cursor);
            }
        }

        protected void handleLink(URL uRL) {
            ProfilingPoint.this.showResults(uRL);
        }
    }
}

